/*	menu.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	8/21/0 02:17PM
$Header: /cvsroot/jedi/include/jedi/menu.h,v 1.11 2000/09/15 12:56:24 tomyeh Exp $
Purpose:	Menu Functions
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_menu_H
#define _is_jedi_menu_H

//////////////////////////////////////////////////////////
#define ERRM_NOMENU				(ERR_MENU | 1)
#define ERRM_NOTFOUND			(ERR_MENU | 2)
#define ERRM_SAMEID				(ERR_MENU | 3)
#define ERRM_TOOMANYITEMS		(ERR_MENU | 4)
#define ERRM_OUTOFMEMORY		(ERR_MENU | 5)

#define MENU_XOFS					3
#define MENU_YOFS					1
#define SUBMENU_XOFS				3
#define SUBMENU_YOFS				0
#define	MENU_SEPARATOR_YOFS			1

#define MENU_BUTTON_CAUSE			0
#define MENU_COMMAND_CAUSE			1

#define	MENU_SEPARATOR_CHAR			'-'

enum TCmdbarResult {
	CMDBARRESULT_NONE, CMDBARRESULT_CHAR,
	CMDBARRESULT_MENUITEM, CMDBARRESULT_NOTIFY};

//////////////////////////////////////////////////////////
typedef struct TWin* _hwin_t;

typedef struct TMenubarAttr {
	__u16 _BF5(		visible:1,
					commandPending:1,
					insPtEnabled:1,
					needsRecalc:1,
					reserved:12);
} TMenubarAttr;

typedef struct TMenuItem {
	__u16			id;
	char			command;
	__u8 _BF2(		hidden:1,
		 			reserved:7);   
	char			*itemStr;
} TMenuItem;

typedef struct TMenuPullDown {
	_hwin_t			menuWin;
	TRect			bounds;
	_hwin_t			bitsBehind;
	TRect			titleBounds;
	char			*title;
	__u16 _BF2(		hidden:1,
					numItems:15);
	TMenuItem		*items;
} TMenuPullDown;

typedef struct TMenubar {
	_hwin_t			barWin;
	_hwin_t			bitsBehind;
	_hwin_t			savedActiveWin;
	_hwin_t			bitsBehindStatus;
	TMenubarAttr	attr;
	__s16			curMenu;
	__s16			curItem;
	__s32			commandTick;
	__s16			numMenus;
	TMenuPullDown	*menus;
} TMenubar;

//////////////////////////////////////////////////////////
EXTERN_C TMenubar* _AAPI mnuCreate(__u16 resId);
EXTERN_C void _AAPI mnuDestroy(TMenubar* p);
EXTERN_C void _JAPI mnuAppCleanup(TAppLocal* app);

EXTERN_C _err_t _AAPI mnuAddPullDown(__u16 index, const char* text);
	//if index exceeds # of pull-down menus, it considered as appending to the right
EXTERN_C _err_t _AAPI mnuAddItem(__u16 idAfter, __u16 id, char shortcut, const char* text);
EXTERN_C bool _AAPI mnuHideItem(__u16 id);
EXTERN_C bool _AAPI mnuShowItem(__u16 id);

inline TMenubar* _AAPI mnuGetActive(void) {extern TMenubar* g_mnuActive; return g_mnuActive;}
	//don't save the returned value for later use because it might
	//be free-ed after the associate form becomes inactive.
EXTERN_C TMenubar* _JAPI mnuSetActive(TMenubar* p);
	//Note: mnuSetActive won't automatically delete p
EXTERN_C void _AAPI mnuSetActiveRes(__u16 resId);

EXTERN_C void _AAPI mnuPopup(TMenubar* menu DEFAULTVAL(0));
EXTERN_C void _JAPI mnuDismiss(void);
	//Popup and dismiss the active menu
	//The menu argument of mnuPopup is ignored (Please pass zero)
	//Future: menu==0 for active menu; non zero for popup menu

EXTERN_C _err_t _AAPI mnuCmdbarAddItem(__u16 where, __u16 resIdBmp, __u16 resultType, __u32 result, char* text);
EXTERN_C bool _AAPI mnuCmdbarGetItem(__u16 where, __u16* resIdBmp, __u16* resultType, __u32* result, char* text);

EXTERN_C void _AAPI mnuCmdbarPopup(void);
EXTERN_C void _JAPI mnuCmdbarDismiss(void);

EXTERN_C bool _AAPI mnuHandleEvent(TMenubar *menu, TEvent *event, __u16 *err);

//////////////////////////////////////////////////////////
//Internal API
EXTERN_C void _JAPI mnuInitActiveCache(void);
	//Initial the active cache if not inited yet
EXTERN_C void _JAPI mnuDeleteActiveCache(void);
	//Delete the cached active menu if any
#endif //_is_jedi_menu_H
