/*	launch.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	8/8/0 05:22PM
$Header: /cvsroot/jedi/include/jedi/launch.h,v 1.10 2000/10/03 10:24:52 tomyeh Exp $
Purpose:	Launcher
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_launch_H
#define _is_jedi_launch_H

///////////////////////////////////////////////////////
struct TLaunchInfo {
	//input
	__u16		flags;
	__u16		cmd;
	void*		cmdPBP;
	char		prcName[MAX_DB_NAME_LEN];

	//output
	union {
		__s32	result;
		__u32	nThdId;
	} out;
};

struct TAnakinApi;
struct TAnakinExApi;

///////////////////////////////////////////////////////
#ifdef __WinCE__
#define DLL_EXT				".dll"
#else
#define DLL_EXT				".so"
#endif
#define APP_JEDIHOME		"JediHome"
#define APP_JEDIVM			"JediVM"
#define APP_JEDIVM_DLL		"JediVM" DLL_EXT

#define PRC_EXT				"prc"
#define PRC_EXT_SIZE		3

//Launch Command
#define	LCMD_NORMALLAUNCH			0
#define	LCMD_FIND					1
#define	LCMD_GOTO					2
#define	LCMD_SYNCNOTIFY				3
#define	LCMD_TIMECHANGE				4
#define	LCMD_SYSTEMRESET			5
#define	LCMD_ALARMTRIGGERED			6
#define	LCMD_DISPLAYALARM			7
#define	LCMD_COUNTRYCHANGE			8
#define	LCMD_SYNCREQUESTLOCAL		9
#define	LCMD_SAVEDATA				10
#define	LCMD_INITDATABASE			11
#define	LCMD_PANELCALLEDFROMAPP		13
#define	LCMD_RETURNFROMPANEL		14
#define	LCMD_LOOKUP				  	15
#define	LCMD_SYSTEMLOCK			  	16
#define	LCMD_SYNCREQUESTREMOTE		17
#define	LCMD_HANDLESYNCCALLAPP		18
#define LCMD_ADDRECORD				19

//Launch Flags
#define	LFLAG_NEWTHREAD				0X01
#define	LFLAG_NEWSTACK				0X02
#define	LFLAG_NEWGLOBALS			0X04
#define	LFLAG_UIAPP					0X08
#define	LFLAG_SUBCALL				0X10
#define LFLAG_DATARELOCATED			0X80

#define LFLAG_NORMALLAUNCH			(LFLAG_NEWSTACK|LFLAG_NEWGLOBALS|LFLAG_UIAPP|LFLAG_DATARELOCATED)

///////////////////////////////////////////////////////
_err_t _JAPI Launch(TLaunchInfo* lf);
	//Launh an application

///////////////////////////////////////////////////////
#include <os/launch.h>

EXTERN_C_BEGIN

_dll_t _JAPI OsDllOpen(const char *name);
void _JAPI OsDllClose(_dll_t dll);

_dll_f _JAPI OsDllGet(_dll_t dll, const char *name);

EXTERN_C_END

///////////////////////////////////////////////////////
#ifndef _JDK_EXPORT
#define _JDK_EXPORT
#endif
EXTERN_C _JDK_EXPORT int _CDECL JediMain(TLaunchInfo* launchInfo);
typedef int _CDECL_PF(_jedimain_f)(TLaunchInfo*);
EXTERN_C _JDK_EXPORT BOOL _CDECL JediAttach(const TAnakinApi* api, const TAnakinExApi* apiEx);
typedef BOOL _CDECL_PF(_jediattach_f)(const TAnakinApi* api, const TAnakinExApi* apiEx);

extern const TAnakinApi gJdk_api;
extern const TAnakinExApi gJdk_apiEx;

#endif //_is_jedi_launch_H
