/*	kernel.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/14/0 03:45PM
	$Header: /cvsroot/jedi/include/jedi/kernel.h,v 1.24 2000/10/03 06:16:13 henrichen Exp $
	Purpose:	The first header to include
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_kernel_H
#define _is_jedi_kernel_H

#include <jedi/defs.h>
#include <jedi/types.h>

/////////////////////////////////////////////////////////////////////
//Utilities
#ifndef Min
#define Min(a, b) (((a) < (b)) ? (a) : (b))
#endif
#ifndef Max
#define Max(a, b) (((a) > (b)) ? (a) : (b))
#endif

#ifdef __cplusplus
template<class T> inline void Swap(T& a,T& b) {a^=b; b^=a; a^=b;}
#endif

#define CountOf(ary)				(sizeof(ary)/sizeof((ary)[0]))
#define OffsetOf(Type, member)		((unsigned)&(((Type*)0)->member))
#define	SizeOf(Type, member)		(sizeof(((Type*)0)->member))
#define _count_of(ary)				CountOf(ary)
#define _offset_of(Type, member)	OffsetOf(Type, member)

/////////////////////////////////////////////////////////////////////
//Constants
#define TO_INFINITE					0xffffffff //infinite timeout
#define MAX_DB_NAME_LEN				(32+4)
#define DEFAULT_STACK_SIZE			(1024*4)

/////////////////////////////////////////////////////////////////////
//Startup functions
EXTERN_C void _JAPI JediStart(const char* prcName);
	//Note: JediStart starts another thread to Load the specified program
	//so you cannot release progName after the call.
EXTERN_C void _JAPI JediStop(void);
	//called when the whole system is going to shutdown

////////////////////////////////////////////////////////
//OSL-dependent functions
#include <os/kernel.h>
#include <stdarg.h>

////////////////////////////////////////////////////////
//Global variables
extern bool g_bSysStopping; //indicate the system is stopping
extern struct TAppLocal* g_listApp;

////////////////////////////////////////////////////////
//Avoid using malloc... directly; Refer to mem.h
#define malloc	avoid_malloc_use_mem_h
#define free	avoid_free_use_mem_h

///////////////////////////////////////////////////////
#ifndef NDEBUG
extern void (*g_pJediTest)(void);
#define DEF_JEDITEST(func)	DEF_SYSINIT(JediTest, g_pJediTest = func)
	//Note: JediTest is running at Jedi mode
#endif //NDEBUG

#endif //_is_jedi_kernel_H
