/*	jedidb.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/29 05:36PM
	$Header: $
	Purpose:	
	Description:	Jedi's DB system. (based on GARRET's minidb)

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_jedidb_H
#define _is_jedi_jedidb_H

#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <minidb/fstor.hpp>
#define	SMART_POINTERS
#include <minidb/oodbs.hpp>
#include <minidb/pstor.hpp>
#include <jedi/smartptr.h>
#include <jedi/rbtree.h>
#include <jedi/arbtree.h>

struct TChunk : public File_Object {
	char	text[1];
};

struct TAppInfo : public File_Object {
	struct TCategoryInfo cat;
};

struct TSortInfo : public TChunk {
};

struct TRecNode : public File_Object {
public:
	DbPtr<TChunk> chunk;
};

//pdb record
struct TPdbNode : public TRecNode {
public:
	__u32	_JDK_BF2(attr: 8, unique: 24);
};

//prc record
struct TPrcNode : public TRecNode {
public:
	__u32	type;
	__u16	id;
};

//db class
struct TJediDBHeader : public File_Object {
public:
	__u8	name[32];
	__u16	attributes;
	__u16	version;
	__u32	creationDate;
	__u32	modificationDate;
	__u32	lastBackupDate;
	__u32	modificationNumber;
	DbPtr<TAppInfo>		appInfo;
	DbPtr<TSortInfo>	sortInfo;
	__u32	type;
	__u32	creator;			
	__u32	uniqueIDSeed;
	DbPtr<CARBTree>		recordList;
};

struct TPrcKey : public TARBKey {
	__u32	type;
	__u16	id;
};

struct TPdbKey : public TARBKey {
	__u32 _JDK_BF2 (
		attr	: 8,
		unique	: 24);
	operator __u32(){return *(__u32*)(&this->unique);}
};

//sorting on attr+unique id
int PdbComp(void *key, CRBNode *node)
{
	TPdbKey *p	= (TPdbKey*) key;
	CARBNode *n	= (CARBNode*) node;
	return (int)(__u32)(p) - 
		(int)(__u32)(((CPdbNode*)(File_Object*)node->GetData())->unique);
}

class CJediDB {
public:
	CJediDB() : 
		m_dbh(NULL), m_cache(NULL), m_file(NULL), 
		m_store(NULL), m_list(NULL), m_db(NULL){}
	_err_t Open(char *name, int mode);
	_err_t Close(void);

	RamPtr<TJediDBHeader> m_dbh;

	Dbs_Pool    *m_cache;
	Dbs_File    *m_file;
	Dbs_F_Store *m_store;
	Dbs_Store	*m_list;
	Object_Database		*m_db;
};

class CPrcJediDB : public CJediDB {
public:
	CPrcJediDB() {}
	
	_err_t Open(char *name, int mode);
	unsigned Search(RamPtr<TARBNode> *node, __u32 type, __u16 id);
	unsigned Search(RamPtr<TARBNode> *node, unsigned index);
	
	bool CreateFromPrc(char *name);
};


#endif //_is_jedi_jedidb_H

