/*	jdxnode.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/23 12:01PM
	$Header: /cvsroot/jedi/include/jedi/jdxnode.h,v 1.3 2000/09/08 11:58:16 henrichen Exp $
	Purpose:	
	Description:	implementation of *.jdx file node. See also jedidb.h.

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_jdxnode_H
#define _is_jedi_jdxnode_H

#include	<jedi/jdxfile.h>

//////////////////////////////////////////////////////////////////
class CJdxFile;
// record in main memory
class CJdxNode : public TJdxRecord {
public:
	CJdxNode(unsigned idx DEFAULTVAL(0), 
		unsigned long off DEFAULTVAL(0), size_t sz DEFAULTVAL(0));

	//utilities
	inline void SetIdx(unsigned idx);
	
	//to be used in RB-tree
	inline bool IsRed(void);
		//check if the node is a red node
	inline bool IsBlack(void);
		//check if the node is a black node
	void SetColor(bool bRed);
		//Set the node color, true(set to red), false(set to black)
	inline void SetRed(void);
		//Set the node color to red
	inline void SetBlack(void);
		//Set the node color to black
		
	//to be used in telling whether the node in array chunk
	inline bool InArrayChunk(void);
	inline void SetInArrayChunk(bool bSet);
	
	//each node can be used to refer a data chunk in *.jdb file
	//	"offset" is the offset (from the *.jdb file top) to the data/free chunk
	//	"size" is the size of the data/free chunk
	inline void SetOffset(unsigned long off);
		//Set node's offset and return the new offset
	inline void SetSize(unsigned long sz);
		//Set node's size and return the new size
	inline unsigned long GetOffset(void);
		//Get node's offset
	inline size_t GetSize(void);
		//Get node's size
	inline unsigned long GetNextOffset(void);
		//Get the next chunk's offset
		
	//load, save
	inline bool Load(CJdxFile *file);
		//load the node from the specified file using m_idx
	inline bool Load(unsigned idx, CJdxFile *file);
		//load the node from the specified file using idx (m_idx was assigned, too)
	inline bool Save(CJdxFile *file);
		//save the node to the specified file using m_idx
	inline bool Save(unsigned idx, CJdxFile *file);
		//sav ethe node to the specified flle using specified idx(m_idx was assigned, too)

	//node attributes
	inline unsigned GetKey(unsigned baseKey);

	//data	
	unsigned m_idx;	//node's idx
};
// flag field overload the bit 0,1 of offset member, so be very careful
#define	JDXNODE_RED				0x01	//the node is a red node in rb-tree
#define	JDXNODE_INARRAYCHUNK	0x02	//the node is in array chunk rb-tree
#define	JDXNODE_FLAGMASK		(JDXNODE_RED|JDXNODE_INARRAYCHUNK)
#define	CHUNK_ALIGN(x)			(((x)+3) & ~3)	//align to 4 bytes

//////////////////////////////////////////////////////////////////
inline bool CJdxNode::IsRed(void)
{
	return (offset & JDXNODE_RED) != 0;
}

inline bool CJdxNode::IsBlack(void)
{
	return !IsRed();
}

inline void CJdxNode::SetRed(void)
{
	SetColor(true);
}

inline void CJdxNode::SetBlack(void)
{
	SetColor(false);
}

inline bool CJdxNode::InArrayChunk(void)
{
	return (offset & JDXNODE_INARRAYCHUNK) != 0;
}

inline void CJdxNode::SetInArrayChunk(bool bSet)
{
	if (bSet)
		offset |= JDXNODE_INARRAYCHUNK;
	else
		offset &= ~JDXNODE_INARRAYCHUNK;
}

inline unsigned long CJdxNode::GetOffset(void)
{
	return offset & ~JDXNODE_FLAGMASK;
}

inline size_t CJdxNode::GetSize(void)
{
	return size;
}

inline unsigned long CJdxNode::GetNextOffset(void)
{
	return GetOffset() + GetSize();
}

inline void CJdxNode::SetOffset(unsigned long off)
{
	offset= (off & ~JDXNODE_FLAGMASK) | (offset & JDXNODE_FLAGMASK);
}

inline void CJdxNode::SetSize(unsigned long sz)
{
	size= sz;
}

inline void CJdxNode::SetIdx(unsigned idx)
{
	m_idx= idx;
}

inline bool CJdxNode::Load(CJdxFile *file)
{
	return file->LoadJdxNode(this);
}

inline bool CJdxNode::Load(unsigned idx, CJdxFile *file)
{
	m_idx= idx;
	return Load(file);
}

inline bool CJdxNode::Save(CJdxFile *file)
{
	return file->SaveJdxNode(this);
}

inline bool CJdxNode::Save(unsigned idx, CJdxFile *file)
{
	m_idx= idx;
	return Save(file);
}

inline unsigned CJdxNode::GetKey(unsigned baseKey)
{
	return baseKey + leftNum;
}
#endif //_is_jedi_jdxnode_H
