/*	jdxfile.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/23 01:54PM
	$Header: /cvsroot/jedi/include/jedi/jdxfile.h,v 1.4 2000/09/08 11:58:16 henrichen Exp $
	Purpose:	
	Description:	
		1.Implementation header of *.jdx file
		2.See also jedidb.h
		
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_jdxfile_H
#define _is_jedi_jdxfile_H

//////////////////////////////////////////////////////////////////
#pragma pack(push, 1)
// header of *.jdx file
#define	JDXFILE_SIG	"ishkjdx"
#define	JDXFILE_VER	0x00001	//version 00.01
struct TJdxHeader {
	char	signature[sizeof(JDXFILE_SIG)];	//file signature
	__u32	version;		//file version
	__u16	arrayChunkIdx;	//root record index of the allocated chunk rb-tree(sorting on array index)
	__u16	freeChunkIdx;	//root record index of the free chunk list(sorting on offset)
	__u16	freeNodeIdx;	//root record index of the free node list(sorting on index)
	__u16	lastIdx;		//last record index of the file
};

// Note all node index start from one(1). zero(0) is reserved as NULL.
// record of *.jdx file
struct TJdxRecord {
	__u16	leftNum;	//number of total left children
	__u16	rightNum;	//number of total right children
	__u16	leftIdx;	//node index to left child(also prev one in freeData list)
	__u16	rightIdx;	//node index to right child(also next one in free/freeData list)
	__u32	offset;		//pointer(file offset from top) to the data chunk in data file
	__u32	size;		//size of the data chunk in data file
};
#pragma pack(pop)


//////////////////////////////////////////////////////////////////
class CJdxNode;
class CJdxFile : public CJediFile {
public:
	//open, close
	bool Open(const char* name, int mode);
		//open the jdx file, extension will be changed to *.jdx
	bool Create(const char* name);
		//create an jdx file, extention will be changed to *.jdx
	bool Delete(const char* name);
		//delete the jdx file
	bool CreateFromJdb(const char *dbname);
		//given a jdb file, create an associated jdx file

	//jdx header
	inline bool LoadJdxHeader(void);
		//load the jdx header
	inline bool SaveJdxHeader(void);
		//save the jdx header
	
	//jdx node
	inline unsigned GetArrayChunkRoot(void);
		//return the data chunk(an rb-tree)'s root
	inline unsigned GetFreeChunkRoot(void);
		//return the free chunk(an linked list)'s root
	inline unsigned GetFreeNodeRoot(void);
		//return the free node(an linked list)'s root
	inline unsigned GetLastNodeIdx(void);
		//return the last node's index
		
	inline bool SetArrayChunkRoot(unsigned idx);
		//set the data chunk(an rb-tree)'s root
	inline bool SetFreeChunkRoot(unsigned idx);
		//set the free chunk(an linked list)'s root
	inline bool SetFreeNodeRoot(unsigned idx);
		//set the free node(an linked list)'s root
	bool SetLastNodeIdx(unsigned idx);
		//set the last node's index
		
	inline unsigned long GetJdxOffset(unsigned idx);
		//return the offset(from jdx file top) of an specified node index
		
	bool LoadJdxNode(CJdxNode *pn);
		//load the node
	bool SaveJdxNode(CJdxNode *pn);
		//save the node
	
	bool SetLeftIdx(unsigned nodeIdx, __u16 idx);
		//Set left child index of the node at nodeIdx
	bool SetRightIdx(unsigned nodeIdx, __u16 idx);
		//Set right child index of the node at nodeIdx
	
	//data
	TJdxHeader	m_ih;
};


//////////////////////////////////////////////////////////////////
inline unsigned CJdxFile::GetArrayChunkRoot(void)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	return m_ih.arrayChunkIdx;
}

inline unsigned CJdxFile::GetFreeChunkRoot(void)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	return m_ih.freeChunkIdx;
}

inline unsigned CJdxFile::GetFreeNodeRoot(void)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	return m_ih.freeNodeIdx;
}

inline unsigned CJdxFile::GetLastNodeIdx(void)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	return m_ih.lastIdx;
}

inline bool CJdxFile::SetArrayChunkRoot(unsigned idx)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	m_ih.arrayChunkIdx= (__u16) idx;
	return SaveJdxHeader();
}

inline bool CJdxFile::SetFreeChunkRoot(unsigned idx)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	m_ih.freeChunkIdx= (__u16) idx;
	return SaveJdxHeader();
}	

inline bool CJdxFile::SetFreeNodeRoot(unsigned idx)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	m_ih.freeNodeIdx= (__u16) idx;
	return SaveJdxHeader();
}

inline unsigned long CJdxFile::GetJdxOffset(unsigned idx)
{
	ASSERT(sizeof(TJdxRecord) == 16 && idx);
	return sizeof(TJdxHeader) + ((idx-1) << 4);
		// (idx-1) * sizeof(TJdxRecord), must minus one because idx start from 1
}

inline bool CJdxFile::LoadJdxHeader(void)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	
	const size_t size= sizeof(TJdxHeader);
	return size == Read(&m_ih, size, 0);
}

inline bool CJdxFile::SaveJdxHeader(void)
{
	ASSERT(m_hfile!= HFILE_INVALID );
	
	const size_t size= sizeof(TJdxHeader);
	return size == Write(&m_ih, size, 0);
}

#define	_STRCPY(str)	strcpy((char*)_alloca(strlen(str)+1), str)
	
#endif //_is_jedi_jdxfile_H
