/*	gdi.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/7/21 10:44AM
	$Header: /cvsroot/jedi/include/jedi/gdi.h,v 1.7 2000/10/12 01:50:46 henrichen Exp $
	Purpose:	
	Description:	Implementation Header of jedi gdiXXX()

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_gdi_H
#define _is_jedi_gdi_H

//////////////////////////////////////////////////////////////////
#define	ERR_COLOR_INVALID	0xffffffff

//////////////////////////////////////////////////////////////////
inline unsigned gdiBppToBitshift(unsigned bpp)
{
	return (bpp < 8) ? (bpp >> 1) : (bpp >> 4) + 3;
}

#define	DISPLAY_BASE	0	//the base address of the frame buffer
#define	DISPLAY_BPP		8	//the color depth of the display

//////////////////////////////////////////////////////////////////
EXTERN_C __s16 _AAPI gdiSetDrawMode(__s16 mode);
EXTERN_C __s16 _AAPI gdiGetDrawMode(void);
EXTERN_C void _AAPI gdiSetPatternType(__s16 ptype);
EXTERN_C __s16 _AAPI gdiGetPatternType(void);
EXTERN_C void _AAPI gdiSetPattern(__u8 *pat);
EXTERN_C void _AAPI gdiGetPattern(__u8 *pat);
EXTERN_C __s16 _AAPI gdiSetUnderlineMode(__s16 mode);
EXTERN_C __s16 _AAPI gdiGetUnderlineMode(void);
EXTERN_C __u8 _AAPI gdiSetForeColor(__u8 color);
EXTERN_C __u8 _AAPI gdiGetForeColor(void);
EXTERN_C __u8 _AAPI gdiSetBackColor(__u8 color);
EXTERN_C __u8 _AAPI gdiGetBackColor(void);
EXTERN_C __u8 _AAPI gdiSetTextColor(__u8 color);
EXTERN_C __u8 _AAPI gdiGetTextColor(void);

//////////////////////////////////////////////////////////////////
EXTERN_C void _JAPI gdiInit(void);
	//Init gdi system. It must be called and only be called once. 
EXTERN_C void _JAPI gdiCleanup(void);
	//clean up gdi system.
EXTERN_C TPalette _JAPI gdiIndexToRGB(TWin *pWin, int index);
	//Given palette index, return palette rgb
	//pWin	: Check the palette of this window; NULL means the screen.
	//index	: The palette index.
	//RETURN: The associated rgb of the index.
	//COMMENT: if the index is out of range, it will return {0,0,0,0}.
EXTERN_C int _JAPI gdiRGBToIndex(TWin *pWin, TPalette rgb);
	//Given palette rgb, return the index with nearest color
	//pWin	: Check the palette of this window; NULL means the screen.
	//rgb	: The rgb to be find.
	//RETURN: The associated index of found rgb in the palette.
	//COMMENT: This function returns the associate palette index of the 
	//		   nearest rgb color in the palette.
EXTERN_C void _JAPI gdiDrawCenterText(
	TWin *pWin, const char *str, TRect *pRect, int corner, TDrawState *pDs);
	//Given string and drawing rectangle, fill the rectangle with background color,
	//center the text in the rectangle.
	//pWin	: Where the rectangle and text are drawing; NULL to draw on screen.
	//pRect	: The rectangle to be drawn
	//corner: Rectangle's corner diameter
	//pDs	: drawing state, NULL to use current drawState
EXTERN_C __u32 _JAPI gdiGetPixel(TWin *pWin, int x, int y);
	//Given (x,y), ruturn the associated palette rgb
	//pWin	: Get pixel from this window; NULL means the screen.
	//x,y	: The pixel position to be get.
	//RETURN: The associated color at (x,y).
EXTERN_C void _JAPI gdiSetPixel(TWin *pWin, int x, int y, TDrawState *pDs);
	//Given (x,y) and draw state, draw a pixel
	//pWin	: Draw pixel to this window; NULL means the screen.
	//x,y	: The pixel position to be drawn.
	//pDs	: Point to the draw state which give colors, transfer mode, etc.; NULL means use current draw state.
EXTERN_C void _JAPI gdiLine(TWin *pWin, int x1, int y1, int x2, int y2, TDrawState *pDs);
	//Given two point and draw state, draw a two point line.
	//pWin	: Draw line to this window; NULL means the screen.
	//x1,y1	: 1st point position of the line
	//x2,y2	: 2nd point position of the line
	//pDs	: Point to the draw state which give colors, transfer mode, etc.; NULL means use current draw state.
	//COMMENT: Note the last point(x2,y2) will not be drawn	
EXTERN_C void _JAPI gdiOutlineRect(TWin *pWin, TRect *pRect, int radius, TDrawState *pDs);
	//Given a round rectangle and draw the outline
	//pWin	: Draw outline of the rectangle to this window; NULL means the screen.
	//pRect: the rectangle
	//radius: The imaging circle radius at four corner of the rectangle.
	//pDs	: Point to the draw state which give colors, transfer mode, etc.; NULL means use current draw state.
	//COMMENT: Note the rectangle right and bottom is not drawn
EXTERN_C void _JAPI gdiFillRect(TWin *pWin, TRect *pRect, int radius, TDrawState *pDs);
	//Given a round rectangle and fill the interior
	//pWin	: Fill the rectangle to this window; NULL means the screen.
	//pRect: the rectangle
	//radius: The imaging circle radius at four corner of the rectangle.
	//pDs	: Point to the draw state which give colors, transfer mode, etc.; NULL means use current draw state.
	//COMMENT: Note the rectangle right and bottom is not drawn
EXTERN_C void _JAPI gdiBitBlt(TWin *pDstWin, int dstX, int dstY, TWin *pSrcWin, const TRect *pSrcRect, TDrawState *pDs);
	//Copy a rectangle from source window to the destination window.
	//pDstWin: The destination window; NULL means the screen.
	//dstX, dstY: The left-top corner of the rectangle at destination window
	//pSrcWin: The source window: NULL means the screen.
	//pSrcRect: The source rectangle
	//pDs	: Point to the draw state which give colors, transfer mode, etc.; NULL means use current draw state.
	//COMMENT: Note the rectangle right and bottom is not included. 
EXTERN_C void _JAPI gdiDrawChars(TWin *pWin, const char *chars, int len, int x, int y, TDrawState *pDs);
	//Draw the characters on the window
	//pWin	: Draw the text on this window; NULL means screen.
	//chars	: Point to the charcters.
	//len	: length in bytes of the chars array.
	//x,y	: the left-top corner of the first char to draw.
	//COMMENT: Note the character in the chars array is not necessary a single byte character.
#endif //_is_jedi_gdi_H
