/*	freechnk.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/24 11:09AM
	$Header: /cvsroot/jedi/include/jedi/freechnk.h,v 1.2 2000/09/06 06:08:43 henrichen Exp $
	Purpose:	
	Description:	Implementation of free chunk list in *.jdx file

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_freechnk_H
#define _is_jedi_freechnk_H

class CJdbFile;
class CJdxFile;
class CJdxNode;
class CFreeChunk {
public:
	CFreeChunk(CJdxFile *file) : m_jdxfile(file) {}
	
	//list manipulation
	bool Attach(CJdxNode *pn);
		//attach a node into free chunk list(sort on chunk offset)
	bool Detach(CJdxNode *pn);
		//detach a node from free chunk list
	bool Search(CJdxNode *pn, unsigned long offset);
		//search a node with the given chunk offset

	bool Alloc(CJdxNode *pn, size_t size);
		//try to allocate space from the free chunks
		//return the found node in pn
	
#ifndef NDEBUG
	bool Check(CJdbFile *jdbfile, unsigned *maxIdx, unsigned long *maxOffset);
	void Dump(void);
#endif

	//data
	CJdxFile *m_jdxfile;
};

#endif //_is_jedi_freechnk_H
