/*	formobj.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	9/13/0 04:28PM
$Header: /cvsroot/jedi/include/jedi/formobj.h,v 1.1 2000/09/15 09:08:31 tomyeh Exp $
Purpose:	TObjxxx functions
Description:
Some functions related to form (frmXxx) are located in form.h
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_formobj_H
#define _is_jedi_formobj_H

////////////////////////////////////////////////////
enum TObjType {
	FOBJ_FIELD,		FOBJ_CTL,			FOBJ_LIST,
	FOBJ_TABLE,		FOBJ_BMP,			FOBJ_LINE,
	FOBJ_FRAME,		FOBJ_RECTANGLE,		FOBJ_LABEL,
	FOBJ_TITLE,		FOBJ_POPUP,			FOBJ_GRAFFITISTATE,
	FOBJ_GADGET,	FOBJ_SCROLLBAR
};

enum TObjCtlStyle { //Styles of TObjCtl
	OBJCTL_BUTTON,				OBJCTL_PUSHBUTTON,
	OBJCTL_CHECKBOX,			OBJCTL_POPUPTRIGGER,
	OBJCTL_SELECTORTRIGGER,		OBJCTL_REPEATINGBUTTON,
	OBJCTL_SLIDER,				OBJCTL_FEEDBACKSLIDER,
	OBJCTL_FIRST=OBJCTL_BUTTON, OBJCTL_LAST=OBJCTL_FEEDBACKSLIDER
};

enum TObjCtlFrame { //Frames of TObjCtl
	OBJCTL_NOFRAME,				OBJCTL_STANDARDFRAME,
	OBJCTL_BOLDFRAME,			OBJCTL_RECTANGLEFRAME
};

////////////////////////////////////////////////////
typedef struct TObjAttr {
	__u16 _BF2(
		usable			:1,
		reserved		:15);

	DECL_SETZEROS(__u16)
} TObjAttr;

typedef struct TObjAttrCtl { //Extended attribute set
	__u16 _BF10(
		usable			:1,
		enabled			:1,
		visible			:1,
		on				:1,
		leftAnchor		:1,
		frame			:3,
		drawnAsSelected	:1,
		graphical		:1,
		vertical		:1,
		reserved		:5);

	DECL_SETZEROS(__u16)
} TObjAttrCtl;

typedef struct TObjAttrGgt { //attribute of FOBJ_GADGET
	__u16 _BF4(
		usable			:1,
		extended		:1,
		visible			:1,
		reserved		:13);

	DECL_SETZEROS(__u16)
} TObjAttrGgt;

typedef struct TObjAttrScrl {
	__u16 _BF5(
		usable			:1,
		visible			:1,
		hilighted		:1,
		shown			:1,
		activeRegion	:4);
} TObjAttrScrl;

////////////////////////////////////////////////////
struct TObjBmp {
	TObjAttr		attr;
	TPoint			pos;
	__u16			resId;
};

struct TObjCtl {
	__u16			id;
	TRect			bounds;
	char			*text;	
	TObjAttrCtl		attr;
	__s16			style;
	__s16			fontId;
	__u8			group;
	__u8 			reserved;
};

typedef bool _AAPI_PF(_objgadget_f)(struct TObjGadget* gdt, __u16 cmd, void *param);

struct TObjGadget {
	__u16			id;
	TObjAttrGgt		attr;
	TRect			bounds;
	const void		*data;
	_objgadget_f	handler;
};

struct TObjGraffitiState {
	TPoint			pos;
};

struct TObjLabel {
	__u16			id;
	TPoint			pos;
	TObjAttr		attr;
	__s16			fontId;
	__u8 			reserved;
	char			*text;
};

struct TObjPopup {
	__u16			ctlId;
	__u16			listId;
};

struct TObjScrollBar {
	TRect			bounds;
	__u16			id;
	TObjAttrScrl	attr;
	__s16			value;
	__s16			minValue;
	__s16			maxValue;
	__s16			pageSize;
	__s16			penPosInCar;
	__s16			savePos;
};

struct TObjSlider {
	__u16			id;
	TRect			bounds;
	__u16			thumbId;
	__u16			bkgndId;
	TObjAttrCtl		attr;
	__s16			style;
	__u8			reserved;		
	__s16			minValue;
	__s16			maxValue;
	__s16			pageSize;
	__s16			value;
	void			*activeSliderP;
};

struct TObjTitle {
	TRect			bounds;
	char			*text;
};

struct TObjFrame {
	__u16		id;
	TObjAttr	attr;
	TRect		rect;
	__u16		frameType;
};

struct TObjLine {
	TObjAttr	attr;
	TPoint		point1;
	TPoint		point2;
};

struct TObjRect {
	TObjAttr	attr;
	TRect		rect;
};

////////////////////////////////////////////////////
//FOBJ_CTN
EXTERN_C bool _AAPI ctlHandleEvent(TObjCtl *ctl, TEvent *evt);

EXTERN_C bool _AAPI ctlValidatePtr(TObjCtl *ctl);

EXTERN_C void _AAPI ctlSetLabel(TObjCtl *ctl, const char *text);

EXTERN_C void _AAPI ctlHide(TObjCtl *ctl);
EXTERN_C void _AAPI ctlShow(TObjCtl *ctl);

EXTERN_C void _AAPI ctlDraw(TObjCtl *ctl);
EXTERN_C void _AAPI ctlErase(TObjCtl *ctl);
EXTERN_C void _AAPI ctlHit(const TObjCtl *ctl);

EXTERN_C __s16 _AAPI ctlGetVal(const TObjCtl *ctl);
EXTERN_C void  _AAPI ctlSetVal(TObjCtl *ctl, __s16 val);

//FOBJ_LABEL
EXTERN_C void _AAPI lblHide(TObjLabel *label);
EXTERN_C void _AAPI lblShow(TObjLabel *label);

EXTERN_C void _AAPI lblDraw(TObjLabel *label);
EXTERN_C void _AAPI lblErase(TObjLabel *label);

#endif //_is_jedi_formobj_H
