/*	form.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/25/0 03:30PM
	$Header: /cvsroot/jedi/include/jedi/form.h,v 1.19 2000/10/03 06:16:13 henrichen Exp $
	Purpose:	Form Management Functions
	Description:
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_form_H
#define _is_jedi_form_H

////////////////////////////////////////////////////
//types defined in other headers
#include <jedi/win.h>
#include <jedi/formobj.h>
struct TEvent;
struct TMenubar;

#define FRM_UPDATECODE_REDRAW			0X8000
	//sent to request for drawing when a form is unable to save bits behind

#define FRM_NO_SELECTED_CTL				0xFF
	//specified no control is selected, used by frmGetCtlGrpSel

#define FRM_TITLE_XOFS					3
#define FRM_TITLE_YOFS					2
#define FRM_MTITLE_XOFS					3
#define FRM_MTITLE_YOFS					1
#define	FRM_IMARK_XOFS					2
#define	FRM_IMARK_YOFS					0
#define	FRM_IMARK_SIZE					13

////////////////////////////////////////////////////
typedef union TObjPtr {
	void						*ptr;
	struct TObjCtl				*ctl;
	struct TObjField			*field;
	struct TObjGraphic			*graphic;
	struct TObjSlider			*slider;
	struct TObjList				*list;
	struct TObjTable			*table;
	struct TObjBmp				*bmp;
	struct TObjLabel			*label;
	struct TObjTitle			*title;	
	struct TObjPopup			*popup;
	struct TObjGraffitiState	*grfState;
	struct TObjGadget			*gadget;
	struct TObjScrollBar		*scrollBar;
} TObjPtr;

typedef struct TObjNode {
	__s16		objType;
	__u16 		reserved;
	TObjPtr		objPtr;
} TObjNode;

typedef struct TFormAttr {
	__u16 _BF12(
			usable:1,
			enabled:1,
			visible:1,
			dirty:1,
			saveBehind:1,
			graffitiShift:1,
			globalsAvailable:1,
			doingDialog:1,
			exitDialog:1,
			reserved:2,
			drawn:1, //Jedi's extension: we use the same bit to denote drawn
			reservedA:4);
	__u16	reserved2;

	DECL_SETZEROS(__u32)
} TFormAttr;

typedef struct TForm {
	TWin		window;
	__u16		frmId;
	TFormAttr	attr;
	_hwin_t		bitsBehindForm;
	bool		_AAPI_PF(handler)(TEvent*);
	__u16		focus;
	__u16		btnIdDefault;
	__u16		resIdHelp;
	__u16		resIdMenu;
	__u16		numObjs;
	TObjNode	*pObjNodes;
} TForm;
extern TForm* g_pFrmActive;

typedef struct TFormActiveState {
	__u16	cbSize;
	__u16	frmIdActive;
} TFormActiveState;


////////////////////////////////////////////////////
//Form
EXTERN_C TForm* _AAPI frmCreate(__u16 frmId, const char* title,
		__s16 x, __s16 y, __s16 wd, __s16 hgh, bool modal,
		__u16 btnIdDefault, __u16 resIdHelp, __u16 resIdMenu);
EXTERN_C TForm* _AAPI frmCreateRsc(__u16 resIdForm);
EXTERN_C void _AAPI frmDestroy(TForm*);

EXTERN_C void _AAPI frmGoto(__u16 frmId);
EXTERN_C void _AAPI frmPopup(__u16 frmId);
EXTERN_C void _AAPI frmReturn(__u16 frmId);

EXTERN_C TForm* _AAPI frmFind(__u16 frmId);
EXTERN_C TForm* _AAPI frmGetFirstForm(void);

EXTERN_C void _AAPI frmDraw(TForm*);
EXTERN_C void _AAPI frmErase(TForm*);

EXTERN_C void _AAPI frmUpdate(__u16 frmId, __u16 updateCode);

EXTERN_C void _AAPI frmSetActive(TForm* p);
EXTERN_C _err_t _AAPI frmActiveState(TFormActiveState *state, bool bSave);

EXTERN_C void _AAPI frmSetTitle(TForm* frm, const char* s);

EXTERN_C void _AAPI frmSetMenu(TForm* p, __u16 resIdMenu);

EXTERN_C bool _AAPI frmHandleEvent(TForm*, TEvent*);
EXTERN_C bool _AAPI frmDispatchEvent(TEvent*);

EXTERN_C void _AAPI frmCloseAll(void);
EXTERN_C void _AAPI frmSaveAll(void);

EXTERN_C bool _AAPI frmValid(const TForm*);

EXTERN_C bool _AAPI frmPointInTitle(const TForm* frm, __s16 x, __s16 y);

EXTERN_C __u16 _AAPI frmAlert(__u16 resId);
EXTERN_C __u16 _AAPI frmDoDialog(TForm* frm);
EXTERN_C __u16 _AAPI frmCustomAlert(__u16 resId, const char* s1, const char* s2, const char* s3);
EXTERN_C void _AAPI frmHelp(__u16 resId);

/////////////////////////////////////////////////////
//Control
EXTERN_C _err_t _JAPI frmAttachCtl(TForm* frm, __u16 objType, TObjPtr objPtr);
EXTERN_C _err_t _JAPI frmDestroyCtl(TForm* frm, __u16 objIndex);

EXTERN_C TObjLabel* _AAPI _frmCreateLabel(TForm **ppFrm, __u16 id, const char* text, __s16 x, __s16 y, __s16 fontId);
inline TObjLabel* frmCreateLabel(TForm *frm, __u16 id, const char* text, __s16 x, __s16 y, __s16 fontId)
	{return _frmCreateLabel(&frm, id, text, x, y, fontId);}

EXTERN_C TObjCtl* _AAPI _frmCreateCtl(TForm **ppFrm, __u16 id, __s16 style,
	const char *text, __s16 x, __s16 y,	__s16 wd, __s16 hgh,
	__s16 fontId, __u8 group, bool leftAnchor);
inline TObjCtl* frmCreateCtl(TForm *frm, __u16 id, __s16 style,
	const char *text, __s16 x, __s16 y,	__s16 wd, __s16 hgh,
	__s16 fontId, __u8 group, bool leftAnchor)
	{return _frmCreateCtl(&frm, id, style, text, x, y, wd, hgh, fontId, group, leftAnchor);}

//Form Objects
EXTERN_C __u16 _AAPI frmGetObjId(const TForm* frm, __u16 objIndex);
EXTERN_C TObjNode* _JAPI frmGetObjNode(const TForm* frm, __u16 objIndex);
EXTERN_C __u16 _AAPI frmGetObjIndex(const TForm* frm, __u16 ctlId);

EXTERN_C void _AAPI frmGetObjPosition(const TForm *frm, __u16 objIndex, __s16 *x, __s16 *y);
EXTERN_C void _AAPI frmSetObjPosition(TForm *frm, __u16 objIndex, __s16 x, __s16 y);
EXTERN_C void _AAPI frmGetObjBounds(const TForm *frm, __u16 objIndex, TRect* bounds);
EXTERN_C void _AAPI frmSetObjBounds(TForm *frm, __u16 objIndex, const TRect* bounds);

EXTERN_C const char* _AAPI frmGetLabel(const TForm* frm, __u16 objIndex);
EXTERN_C void _AAPI frmSetLabel(const TForm* frm, __u16 objIndex, const char* text);

EXTERN_C void _AAPI frmHideObj(TForm* frm, __u16 objIndex);
EXTERN_C void _AAPI frmShowObj(TForm* frm, __u16 objIndex);

EXTERN_C TObjTitle* _JAPI frmCreateTitle(TForm *p, const char *title);


//FOBJ_CTL
EXTERN_C __s16 _AAPI frmGetCtlVal(const TForm* frm, __u16 objIndex);
EXTERN_C void _AAPI frmSetCtlVal(const TForm* frm, __u16 objIndex, __s16 val);
EXTERN_C __u16 _AAPI frmGetCtlGrpSel(const TForm* frm, __u8 grp);
EXTERN_C void _AAPI frmSetCtlGrpSel(const TForm* frm, __u8 grp, __u16 ctlId);

/////////////////////////////////////////////////////
//Internal API
EXTERN_C TRect* _JAPI frmGetObjBoundsPtr(const TForm *frm, __u16 objIndex, bool* bPtOnly=0);
	//Return NULL if the control has no (concept of) bounds.
	//bPtOnly specifies whether the returned value is a pointer to TPoint or TRect
EXTERN_C void _JAPI frmDrawTitle(TForm *pForm, TObjTitle *p);

EXTERN_C void _JAPI frmAppCleanup(TAppLocal* app);

#endif //_is_jedi_form_H
