/*	fnt.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors: Tom M. Yeh
	Create Date:	2000/7/26 02:50PM
	$Header: /cvsroot/jedi/include/jedi/fnt.h,v 1.12 2000/10/12 01:50:46 henrichen Exp $
	Purpose:	
	Description:	Implementation Header of Jedi's fntXXX()

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_fnt_H
#define _is_jedi_fnt_H

struct TFontBase {
	__s16	fontType;
	__s16	firstChar;
	__s16	lastChar;
	__s16	maxWidth;
	__s16	nKernMax;
	__s16	nDescent;
	__s16	width;
	__s16	height;
	__s16	ofInfo;
	__s16	ascent;
	__s16	descent;
	__s16	leading;
	__s16	rowWords;
	__s16	ofBits;
};

//TFont.fontType
#define	FONT_RASTER		0
#define	FONT_VECTOR		1
#define	FONT_TRUETYPE	2	

struct TFontCharInfo {
	__s8	offset;
	__s8	width;
};


//FontID
#define	FONT_STD		0
#define	FONT_BOLD		1
#define	FONT_LARGE		2
#define	FONT_SYMBOL		3
#define	FONT_SYMBOL11	4
#define	FONT_CHECKBOX	FONT_SYMBOL11
#define	FONT_SYMBOL7	5
#define	FONT_LED		6
#define	FONT_LARGEBOLD	7
	//** add new system font here, and change the FONT_LAST
#define	FONT_LAST		FONT_LARGEBOLD
#define	FONT_CUSTOM		0x80

#define FONT_TITLE		FONT_BOLD

#define	FONT_TABWIDTH	20

#include <os/fnt.h>

///////////////////////////////////////////////////////////
typedef TFont *_hfont_t;

extern TFont *g_pSysFonts[FONT_LAST+1];

///////////////////////////////////////////////////////////
//Internal API
EXTERN_C void _JAPI fntSysInit(void);
EXTERN_C void _JAPI fntOsSysInit(void);
	//called by fntInit to do platform-depedent init
EXTERN_C void _JAPI fntSysCleanup(void);
EXTERN_C void _JAPI fntOsSysCleanup(void);
EXTERN_C void _JAPI fntGetExtent(__s16 fontId, const char *str, TRect *pRect);
EXTERN_C TFont* _JAPI fntGetTFont(__s16 fontId);
	//Given fontId, return the (realized) TFont.
EXTERN_C int _JAPI fntGetCharWidth(__s16 fontId, const char ch);

//////////////////////////////////////////////////////////////////
//Anakin API
EXTERN_C __s16 _AAPI fntCharWidth(char ch);
EXTERN_C __s16 _AAPI fntAverageCharWidth(void);
EXTERN_C __s16 _AAPI fntBaseLine(void);
EXTERN_C __s16 _AAPI fntCharHeight(void);
EXTERN_C void _AAPI fntCharsInWidth(const char* string, __s16 *stringWidthP, 
	__s16 *stringLengthP, bool *fitWithinWidth);
EXTERN_C __s16 _AAPI fntCharsWidth(const char* string, __s16 len);
EXTERN_C _err_t _AAPI fntDefineFont(__s16 fontId, TFont *pFont);
EXTERN_C __s16 _AAPI fntDescenderHeight(void);
EXTERN_C __s16 _AAPI fntGetFont(void);
EXTERN_C TFont* _AAPI fntGetFontPtr(void);
EXTERN_C void _AAPI fntGetScrollValues(const char* string, __u16 width, 
	__u16 scrollPos, __u16 *linesP, __u16 *topLine);
EXTERN_C __s16 _AAPI fntLineHeight(void);
EXTERN_C __s16 _AAPI fntLineWidth(const char* string, __u16 len);
EXTERN_C __s16 _AAPI fntSetFont(__s16 id);
EXTERN_C __s16 _AAPI fntWidthToOffset(const char* string, __u16 len, 
	__s16 pixelWidth, bool *leadingEdge, __s16 *truncWidth);
EXTERN_C __u16 _AAPI fntWordWrap(const char* string, __u16 maxWidth);
EXTERN_C void _AAPI fntWordWrapReverseNLines(const char* string, 
	__u16 maxWidth, __u16 *linesToScrollP, __u16 *scrollPosP);
EXTERN_C __s16 _AAPI fntSelect(__s16 fontId);

#endif //_is_jedi_fnt_H
