/*	file.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/23 05:25PM
	$Header: /cvsroot/jedi/include/jedi/file.h,v 1.5 2000/10/04 04:07:26 henrichen Exp $
	Purpose:	
	Description:	implementation of jedi's file system

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_file_H
#define _is_jedi_file_H

struct TFindData {
	unsigned long attributes;
	char filename[MAX_DB_NAME_LEN];
	
	inline bool IsReg(void);
	inline bool IsDir(void);
};
//TFindData.attributes
#define	FILE_REG	0x1
#define	FILE_DIR	0x2

inline bool TFindData::IsReg(void)
{
	return (attributes & FILE_REG);
}

inline bool TFindData::IsDir(void)
{
	return (attributes & FILE_DIR);
}

#include <os/file.h>

//////////////////////////////////////////////////////////////////
// file API porting layer
EXTERN_C _hfile_t _JAPI jdbOpenFile(const char *filename, int mode);
EXTERN_C BOOL _JAPI jdbCloseFile(_hfile_t h);
EXTERN_C unsigned int _JAPI jdbReadFile(_hfile_t h, void *data, size_t size);
EXTERN_C unsigned int _JAPI jdbWriteFile(_hfile_t h, const void *data, size_t size);
EXTERN_C unsigned long _JAPI jdbSetFilePointer(_hfile_t h, long offset, int pos);
EXTERN_C BOOL _JAPI jdbSetEndOfFile(_hfile_t h);
EXTERN_C BOOL _JAPI jdbDeleteFile(const char *filename);
EXTERN_C _hfind_t _JAPI jdbFindFirstFile(const char *filename, TFindData *fd);
EXTERN_C BOOL _JAPI jdbFindNextFile(_hfind_t hfind, TFindData *fd);
EXTERN_C BOOL _JAPI jdbFindClose(_hfind_t hfind);
EXTERN_C BOOL _JAPI jdbRenameFile(const char *oldname, const char *newname);

#define	MODE_READONLY	0x01
#define	MODE_WRITE		0x02
#define	MODE_READWRITE	0x03
#define	MODE_LEAVEOPEN	0x04
#define	MODE_EXCLUSIVE	0x08
#define	MODE_SHOWSECRET	0x10

#define	MODE_CREATE		0x8000

#ifndef	HFILE_INVALID
#define	HFILE_INVALID	0
#endif

//////////////////////////////////////////////////////////////////
class CJediFile {
public:
	CJediFile() : m_hfile(HFILE_INVALID) {}
	inline ~CJediFile();
	inline bool Open(const char *name, int mode);
	inline bool Create(const char *name);
	inline bool Delete(const char *name);
	inline bool Close(void);

	inline size_t GetFileSize(void);
	inline bool SetFileSize(size_t sz);
	
	inline size_t Read(void *, size_t sz, unsigned long offset);
	inline size_t Write(void *, size_t sz, unsigned long offset);
	
	//data
	_hfile_t m_hfile;
};

inline bool CJediFile::Open(const char *name, int mode)
{
	m_hfile= jdbOpenFile(name, mode);
	return (m_hfile != HFILE_INVALID);
}

inline bool CJediFile::Create(const char *name)
{
	return Open(name, MODE_READWRITE|MODE_CREATE);
};

inline bool CJediFile::Close(void)
{
	if (m_hfile != HFILE_INVALID && !jdbCloseFile(m_hfile))
		return false;
	m_hfile= HFILE_INVALID;
	return true;
}

inline CJediFile::~CJediFile(void)
{
 	Close();
}

inline bool CJediFile::Delete(const char *name)
{
	return ::jdbDeleteFile(name) != 0;
}

inline size_t CJediFile::GetFileSize(void)
{
	ASSERT(m_hfile != HFILE_INVALID);
	
	return jdbSetFilePointer(m_hfile, 0, FILE_END);
}

inline bool CJediFile::SetFileSize(size_t sz)
{
	ASSERT(m_hfile != HFILE_INVALID);
	
	return jdbSetFilePointer(m_hfile, sz, FILE_BEGIN) &&
				jdbSetEndOfFile(m_hfile);
}

inline size_t CJediFile::Read(void *data, size_t sz, unsigned long offset)
{
	ASSERT(m_hfile != HFILE_INVALID);
	
	jdbSetFilePointer(m_hfile, offset, FILE_BEGIN);
	return jdbReadFile(m_hfile, data, sz);
}

inline size_t CJediFile::Write(void *data, size_t sz, unsigned long offset)
{
	ASSERT(m_hfile != HFILE_INVALID);
	
	jdbSetFilePointer(m_hfile, offset, FILE_BEGIN);
	return jdbWriteFile(m_hfile, data, sz);
}

#endif //_is_jedi_file_H
