/*	fb.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/11/0 08:30PM
$Header: /cvsroot/jedi/include/jedi/fb.h,v 1.10 2000/09/22 11:57:52 tomyeh Exp $
Purpose:	Frame buffer of jedi
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_fb_H
#define _is_jedi_fb_H

//////////////////////////////////////////////////////////////////////
#ifdef __LITTLE_ENDIAN__
#define FB_RGB(r, g, b)		(((r) << 8) + ((g) << 16) + ((b) << 24))
#else
#define FB_RGB(r, g, b)		((b) + ((g) << 8) + ((r) << 16))
#endif
#define FB_SET_RGB(pal, r, g, b) ((__u32&)(pal)) = FB_RGB(r, g, b)

//////////////////////////////////////////////////////////////////////
#include <os/fb.h>

//////////////////////////////////////////////////////////////////////
EXTERN_C HDIB _JAPI fbConfig(const TPalette palettes[]);
	//If SCREEN_BPP<=8, colors must be supplied for 2^bpp palettes
	//return the handle of the bitmap if succeed; 0 if failed
	//Note:
	//1. Don't use SCREEN_BASEADDR until returning from fbConfig
	//2. bmp returns a handle to the internal structure of the frame buffer
	//	in the specified system. If you don't care, simply ignore it
EXTERN_C void _JAPI fbCleanup(void);
	//Cleanup
EXTERN_C void _JAPI fbUpdate(const TRect* rect DEFAULTVAL(0));
	//Inform the window to repaint the specified range
	//If rect==0, the whole window is repaint
	//It must be called when a portion of window is modified (through
	//the address returned by fbConfig

EXTERN_C bool _JAPI fbSetPalette(const TPalette palettes[],
	int index DEFAULTVAL(0), int nColors DEFAULTVAL(-1));
	//Set the color table of the specified HDIB
	//
	//palettes: the whole palette table
	//index: the first palette entry to change, i.e., colors[index]
	//nColors: # of colors in colors[]. If -1, it means up to the
	//	last palette entry.

#endif //_is_jedi_fb_H
