/*	evtconst.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/27/0 05:02PM
	$Header: /cvsroot/jedi/include/jedi/evtconst.h,v 1.1 2000/09/28 03:17:16 tomyeh Exp $
	Purpose:	Event constants
	Description:
		It is separated from event.h because h/w drivers also need it
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_evtconst_H
#define _is_jedi_evtconst_H

/////////////////////////////////////////////////////////
//Constants

//Key Modifiers
#define KM_SHIFT		0x0001
#define KM_CAPSLOCK		0x0002
#define KM_NUMLOCK		0x0004
#define KM_COMMAND		0x0008
#define KM_OPTION		0x0010
#define KM_CONTROL		0x0020
#define KM_AUTOREPEAT	0x0040 // set if generated due to auto-repeat
#define KM_DOUBLETAP	0x0080 // set if this is a double-tap event
#define KM_POWEREDON	0x0100 // set if this is a double-tap event
#define KM_APPHOOK		0x0200 // set if this is an app hook key
#define KM_LIBHOOK		0x0400 // True if this is a library hook key

#define KM_VIRTUAL		(KM_APPHOOK | KM_LIBHOOK | KM_COMMAND)

//Button Bits
#define	BB_POWER		0x0001
#define	BB_PAGEUP		0x0002
#define	BB_PAGEDOWN		0x0004
#define	BB_APP1			0x0008
#define	BB_APP2			0x0010
#define	BB_APP3			0x0020
#define	BB_APP4			0x0040
#define	BB_CRADLE		0x0080
#define	BB_ANTENNA		0x0100
#define	BB_CONTRAST		0x0200

#define	BB_ALL			0xFFFFFFFF
#define BB_APP1_SHIFT	3

#define BB_SLOWESTDELAYRATE		0xff
#define BB_SLOWESTPERIODRATE	0xff

//char values
#define CC_NULL			0x0000
#define CC_LINEFEED		0x000A
#define	CC_PAGEUP		0x000B	//different from VK_PRIOR
#define CC_PAGEDOWN		0x000C	//different from VK_NEXT
#define	CC_LEFT			0x001C	//different from VK_LEFT
#define	CC_RIGHT		0x001D	//different from VK_RIGHT
#define CC_UP			0x001E	//different from VK_UP
#define	CC_DOWN			0x001F	//different from VK_DOWN

#define CC_INVALID		0x00ff	//not a valid key

//The following are key codes used for virtual events.
//These keyboard events MUST have KM_COMMAND set in the modifiers.
#define CC_VIRTUAL_FIRST		0x0100
#define	CC_LOWBATTERY			0x0101
#define	CC_ENTERDEBUGGER		0x0102
#define	CC_NEXTFIELD			0x0103
#define	CC_STARTCONSOLE			0x0104
#define	CC_MENU					0x0105
#define	CC_COMMAND				0x0106
#define	CC_CONFIRM				0x0107
#define	CC_LAUNCH				0x0108
#define	CC_KEYBOARD				0x0109
#define	CC_FIND					0x010A
#define	CC_CALC					0x010B
#define	CC_PREVFIELD			0x010C
#define	CC_ALARM				0x010D
#define	CC_RONAMATIC			0x010E
#define	CC_GRAFFITIREFERENCE	0x010F
#define	CC_KEYBOARDALPHA		0x0110
#define	CC_KEYBOARDNUMERIC		0x0111
#define	CC_LOCK					0x0112
#define	CC_BACKLIGHT			0x0113
#define	CC_AUTOOFF				0x0114
#define	CC_EXGTEST				0x0115
#define	CC_SENDDATA				0x0116
#define	CC_IRRECEIVE			0x0117
#define	CC_TSM1					0x0118
#define	CC_TSM2					0x0119
#define	CC_TSM3					0x011A
#define	CC_TSM4					0x011B
#define	CC_RADIOCOVERAGEOK		0x011C
#define	CC_RADIOCOVERAGEFAIL	0x011D
#define	CC_POWEROFF				0x011E
#define	CC_RESUMESLEEP			0x011F
#define	CC_LATEWAKEUP			0x0120
#define	CC_TSMMODE				0x0121
#define	CC_BRIGHTNESS			0x0122
#define	CC_CONTRAST				0x0123
#define CC_EXGINTDATA			0x01FF

//h/w buttons
#define	CC_BTN1					0x0204
#define	CC_BTN2					0x0205
#define	CC_BTN3					0x0206
#define	CC_BTN4					0x0207
#define	CC_BTNPOWER				0x0208
#define	CC_BTNCRADLE			0x0209
#define	CC_BTNCRADLE2			0x020A
#define	CC_BTNCONTRAST			0x020B
#define	CC_BTNANTENNA			0x020C
#define	CC_BTNBRIGHTNESS		0x020D
#define	CC_BTNMIN				0x0200
#define	CC_BTNMAX				0x02FF

//Events
typedef enum {
	EVT_NIL = 0,
	EVT_PENDOWN,
	EVT_PENUP,
	EVT_PENMOVE,
	EVT_KEYDOWN,
	EVT_WINENTER,
	EVT_WINEXIT,
	EVT_CTLENTER,
	EVT_CTLEXIT,
	EVT_CTLSELECT,
	EVT_CTLREPEAT,
	EVT_LSTENTER,
	EVT_LSTSELECT,
	EVT_LSTEXIT,
	EVT_POPSELECT,
	EVT_FLDENTER,
	EVT_FLDHEIGHTCHANGED,
	EVT_FLDCHANGED,
	EVT_TBLENTER,
	EVT_TBLSELECT,
	EVT_DAYSELECT,
	EVT_MENU,

	EVT_APPSTOP = 22,
	EVT_FRMLOAD,
	EVT_FRMOPEN,
	EVT_FRMGOTO,
	EVT_FRMUPDATE,
	EVT_FRMSAVE,
	EVT_FRMCLOSE,
	EVT_FRMTITLEENTER,
	EVT_FRMTITLESELECT,
	EVT_TBLEXIT,
	EVT_SCLENTER,
	EVT_SCLEXIT,
	EVT_SCLREPEAT,

	EVT_TSMCONFIRM = 35,
	EVT_TSMFEPBUTTON,
	EVT_TSMFEPMODE,
	
	EVT_MENUCMDBAROPEN = 0X0800,
	EVT_MENUOPEN,
	EVT_MENUCLOSE,
	EVT_FRMGADGETENTER,
	EVT_FRMGADGETMISC,

	EVT_FIRSTINETLIB = 0X1000,

	EVT_FIRSTWEBLIB = 0X1100,
	
	EVT_FIRSTUSER = 0X6000,

	EVT_FRMFIRST = EVT_FRMLOAD,
	EVT_FRMLAST = EVT_FRMTITLESELECT
} TEventId;

//Constants used only in evtOnHwNotify
#define EX_EVT_KEYUP	EVT_FIRSTUSER
#define EX_EVT_PENDOWN	(EVT_FIRSTUSER+1)

#endif //_is_jedi_evtconst_H
