/*	event.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	7/17/0 04:28PM
	$Header: /cvsroot/jedi/include/jedi/event.h,v 1.21 2000/10/03 07:29:43 tomyeh Exp $
	Purpose:	Event manager
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_event_H
#define _is_jedi_event_H

/////////////////////////////////////////////////////////
#include <jedi/evtconst.h>

/////////////////////////////////////////////////////////
//Declared at other headers
struct TWin;

/////////////////////////////////////////////////////////
//Data Structure
struct TEvtGeneric {
	__u16		datum[8];
};

struct TEvtKeyDown {
	wchar_t		chr;			// ascii code
	__u16		keyCode;		// virtual key code
	__u16		modifiers;
};

struct TEvtPenUp {
   TPoint		start;
   TPoint		end;
};

struct TEvtForm {
	__u16		frmId;
};

struct TEvtFormUpdate {
	__u16		frmId;
	__u16		updateCode;
};

struct TEvtWinEnterExit {
	TWin		*pWinEnter;
	TWin		*pWinExit;
}; //unlike Palm, EVT_CTLEXIT also sent with TEvtWinEnterExit

struct TEvtCtlEnterExit {
	__u16		ctlId;
	struct TObjCtl *pCtl;
};

struct TEvtCtlSelect {
	__u16		ctlId;
	struct TObjCtl *pCtl;
	bool		on;
	__u8		reserved;
	__u16		value;
};

struct TEvtCtlRepeat {
	__u16		ctlId;
	struct TObjCtl *pCtl;
	__u32		time;
	__u16		value;
};


struct TEvtTsmConfirm {
	char *		yomiText;
	__u16		formID;
};

struct TEvtTsmFepButton {
	__u16		buttonID;
};

struct TEvtTsmFepMode {
	__u16		mode;
};

struct TEvent {
	__s16	eType;
	bool	penDown;
	__u8	tapCount;
	__s16	screenX;
	__s16	screenY;
	union {
		struct TEvtGeneric		generic;
		struct TEvtKeyDown		keyDown;
		struct TEvtPenUp		penUp;
		struct TEvtWinEnterExit	winEnterExit;
		struct TEvtCtlEnterExit	ctlEnterExit;
		struct TEvtCtlSelect	ctlSelect;
		struct TEvtCtlRepeat	ctlRepeat;
		struct TEvtTsmConfirm	tsmConfirm;
		struct TEvtTsmFepButton	tsmFepButton;
		struct TEvtTsmFepMode	tsmFepMode;
		struct TEvtForm			frm;
		struct TEvtFormUpdate	frmUpdate;
		struct TEvtMenu {
			__u16				itemID;
		} menu;
		struct TEvtMenuCmdBarOpen {
			bool				preventFieldButtons;
			__u8				reserved;
		} menuCmdBarOpen;
		struct TEvtMenuOpen {
			__u16				menuRscID;
			__s16				cause;
		} menuOpen;
	} data;
};

struct TPenBtnInfo {
	TRect	boundsR;						// bounding rectangle of button
	wchar_t	asciiCode;					// ascii code for key event
	__u16	keyCode;						// virtual key code for key event
	__u16	modifiers;					// modifiers for key event
};
#define PEN_BTN_NO		6
extern const struct TPenBtnInfo g_penBtnList[PEN_BTN_NO];

extern TPoint g_penPos; //the recent pen position
extern __u32 g_hwBtnState, g_hwBtnMask; //h/w button status
	//possible flags: BB_xx
	//Default: BB_ALL -> all enabled
extern __u8 g_winEnterExitState;
#define NOTIFY_WINACTIVECHANGED		1
#define NOTIFY_WINEXITSENT			2
	//Set NOTIFY_WINACTIVECHANGED to notify event manager g_pWinActive is changed

/////////////////////////////////////////////////////////
inline __u32 evtGetHwBtnState() {return g_hwBtnState;}
inline void evtSetHwBtnState(__u32 f, BOOL bSet)
{
	g_hwBtnState = bSet ? g_hwBtnState|f : g_hwBtnState & ~f;
}

inline __u32 evtTestHwBtnMask(__u32 f)
{
	return g_hwBtnMask & f;
}
inline __u32 evtSetHwBtnMask(__u32 mask)
{
	__u32 old = g_hwBtnMask;
	g_hwBtnMask = mask;
	return old;
}

/////////////////////////////////////////////////////////
EXTERN_C void _AAPI evtPushEvent(const TEvent* evt);
EXTERN_C void _AAPI evtPushEventUnique(const TEvent* evt, unsigned id, bool bInPlace);
EXTERN_C bool _AAPI evtEventAvail(void);
EXTERN_C bool _AAPI evtGetEvent(TEvent* evt, int toTicks DEFAULTVAL(TO_INFINITE));
EXTERN_C void _AAPI evtGetPen(__s16* x, __s16* y, bool* bPenDown);

EXTERN_C bool _AAPI evtSysEventAvail(bool bIgnorePenUps);

//key means keyDownEvent
EXTERN_C bool _AAPI evtKeyQueEmpty(void);
EXTERN_C _err_t _AAPI evtFlushKeyQue(void);

EXTERN_C _err_t _AAPI evtPushKey(wchar_t cc, __u16 keyCode, __u16 keyModifiers);

//shortcut to push events
EXTERN_C void _JAPI evtPushEventEx(int eType); //without extra infomation
EXTERN_C void _JAPI evtPushKeyEx(wchar_t cc);
EXTERN_C void _JAPI evtInitEvent(TEvent* evt);
	//initial penDown, tapCount, screenX, screenY

EXTERN_C void _JAPI evtPushPen(int eType, int x, int y);
	//eType is one of EVT_PENMOVE, EVT_PENUP and EX_EVT_PENDOWN+n (where n>=0)
	//if eType is (EX_EVT_PENDOWN+n), it means EVT_PENDOWN with tapcount = n+1
	//Note: we don't send EVT_PENDOWN; rather, we use EX_EVT_PENDOWN+n

EXTERN_C void _CDECL evtOnHwNotify(int eType, unsigned param1=0, unsigned param2=0);
	//eType is one of EVT_APPSTOP, EVT_KEYDOWN, EVT_PENDOWN,
	//EVT_PENMOVE, EVT_PENUP, EX_EVT_KEYUP, and EX_EVT_PENDOWN+n (where n>=0)
	//if eType is (EX_EVT_PENDOWN+n), it means EVT_PENDOWN with tapcount = n+1
	//Note: we don't send EVT_PENDOWN; rather, we use EX_EVT_PENDOWN+n
	//if eType is EVT_KEYDOWN, param1 specifies the key
	//if eType is EVT_PENxxx, param1 and param2 specify the x and y coordinate
	//
	//Unlike other functions, when evtOnHwNotify is called, it assumes
	//AnakinLock is NOT called yet. So, it will call AnakinLock before
	//pushing events.

/////////////////////////////////////////////////////////
//Internal API
EXTERN_C void _JAPI evtSysCleanup(void);
	//cleanup un-read events

#endif //_is_jedi_event_H
