/*	errmgr.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/10/0 03:09PM
	$Header: /cvsroot/jedi/include/jedi/errmgr.h,v 1.7 2000/09/26 10:09:26 tomyeh Exp $
	Purpose:	Error codes and Error handler
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_errmgr_H
#define _is_jedi_errmgr_H

#include <jedi/thread.h>

////////////////////////////////////////////////////////////
//Error Classes
#define	ERR_NONE			0x0000	// No error

#define	ERR_MEM				0X0100	// MEMORY MANAGER
#define	ERR_DM				0X0200	// DATA MANAGER
#define	ERR_SER				0X0300	// SERIAL MANAGER
#define ERR_SLK				0X0400	// SERIAL LINK MANAGER
#define ERR_SYS				0X0500	// SYSTEM MANAGER
#define ERR_FPL				0X0600	// FLOATING POINT LIBRARY
#define ERR_FLP				0X0680	// NEW FLOATING POINT LIBRARY
#define ERR_EVT				0X0700 	// SYSTEM EVENT MANAGER
#define ERR_SND				0X0800 	// SOUND MANAGER
#define ERR_ALM				0X0900 	// ALARM MANAGER
#define ERR_TIM				0X0A00 	// TIME MANAGER
#define ERR_PEN				0X0B00 	// PEN MANAGER
#define ERR_FTR				0X0C00 	// FEATURE MANAGER
#define ERR_CMP				0X0D00 	// CONNECTION MANAGER (HOTSYNC)
#define ERR_DLK				0X0E00	// DESKTOP LINK MANAGER
#define ERR_PAD				0X0F00	// PAD MANAGER
#define ERR_GRF				0X1000	// GRAFFITI MANAGER
#define ERR_MDM				0X1100	// MODEM MANAGER
#define ERR_NET				0X1200	// NET LIBRARY
#define ERR_HTAL			0X1300	// HTAL LIBRARY
#define ERR_INET			0X1400	// INET LIBRARY
#define ERR_EXG				0X1500	// EXG MANAGER
#define ERR_FILE			0X1600	// FILE STREAM MANAGER
#define ERR_RFUT			0X1700	// RFUT LIBRARY
#define ERR_TXT				0X1800	// TEXT MANAGER
#define ERR_TSM				0X1900	// TEXT SERVICES LIBRARY
#define ERR_WEB				0X1A00	// WEB LIBRARY
#define ERR_SEC				0X1B00	// SECURITY LIBRARY
#define ERR_EMU				0X1C00	// EMULATOR CONTROL MANAGER
#define ERR_FLSH			0X1D00	// FLASH MANAGER
#define ERR_PWR				0X1E00	// POWER MANAGER
#define ERR_CNC				0X1F00	// CONNECTION MANAGER (SERIAL COMMUNICATION)
#define ERR_ACTV			0X2000	// ACTIVATION APPLICATION
#define ERR_RADIO			0X2100	// RADIO MANAGER (LIBRARY)
#define ERR_DISP			0X2200	// DISPLAY DRIVER ERRORS.
#define ERR_BLT				0X2300	// BLITTER DRIVER ERRORS.
#define ERR_WIN				0X2400	// WINDOW MANAGER.
#define ERR_OM				0X2500	// OVERLAY MANAGER
#define ERR_MENU			0X2600	// MENU MANAGER

//system errors
#define	ERRS_TIMEOUT				(ERR_SYS | 1)
#define	ERRS_PARAMERR				(ERR_SYS | 2)
#define	ERRS_NOFREERESOURCE			(ERR_SYS | 3)
#define	ERRS_NOFREERAM				(ERR_SYS | 4)
#define	ERRS_NOTALLOWED				(ERR_SYS | 5)
#define	ERRS_SEMINUSE				(ERR_SYS | 6)
#define	ERRS_INVALIDID				(ERR_SYS | 7)
#define	ERRS_OUTOFOWNERIDS			(ERR_SYS | 8)
#define	ERRS_NOFREELIBSLOTS			(ERR_SYS | 9)
#define	ERRS_LIBNOTFOUND			(ERR_SYS | 10)
#define	ERRS_DELAYWAKENED			(ERR_SYS | 11)
#define	ERRS_ROMINCOMPATIBLE		(ERR_SYS | 12)
#define	ERRS_BUFTOOSMALL			(ERR_SYS | 13)
#define	ERRS_PREFNOTFOUND			(ERR_SYS | 14)

#define	ERRS_ENTRYNOTFOUND			(ERR_SYS | 16)
#define	ERRS_DUPLICATEENTRY			(ERR_SYS | 17)
#define	ERRS_BROADCASTBUSY			(ERR_SYS | 19)
#define	ERRS_BROADCASTCANCELLED		(ERR_SYS | 20)
#define	ERRS_MBID					(ERR_SYS | 21)
#define	ERRS_MBNONE					(ERR_SYS | 22)	
#define	ERRS_MBBUSY					(ERR_SYS | 23)
#define	ERRS_MBFULL					(ERR_SYS | 24)
#define	ERRS_MBDEPTH				(ERR_SYS | 25)
#define	ERRS_MBENV					(ERR_SYS | 26)
#define	ERRS_QUEUEFULL				(ERR_SYS | 27)
#define	ERRS_QUEUEEMPTY				(ERR_SYS | 28)
#define	ERRS_NOSTACKSPACE			(ERR_SYS | 29)
#define	ERRS_NOTINITIALIZED			(ERR_SYS | 30)
#define	ERRS_NOTASLEEP				(ERR_SYS | 31)
#define	ERRS_NOTASLEEPN				(ERR_SYS | 32)

//Jedi Extension
#define ERRS_SYSTEMSTOPPING			(ERR_SYS | 40)
#define ERRS_OUTOFMEMORY		(ERR_SYS | 41)

//power manager errors
#define	ERRP_NONE					(ERR_PWR | 0)
#define	ERRP_BACKLIGHT				(ERR_PWR | 1)
#define	ERRP_RADIO					(ERR_PWR | 2)
#define	ERRP_BEAM					(ERR_PWR | 3)

////////////////////////////////////////////////////////////
#include <setjmp.h>

#define IS_JBLEN	64
	//Though we don't use setjmp/longjmp, but we have to use a fix
	//size for TExInfo since it is visible to Palm applications.

#if _JBLEN > IS_JBLEN
#error Not enough space to hold jmpbuf
#endif

typedef jmp_buf jmpbuf_t;

typedef struct TExInfo {
	struct TExInfo*	next;
	jmpbuf_t		jbuf;//we have to be compatible with Palm
#if _JBLEN < IS_JBLEN
	int				jbuf_ex[IS_JBLEN-_JBLEN]; //pack to have the same size
#endif
	int				err;
} TExInfo;

#ifdef _MSC_VER
#pragma warning(disable: 4611)
EXTERN_C int _CDECL _setjmp3(jmp_buf jbuf);
#define exSetJump	_setjmp3
#else
#define exSetJump	setjmp
#endif

#define exLongJump	longjmp
	//Note: setjmp snapshot the stack of its caller, so we have to use
	//macro to ensure there is additional stack rewind.

EXTERN_C void _AAPI exThrow(int err);

////////////////////////////////////////////////////////////
#define exTRY									\
	{											\
		TThdLocal* _pTls_ = GetThdLocal();		\
		TExInfo	_exInfo_;						\
		_exInfo_.next	= _pTls_->exInfo;		\
		_exInfo_.err	= 0;					\
		_pTls_->exInfo	= &_exInfo_;			\
		if(!exSetJump(_exInfo_.jbuf)){

#define exCATCH(theErr)							\
			_pTls_->exInfo	= _exInfo_.next;	\
		}else{									\
			_pTls_->exInfo	= _exInfo_.next;	\
			int theErr		= (volatile int&)_exInfo_.err;

#define exEND	\
		}		\
	}

#define exTHROW(err)	exThrow(err)

#endif //_is_jedi_errmgr_H
