/*	dm.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/6 04:29PM
	$Header: /cvsroot/jedi/include/jedi/dm.h,v 1.3 2000/10/03 06:16:13 henrichen Exp $
	Purpose:	
	Description:	Data Management

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_dm_H
#define _is_jedi_dm_H

struct TDbID : public TDbHeader {
	CPalmDB *pDB;	//associated db object
	unsigned count;	//total open count of all dbRef
	TDbID *next;
	TDbID *prev;
	
	TDbID(): pDB(NULL), count(0), next(NULL), prev(NULL){}
};

struct TDBRef {
	unsigned count;	//open count for the app
	TDbID	*pDbID;	//which db to be opened
	unsigned mode;
	
	TDBRef() : count(0), pDbID(NULL), mode(0) {}
};

class CDbIDList {
public:
	CDbIDList() : m_root(NULL) {}
	
	TDbID *m_root;
	
	void Attach(TDbID*);
	void Detach(TDbID*);
	TDbID *Search(const char *name);
	TDbID *Search(__u16 *index);
	void Cleanup(void);
};

extern CDbIDList g_pPrc, g_pPdb;

//////////////////////////////////////////////////////////////////
inline const char* _JAPI dmGetName(unsigned long dbID)
{
	return (const char*)(((TDbID*) dbID)->name);
}

inline bool _JAPI dmResDB(unsigned long dbID)
{
	return (((TDbID*) dbID)->attributes & DMHDRATTR_RESDB) != 0;
}

//////////////////////////////////////////////////////////////////
EXTERN_C void _JAPI dmSysInit(void);
EXTERN_C void _JAPI dmSysCleanup(void);
EXTERN_C void _JAPI dmAppCleanup(TAppLocal* app);
EXTERN_C unsigned long _AAPI dmFindDatabase(__u16 cardNo, const char *name);
EXTERN_C unsigned long _AAPI dmGetDatabase(__u16 cardNo, __u16 index);
EXTERN_C TDBRef* _AAPI dmOpenDatabase (__u16 cardNo, __u32 dbID, __u16 mode);
EXTERN_C _err_t _AAPI dmCloseDatabase(TDBRef *pDBRef);
EXTERN_C __u16 _AAPI dmFindResource(TDBRef* pDBRef, __s16 resType, __s16 resID, _hmem_t h);

//////////////////////////////////////////////////////////////////
#define	DMERR_MEMERROR				(ERR_DM | 1)
#define	DMERR_INDEXOUTOFRANGE		(ERR_DM | 2)
#define	DMERR_INVALIDPARAM			(ERR_DM | 3)
#define	DMERR_READONLY				(ERR_DM | 4)
#define	DMERR_DATABASEOPEN			(ERR_DM | 5)
#define	DMERR_CANTOPEN				(ERR_DM | 6)
#define	DMERR_CANTFIND				(ERR_DM | 7)
#define	DMERR_RECORDINWRONGCARD		(ERR_DM | 8)
#define	DMERR_CORRUPTDATABASE		(ERR_DM | 9)
#define	DMERR_RECORDDELETED			(ERR_DM | 10)
#define	DMERR_RECORDARCHIVED		(ERR_DM | 11)
#define	DMERR_NOTRECORDDB			(ERR_DM | 12)
#define	DMERR_NOTRESOURCEDB			(ERR_DM | 13)
#define	DMERR_ROMBASED				(ERR_DM | 14)
#define	DMERR_RECORDBUSY			(ERR_DM | 15)
#define	DMERR_RESOURCENOTFOUND		(ERR_DM | 16)
#define	DMERR_NOOPENDATABASE		(ERR_DM | 17)
#define	DMERR_INVALIDCATEGORY		(ERR_DM | 18)
#define	DMERR_NOTVALIDRECORD		(ERR_DM | 19)
#define	DMERR_WRITEOUTOFBOUNDS		(ERR_DM | 20)
#define	DMERR_SEEKFAILED			(ERR_DM | 21)
#define	DMERR_ALREADYOPENFORWRITES	(ERR_DM | 22)
#define	DMERR_OPENEDBYANOTHERTASK	(ERR_DM | 23)
#define	DMERR_UNIQUEIDNOTFOUND		(ERR_DM | 24)
#define DMERR_ALREADYEXISTS			(ERR_DM | 25)
#define	DMERR_INVALIDDATABASENAME	(ERR_DM | 26)
#define	DMERR_DATABASEPROTECTED		(ERR_DM | 27)
#define	DMERR_DATABASENOTPROTECTED	(ERR_DM | 28)


#endif //_is_jedi_dm_H
