/*	defs.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/16/0 03:07PM
	$Header: /cvsroot/jedi/include/jedi/defs.h,v 1.23 2000/10/12 03:07:30 tomyeh Exp $
	Purpose:	Basic macros
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_defs_H
#define _is_jedi_defs_H

#if defined(_DEBUG) && defined(NDEBUG)
#error Only one of _DEBUG and NDEBUG can be defined
#endif

#if !defined(_DEBUG) && !defined(NDEBUG)
#define NDEBUG	1 //default: NDEBUG
#endif

#ifdef __cplusplus
#ifndef EXTERN_C
#define	EXTERN_C			extern "C"
#endif

#define EXTERN_C_BEGIN		extern "C" {
#define EXTERN_C_END		}

#define DEFAULTVAL(defval)	=defval

#else //__cplusplus
#ifndef EXTERN_C
#define EXTERN_C
#endif

#define EXTERN_C_BEGIN
#define EXTERN_C_END

#define DEFAULTVAL(defval)
#endif //__cplusplus

#ifndef NULL
#define NULL	0
#endif

///////////////////////////////////////////
// Compiler capability flags
#if defined(__GNUC__)
#define CAN_CPP_VALIST
#endif

///////////////////////////////////////////
// Other compiler dependency

#ifdef __GNUC__

#define _NOVTABLE
#define _STDCALL	__attribute__((stdcall))
#define _CDECL		__attribute__((cdecl))
#define _FASTCALL	_STDCALL
#define _NORETURN	__attribute__((noreturn))
#define _UNUSED		__attribute__((unused))
#define _NAKED

#define _CDECL_O	_CDECL
#define _CDECL_I
#define _STDCALL_O	_STDCALL
#define _STDCALL_I
	//Note: GNU and VC take different way to represent a function
	//pointer specified with the calling convention. To be compiler
	//dependent, you shall declare it as follows.
	//void _CDECL_O (_CDECL_I*FuncPtr)(int);

#define	__s64_c(v)	v##LL
#define	__u64_c(v)	v##ULL

#else //__GNUC__

#ifdef _MSC_VER
#pragma warning(disable: 4201 4514 4244)
	//4244: conversion from 'int' to 'short' -> too common for Palm
#endif

#define _NOVTABLE	__declspec(novtable)
#define _STDCALL	__stdcall
#define _CDECL		__cdecl
#define _FASTCALL	__fastcall
#define _NORETURN	__declspec(noreturn)
#define _UNUSED
#define _NAKED		__declspec(naked)

#define _CDECL_O
#define _CDECL_I	_CDECL
#define _STDCALL_O
#define _STDCALL_I	_STDCALL

#define	__s64_c(v)	v##L
#define	__u64_c(v)	v##UL

#endif //__GNU__

#define _STDCALL_P		_STDCALL_O (_STDCALL_I*)
#define _STDCALL_PF(Fn)	_STDCALL_O (_STDCALL_I* Fn)
#define _CDECL_P		_CDECL_O (_CDECL_I*)
#define _CDECL_PF(Fn)	_CDECL_O (_CDECL_I* Fn)

#define _JAPI			_STDCALL
#define _JAPI_O			_STDCALL_O
#define _JAPI_I			_STDCALL_I

#define _JAPI_P			_STDCALL_P
#define _JAPI_PF(Fn)	_STDCALL_PF(Fn)

#define _AAPI			_CDECL
#define _AAPI_O			_CDECL_O
#define _AAPI_I			_CDECL_I

#define _AAPI_P			_CDECL_P
#define _AAPI_PF(Fn)	_CDECL_PF(Fn)

///////////////////////////////////////////
//Endian macros
#ifdef __LITTLE_ENDIAN__
//Note:
// 1.	We assume big endian as default
// 2. 	Total specified bits must equal total bits allocated, i.e.,
//		you need to specify reserved:n for not-used bits
#define _BF2(a1, a2)	a2, a1
#define _BF3(a1, a2, a3)	a3, a2, a1
#define _BF4(a1, a2, a3, a4)	a4, a3, a2, a1
#define _BF5(a1, a2, a3, a4, a5)	a5, a4, a3, a2, a1
#define _BF6(a1, a2, a3, a4, a5, a6)	a6, a5, a4, a3, a2, a1
#define _BF7(a1, a2, a3, a4, a5, a6, a7)	a7, a6, a5, a4, a3, a2, a1
#define _BF8(a1, a2, a3, a4, a5, a6, a7, a8)	a8, a7, a6, a5, a4, a3, a2, a1
#define _BF9(a1, a2, a3, a4, a5, a6, a7, a8, a9)	a9, a8, a7, a6, a5, a4, a3, a2, a1
#define _BF10(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa)	aa, a9, a8, a7, a6, a5, a4, a3, a2, a1
#define _BF11(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab)	ab, aa, a9, a8, a7, a6, a5, a4, a3, a2, a1
#define _BF12(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab, ac)	ac, ab, aa, a9, a8, a7, a6, a5, a4, a3, a2, a1

#else //__LITTLE_ENDIAN__

#define _BF2(a1, a2)	a1, a2
#define _BF3(a1, a2, a3)	a1, a2, a3
#define _BF4(a1, a2, a3, a4)	a1, a2, a3, a4
#define _BF5(a1, a2, a3, a4, a5)	a1, a2, a3, a4, a5
#define _BF6(a1, a2, a3, a4, a5, a6)	a1, a2, a3, a4, a5, a6
#define _BF7(a1, a2, a3, a4, a5, a6, a7)	a1, a2, a3, a4, a5, a6, a7
#define _BF8(a1, a2, a3, a4, a5, a6, a7, a8)	a1, a2, a3, a4, a5, a6, a7, a8
#define _BF9(a1, a2, a3, a4, a5, a6, a7, a8, a9)	a1, a2, a3, a4, a5, a6, a7, a8, a9
#define _BF10(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa)	a1, a2, a3, a4, a5, a6, a7, a8, a9, aa
#define _BF11(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab)	a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab
#define _BF12(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab, ac)	a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab, ac

#endif //__LITTLE_ENDIAN__

///////////////////////////////////////////////////////
#define DECL_SETZEROS(Type)		inline void SetZeros(void) {*((Type*)this) = 0;}
	//DEF_SETZEROS is used with bit fields

///////////////////////////////////////////////////////
#define DEF_SYSINIT(Name, Statement)		\
	class _Ci##Name {						\
	public:									\
		inline _Ci##Name() {Statement;}		\
	};										\
	static _Ci##Name _si_##Name;

#define DEF_SYSCLEANUP(Name, Statement)		\
	class _Cc##Name {						\
	public:									\
		inline ~_Cc##Name() {Statement;}	\
	};										\
	static _Cc##Name _sc_##Name;

#endif //_is_jedi_defs_H
