/*	debug.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/15/0 12:10PM
	$Header: /cvsroot/jedi/include/jedi/debug.h,v 1.8 2000/09/26 10:09:26 tomyeh Exp $
	Purpose:	Debug utilities
	Description:
		Includes TRACE, ASSERT, ...
		If NTRACE is defined, all trace func
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_debug_H
#define _is_jedi_debug_H

#include <jedi/kernel.h>

/////////////////////////////////////////////////////////
//TRACE
#if defined(NDEBUG) || defined(NTRACE)

#ifdef CAN_CPP_VALIST
#define TRACE(fmt, args...)			((void)0)
#define TRACEEX(cond, fmt, args...)	((void)0)
#define TRACEL(val, fmt, args...)	((void)0)

#else //CAN_CPP_VALIST

inline void _utlTrace(const char*,...) {}
inline void _utlTraceEx(int,const char*,...) {}
#define TRACE		1 ? ((void)0): ::_utlTrace
#define TRACEEX		1 ? ((void)0): ::_utlTraceEx
#define TRACEL		TRACEEX

#endif //CAN_CPP_VALIST

#else //NDEBUG

#ifndef TRACELEVEL
#define TRACELEVEL	5
#endif

void utlTrace(const char* fmt, va_list valist);
void utlTrace(const char* fmt, ...);

typedef void (*_utlTrace_f)(const char*, ...);
inline _utlTrace_f utlPreTrace(const char* flnm, int lnno)
{
	utlTrace("%s, %d: ", flnm, lnno);
	return utlTrace;
}

#ifdef CAN_CPP_VALIST

#define TRACE(fmt, args...)			(*::utlPreTrace(__FILE__, __LINE__))(fmt, ## args)
#define TRACEEX(cond, fmt, args...)	((cond) ? (void)TRACE(fmt, ## args): ((void)0))
#define TRACEL(val, fmt, args...)	TRACEEX((val) >= (TRACELEVEL), fmt, ## args)

#else //CAN_CPP_VALIST
void utlTraceCond(int cond, char* fmt, ...);
void utlTraceLevel(int level, char* fmt, ...);
typedef void (*_utlTraceCond_f)(int, char*, ...);

inline _utlTraceCond_f utlPreTraceEx(const char* flnm, int lnno, _utlTraceCond_f func)
{
	void utlTraceInfo(const char* flnm, int lnno);
	utlTraceInfo(flnm, lnno);
	return func;
}

#define TRACE					(*::utlPreTrace(__FILE__, __LINE__))
#define TRACEEX					(*::utlPreTraceEx(__FILE__, __LINE__, utlTraceCond))
#define TRACEL					(*::utlPreTraceEx(__FILE__, __LINE__, utlTraceLevel))
#endif //CAN_CPP_VALIST

#endif //NDEBUG

/////////////////////////////////////////////////////////
//ASSERT
#ifdef _WIN32_WCE
#include <dbgapi.h>
#else //_WIN32_WCE
#include <assert.h>
#define ASSERT(cond)	assert(cond)
#endif //_WIN32_WCE

#ifdef NDEBUG
#define DOANDASSERT(cond)	((void)(cond))
#else
#define DOANDASSERT(cond)	ASSERT(cond)
#endif

#define TRACELINE()			TRACE("\n")

#endif //_is_jedi_debug_H
