/*	dbmem.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/31 06:06PM
	$Header: /cvsroot/jedi/include/jedi/dbmem.h,v 1.2 2000/09/08 11:58:16 henrichen Exp $
	Purpose:	
	Description:	Implementaion header of Jedi's file db, associated memory handle

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_dbmem_H
#define _is_jedi_dbmem_H

//////////////////////////////////////////////////////////////////
class CFileDB;
//jdx node in memory
struct TDBMemChunk : public TMemChunk {
	unsigned		idx;
#ifndef	NDEBUG
	CFileDB		*m_pDB;	//which db this record is on.
#endif	//!NDEBUG
};

#define	DBMEM_EXTRASIZE	(sizeof(TDBMemChunk)-sizeof(TMemChunk))

//////////////////////////////////////////////////////////////////
class CDBMemNode : public CRBNode {
public:
	CDBMemNode(TDBMemChunk *pmc) : m_pmc(pmc){}
	TDBMemChunk *m_pmc;
};

class CJdxNode;
class CDBMemTree : CRBTree {
public:	
	bool Attach(TDBMemChunk *pmc);
		//attach an existing memory chunk into the CDBMemTree
	TDBMemChunk *Detach(unsigned idx);
	TDBMemChunk *Search(unsigned idx);
	void Clean(void);	//delete the whole tree
	
	~CDBMemTree(){Clean();}

	int Comp(void *key, CRBNode *node);
	void Copy(CRBNode *dst, CRBNode *src);
	
protected:
	void CleanNode(CDBMemNode *n);
};

#endif //_is_jedi_dbmem_H
