/*	chnkmgr.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/24 02:57PM
	$Header: /cvsroot/jedi/include/jedi/chnkmgr.h,v 1.2 2000/09/08 11:58:16 henrichen Exp $
	Purpose:	
	Description:	Implementation of Jedi's file db system, jdb file chunk manager

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_chnkmgr_H
#define _is_jedi_chnkmgr_H

class CJdxFile;
class CJdbFile;
class CJdxNode;
class CFreeNode;
class CFreeChunk;
class CArrayChunk;
class CChunkMgr {
public:
	CChunkMgr(CJdbFile *dbf, CJdxFile *dxf): m_jdbfile(dbf), m_jdxfile(dxf), 
		m_freenode(dxf), m_freechunk(dxf){}

	//alloc, free	
	inline bool Alloc(CJdxNode *pn, size_t size);
	bool Resize(CJdxNode *pn, size_t size);
	bool Free(CJdxNode *pn);

#ifndef	NDEBUG
	bool Check(CArrayChunk *arrayChunk, unsigned *maxFreeNodeIdx,
				unsigned *maxFreeChunkIdx, unsigned long *maxFreeChunkOffset);
	void Dump(void);
#endif	//!NDEBUG
	
	//data
	CJdbFile 	*m_jdbfile;
	CJdxFile 	*m_jdxfile;
	CFreeNode 	m_freenode;
	CFreeChunk	m_freechunk;
	
protected:
	bool ResizeEx(CJdxNode *pn, size_t size);
	bool AllocEx(CJdxNode *pn, size_t size);
	bool Merge(CJdxNode *pn);
};

inline bool CChunkMgr::Alloc(CJdxNode *pn, size_t size)
{
	ASSERT(pn && size);
	
	return AllocEx(pn, CHUNK_ALIGN(size+sizeof(TChunkHeader)));
}

#endif //_is_jedi_chnkmgr_H
