/*	arychnk.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/23 12:08PM
	$Header: /cvsroot/jedi/include/jedi/arychnk.h,v 1.3 2000/09/19 10:20:53 henrichen Exp $
	Purpose:	
	Description:	
		1.Implementation header of array chunk management in *.jdx file. 
		2.See also jedidb.h

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_arychnk_H
#define _is_jedi_arychnk_H

//Helper structure to be used to return information during RBTree traversing
struct TRBTreeInfo {
	unsigned	idx;
	bool		bUpdateRoot;
	bool		bLeft;
	
	TRBTreeInfo() : idx(0), bUpdateRoot(false), bLeft(false){}
};


class CJdxFile;
class CArrayChunk {
public:
	CArrayChunk(CJdxFile *file) : m_jdxfile(file) {}
	
	bool Attach(CJdxNode *pn, unsigned key);
		//Attach a jdx node into the rb-tree
	bool Detach(CJdxNode *pn, unsigned key);
		//Detach a jdx node from the rb-tree
	unsigned Search(CJdxNode *pn, unsigned key);
		//Return the jdx node with the given key(array index), 0 if cannot find
	inline int Search(unsigned idx);
		//Given node index, return key(array index), -1 if cannot find
	
#ifndef	NDEBUG
	void Dump(void);
	bool Check(unsigned *maxIdx, unsigned long *maxOff);
	unsigned SearchOffset(unsigned long offset);
#endif

protected:
	bool Insert(unsigned idx, unsigned baseKey, CJdxNode *pX, unsigned key,
		CJdxNode *pGGPa, CJdxNode *pGPa, CJdxNode *pPa, TRBTreeInfo *nextX);
	bool InsertFix(CJdxNode *pGGPa, CJdxNode *pGPa, CJdxNode *pPa, 
		CJdxNode *pX, TRBTreeInfo *nextX);
	bool Delete(unsigned idx, unsigned baseKey, CJdxNode *pZ, unsigned key, 
		CJdxNode *pGPa, CJdxNode *pPa, TRBTreeInfo *nextX);
	bool DeleteFix(CJdxNode *pGPa, CJdxNode *pPa, 
		CJdxNode *pX, TRBTreeInfo *nextX);
	bool SetRootToBlack(void);
	bool RightRotate(CJdxNode *pPa, CJdxNode *pY, CJdxNode *pX);
	bool LeftRotate(CJdxNode *pPa, CJdxNode *pX, CJdxNode *pY);
	int Traverse(unsigned idx, unsigned nodeidx, unsigned baseKey);
	
#ifndef	NDEBUG
	void PrintNode(unsigned idx, unsigned baseKey, int tab, int pos, unsigned *maxIdx);
	bool CheckNode(unsigned idx, CJdxNode *pPa, unsigned *numBlack, unsigned *numChild, unsigned *maxIdx, unsigned long *maxOff);
	unsigned SearchNode(unsigned idx, unsigned long offset);
#endif

	//data
	CJdxFile	*m_jdxfile;
};

inline int CArrayChunk::Search(unsigned nodeidx)
{
	ASSERT(m_jdxfile);
	return (nodeidx == 0) ? -1 : Traverse(m_jdxfile->GetArrayChunkRoot(), nodeidx, 0);
}	


#endif //_is_jedi_arychnk_H
