/*	arbtree.h

{{IS_NOTE

		Authors:	Henri Chen
		Contributors:
		Create Date:	2000/9/28 08:04PM
		$Header: $
		Purpose:	
		Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_minidb_arbtree_H
#define _is_minidb_arbtree_H

class CARBNode : public CRBNode {
public:
	CARBNode() : m_lnum(0), m_rnum(0) {}

	unsigned GetLNum(void) {return m_lnum;}
	unsigned GetRNum(void) {return m_rnum;}
	void SetLNum(unsigned n) {m_lnum= n; Modify();}
	void SetRNum(unsigned n) {m_rnum= n; Modify();}

	void IncLNum(void) {m_lnum++; Modify();}
	void DecLNum(void) {m_lnum--; Modify();}
	void IncRNum(void) {m_rnum++; Modify();}
	void DecRNum(void) {m_rnum--; Modify();}
	
protected:
	//data
	unsigned m_lnum, m_rnum;
};

//////////////////////////////////////////////////////////////////
class CARBTree;
struct TARBKey {
	unsigned base;
	TARBKey() : base(0) {}
};

struct TAryIndex : TARBKey {
	unsigned index;

	TAryIndex(unsigned idx) : index(idx) {}
};

//////////////////////////////////////////////////////////////////
class CARBTree : public CRBTree {
public:
	void Attach(CARBNode *, unsigned index);
		//attach a node onto the array tree at position specified by index
		//if index is out of the range, it is appended
	void Detach(RamPtr<CARBNode> *pDelNode, unsigned index);
		//detach a node at position specified by index. If not found, return NULL.
	void Attach(CARBNode *, TARBKey *key);
		//attach a node onto the array tree at position specified by index
		//if index is out of the range, it is appended
	void Detach(RamPtr<CARBNode> *pDelNode, TARBKey *key);
		//detach a node from the tree. If not found, return NULL.
	unsigned Search(RamPtr<CARBNode> *pFoundNode, unsigned index);
		//search a node in the tree. 
		//If not found, put NULL in pFoundNode; return insertion index
	unsigned Search(RamPtr<CARBNode> *pFoundNode, TARBKey *key);
		//search a node in the tree and return its array index, 
		//if not found, put NULL in pFoundNode; return insertion index
		
#ifndef NDEBUG
	bool Check(void);
	bool CheckNode(CARBNode *, RamPtr<CARBNode> , unsigned *bn);
	void Dump(void (*printKey)(CARBNode*));
	void PrintNode(RamPtr<CARBNode> x, int level, int pos, void (*printKey)(CARBNode*), unsigned base);
#endif	//!NDEBUG
		
protected:
	void LeftRotate(CARBNode* pa, CARBNode* x);
	void RightRotate(CARBNode* pa, CARBNode* x);
	void InsertFix(CARBNode* ggpa, CARBNode* gpa, CARBNode* pa, CARBNode* x, CARBNode **nextX);
	void DeleteFix(CARBNode* gpa, CARBNode* pa, CARBNode* x, CARBNode **nextX, bool bLeft);
	unsigned Search(RamPtr<CARBNode> *pFoundNode, TARBKey *key, _comp_ft cmp);
	void Insert(RamPtr<CARBNode> root, CARBNode* z, TARBKey* key, CARBNode *ggpa, CARBNode *gpa, CARBNode *pa, CARBNode **nextX, _comp_ft cmp);
	void Delete(RamPtr<CARBNode> root, TARBKey* key, CARBNode *gpa, CARBNode *pa, CARBNode **nextX, RamPtr<CARBNode> *, _comp_ft cmp);
};

typedef void (CARBTree::*_arbtree_rotate_ft)(CARBNode* pa, CARBNode* x);
#endif //_is_minidb_arbtree_H
