/*	wingdi.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	7/21/0 10:12AM
	$Header: /cvsroot/jedi/include/iwf/wingdi.h,v 1.1.1.1 2000/07/21 02:40:49 tomyeh Exp $
	Purpose:	Windows GDI
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_iwf_wingdi_H
#define _is_iwf_wingdi_H

#include <iwf/winuser.h>

///////////////////////////////////////////////////////
class CDC {
public:
	CDC(CWnd* wnd) {m_hDC = ::GetDC(m_hWnd = wnd ? wnd->m_hWnd: 0);}
	~CDC() {if(m_hDC) ::ReleaseDC(m_hWnd, m_hDC);}

	operator HDC() const {return m_hDC;}

protected:
	CDC() {}

public:
	HDC	m_hDC;
	HWND m_hWnd;
};

class CPaintDC : public CDC {
public:
	CPaintDC(CWnd* wnd) {
		ASSERT(wnd);
		m_hDC = BeginPaint(m_hWnd = wnd->m_hWnd, &m_ps);
	}
	~CPaintDC() {EndPaint(m_hWnd, &m_ps); m_hDC = 0;}

protected:
	PAINTSTRUCT m_ps;
};

class CMemDC : public CDC {
public:
	//Note: to simplify the code, we initial m_hDC in constructor
	//though it might fail. Thus, you have to check m_hDC after
	//the code
	CMemDC(HBITMAP hBmp, HDC hDC =0) {
		ASSERT(hBmp);
		m_hDC = CreateCompatibleDC(hDC);
		if(m_hDC)
			m_old = SelectObject(m_hDC, hBmp);
	}
	~CMemDC() {
		if(m_hDC){
			SelectObject(m_hDC, m_old);
			DeleteObject(m_hDC);
			m_hDC = 0;
		}
	}

protected:
	HGDIOBJ m_old;
};

#endif //_is_iwf_wingdi_H
