/*	winchar.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/25/0 01:52PM
$Header: /cvsroot/jedi/include/iwf/winchar.h,v 1.6 2000/08/09 11:45:35 tomyeh Exp $
Purpose:	Unicode utilities
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_iwf_winchar_H
#define _is_iwf_winchar_H
#include <tchar.h>

/////////////////////////////////////////////////////////////////
inline int _STDCALL MbsToWcs(const char* mbs,int nMbs,wchar_t* wcs,int nWcs)
{return MultiByteToWideChar(CP_ACP, 0, mbs, nMbs, wcs, nWcs);}
inline int _STDCALL WcsToMbs(const wchar_t* wcs,int nWcs,char* mbs,int nMbs)
{return WideCharToMultiByte(CP_ACP, 0, wcs, nWcs, mbs, nMbs, 0, 0);}

LPSTR WINAPI lstrcpynA(LPSTR lpString1, LPCSTR lpString2, int iMaxLength);
LPWSTR WINAPI lstrcpynW(LPWSTR lpString1, LPCWSTR lpString2, int iMaxLength);

#ifdef _UNICODE
#define lstrcpyn	lstrcpynW
#else //_UNICODE
#define lstrcpyn	lstrcpynA
#endif //_UNICODE

#define strcpyn		lstrcpyn

/////////////////////////////////////////////////////////////////
#undef A2W
#undef A2CW
#undef A2T
#undef A2CT
#undef W2A
#undef W2CA
#undef W2T
#undef W2CT

#define A2W_LEN		0x20000000

inline wchar_t* _STDCALL _MbsToWcsP(const char* mbs,int nMbs,wchar_t* wcs,int nWcs)
{MbsToWcs(mbs, nMbs, wcs, nWcs); return wcs;}
inline char* _STDCALL _WcsToMbsP(const wchar_t* wcs,int nWcs,char* mbs,int nMbs)
{WcsToMbs(wcs, nWcs, mbs, nMbs); return mbs;}
	//Note _XxToYyP assumes XxToYy always succeed, since it is used only by
	//the following macros

//_X2Y assumes p is not NULL
#define _A2WN(p, n)		_MbsToWcsP((p), (n), (LPWSTR)_alloca((n)*sizeof(WCHAR)), (n))
#define _W2AN(p, n)		_WcsToMbsP((p), (n),  (LPSTR)_alloca((n)*sizeof(WCHAR)), (n)*sizeof(WCHAR))
#define _A2CWN(p,n)		((LPCWSTR)_A2WN(p, n))
#define _W2CAN(p,n)		((LPCTSTR)_W2AN(p, n))
	//Note: to have better performance, n shall not be an expression

#define _A2W(p)		_MbsToWcsP((p), -1, (LPWSTR)_alloca((strlen(p)+1)*sizeof(WCHAR)), A2W_LEN)
#define _W2A(p)		_WcsToMbsP((p), -1, (LPSTR)_alloca((lstrlenW(p)+1)*sizeof(WCHAR)), A2W_LEN)
#define _A2CW(p)	((LPCWSTR)_A2W(p))
#define _W2CA(p)	((LPCTSTR)_W2A(p))

#define A2W(p)		((p) ? _A2W(p): 0)
#define W2A(p)		((p) ? _W2A(p): 0)
#define A2CW(p)		((LPCWSTR)A2W(p))
#define W2CA(p)		((LPCTSTR)W2A(p))

#ifdef UNICODE
	#define _A2TN(p, n)		_A2WN(p, n)
	#define _A3CTN(p, n)	_A2CWN(p, n)
	#define _W2TN(p, n)		(p)
	#define _W2CTN(p, n)	((LPCWSTR)(p))

	#define _T2AN(p, n)		_W2AN(p, n)
	#define _T2CAN(p, n)	_W2CAN(p, n)
	#define _T2WN(p, n)		(p)
	#define _T2CWN(p, n)	((LPCWSTR)(p))

	#define _A2T(p)		_A2W(p)
	#define _A2CT(p)	_A2CW(p)
	#define _W2T(p)		(p)
	#define _W2CT(p)	((LPCWSTR)(p))

	#define _T2A(p)		_W2A(p)
	#define _T2CA(p)	_W2CA(p)
	#define _T2W(p)		(p)
	#define _T2CW(p)	((LPCWSTR)(p))

	#define A2T(p)		A2W(p)
	#define A2CT(p)		A2CW(p)
	#define W2T(p)		(p)
	#define W2CT(p)		((LPCWSTR)(p))

	#define T2A(p)		W2A(p)
	#define T2CA(p)		W2CA(p)
	#define T2W(p)		(p)
	#define T2CW(p)		((LPCWSTR)(p))

#else
	#define _A2TN(p, n)		(p)
	#define _A3CTN(p, n)	((LPCWSTR)(p))
	#define _W2TN(p, n)		_W2AN(p, n)
	#define _W2CTN(p, n)	_W2CAN(p, n)

	#define _T2AN(p, n)		(p)
	#define _T2CAN(p, n)	((LPCSTR)(p))
	#define _T2WN(p, n)		_A2WN(p, n)
	#define _T2CWN(p, n)	_A2CWN(p, n)

	#define _A2T(p)		(p)
	#define _A2CT(p)	((LPCSTR)(p))
	#define _W2T(p)		_W2A(p)
	#define _W2CT(p)	_W2CA(p)

	#define _T2A(p)		(p)
	#define _T2CA(p)	((LPCSTR)(p))
	#define _T2W(p)		_A2W(p)
	#define _T2CW(p)	_A2CW(p)

	#define A2T(p)		(p)
	#define A2CT(p)		((LPCSTR)(p))
	#define W2T(p)		W2A(p)
	#define W2CT(p)		W2CA(p)

	#define T2A(p)		(p)
	#define T2CA(p)		((LPCSTR)(p))
	#define T2W(p)		A2W(p)
	#define T2CW(p)		A2CW(p)
#endif //_UNICODE

#endif //_is_iwf_winchar_H
