/*	iwfwnd.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	8/3/0 02:04PM
$Header: /cvsroot/jedi/include/iwf/iwfwnd.h,v 1.7 2000/10/12 08:26:27 tomyeh Exp $
Purpose:	CWnd, CFrame, CDlg,...
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_iwf_iwfwnd_H
#define _is_iwf_iwfwnd_H

///////////////////////////////////////////////////////
class CWnd {
public:
	operator HWND() const {return m_hWnd;}

	inline HWND WINAPI Create(LPCTSTR clsname, LPCTSTR title,
		DWORD style, DWORD exStyle, int x, int y, int wd, int hgh, HINSTANCE hInst)
	{return m_hWnd = ::CreateWindowEx(exStyle, clsname, title, style, x, y, wd, hgh, 0, 0, hInst, this);}
		//WNDCLASS::cbWndExtra must be at least sizeof(void*) and first entry is reserved

	inline LRESULT WINAPI DefWndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
		{return ::DefWindowProc(m_hWnd, uMsg, wParam, lParam);}

	inline BOOL ShowWindow(int nCmdShow) {return ::ShowWindow(m_hWnd, nCmdShow);}
	inline BOOL InvalidateRect(const RECT* rect, BOOL bErase = TRUE)
		{return ::InvalidateRect(m_hWnd, rect, bErase);}

	inline BOOL UpdateWindow() {return ::UpdateWindow(m_hWnd);}

	inline BOOL BringWindowToTop() {return ::BringWindowToTop(m_hWnd);}
	inline BOOL SetForegroundWindow() {return ::SetForegroundWindow(m_hWnd);}

	inline LRESULT SendMessage(UINT uMsg, WPARAM wParam=0, LPARAM lParam=0) const
		{return ::SendMessage(m_hWnd, uMsg, wParam, lParam);}
	inline BOOL PostMessage(UINT uMsg, WPARAM wParam=0, LPARAM lParam=0) const
		{return ::PostMessage(m_hWnd, uMsg, wParam, lParam);}
	inline BOOL PostCommand(UINT nId) const {return PostMessage(WM_COMMAND, nId);}

	//item related functions
	inline HWND GetItem(int nId) {return ::GetDlgItem(m_hWnd, nId);}

	LRESULT SendItemMessage(int nId, UINT uMsg, WPARAM wParam=0, LPARAM lParam=0);

	inline unsigned IsItemChecked(int nId) {return (unsigned)SendItemMessage(nId, BM_GETCHECK);}
		//return one of BST_CHECKED, BST_INDETERMINATE and BST_UNCHECKED
	inline void CheckItem(int nId, UINT uCheck =BST_CHECKED) {SendItemMessage(nId, BM_SETCHECK, uCheck);}

	inline int GetItemText(int nId, LPTSTR lpString, int nMaxCount)
		{return (int)::GetWindowText(GetItem(nId), lpString, nMaxCount);}
	inline BOOL SetItemText(int nId, LPCWSTR lpString) {return ::SetWindowText(GetItem(nId), lpString);}

	static CWnd* PreWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
		//Derived class shall call this function in its wnd proc

public:
	//data member
	HWND m_hWnd;
};

///////////////////////////////////////////////////////
class CFrame : public CWnd {
public:
	CFrame();

	void MoveByClient(int wdClient, int hghClient);
		//Move a frame window by its client size

	static CFrame* PreWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
		//Derived class shall call this function in its wnd proc

	//data members
	SHACTIVATEINFO m_sai;
};

///////////////////////////////////////////////////////
class CCmdBar : public CWnd {
public:
	HWND Create(CWnd* pParentWnd, UINT nRscId);
	inline void Destroy() {CommandBar_Destroy(m_hWnd);}

	inline HMENU GetMenu(unsigned menuResId) const {return (HMENU)SendMessage(SHCMBM_GETMENU, 0, menuResId);}
	inline HMENU GetSubMenu(unsigned menuResId) const {return (HMENU)SendMessage(SHCMBM_GETSUBMENU, 0, menuResId);}
	inline HMENU SetSubMenu(unsigned nId, HMENU hMenu) const {return (HMENU)SendMessage(SHCMBM_SETSUBMENU, nId, (LPARAM)hMenu);}
		//Don't use CommandBar_GetMenu or CommandBar_InsertMenuBar for WCE 3.0

	inline int GetButtonCount() const {return SendMessage(TB_BUTTONCOUNT);}
	
	inline BOOL AddAdornments(DWORD flags)
	{return ::CommandBar_AddAdornments(m_hWnd, flags, 0);}
	inline BOOL AddBitmap(HINSTANCE hInst, int nRscBmp, int nNumImages, int width=16, int height=16)
	{return ::CommandBar_AddBitmap(m_hWnd, hInst, nRscBmp, nNumImages, width, height);}
	inline BOOL AddButtons(int nNumButtons, const TBBUTTON* pButtons)
	{return ::CommandBar_AddButtons(m_hWnd, nNumButtons, pButtons);}
	inline BOOL AddToolTips(int nNumToolTips, const LPCTSTR *pToolTips)
	{return ::CommandBar_AddToolTips(m_hWnd, nNumToolTips, pToolTips);}

	inline BOOL InsertButton(int nIndex, const TBBUTTON* pButton)
	{return ::CommandBar_InsertButton(m_hWnd, nIndex, pButton);}
	inline BOOL DeleteButton(int nIndex)
	{return SendMessage(TB_DELETEBUTTON, nIndex);}

	inline BOOL HideButton(int nId, BOOL bHide =TRUE)
	{return SendMessage(TB_HIDEBUTTON, nId, MAKELONG(bHide, 0));}
	inline BOOL EnableButton(int nId, BOOL bEnable =TRUE)
	{return SendMessage(TB_ENABLEBUTTON, nId, MAKELONG(bEnable, 0));}

	inline BOOL Redraw(int nIndex) {return ::CommandBar_DrawMenuBar(m_hWnd, (WORD)nIndex);}

	inline BOOL Show(BOOL fShow) {return ::CommandBar_Show(m_hWnd, fShow);}
};

///////////////////////////////////////////////////////
class CDlg : public CWnd {
public:
	inline int Create(CWnd* pParentWnd, DLGPROC pDlgProc, UINT nResId, HINSTANCE hInst)
	{return ::DialogBoxParam(hInst, MAKEINTRESOURCE(nResId), pParentWnd->m_hWnd, pDlgProc, (LPARAM)this);}
		//return IDOK, IDCANCEL...
	inline BOOL Destroy(int nResult) {return EndDialog(m_hWnd, nResult);}

	static CDlg* PreWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
		//Derived class shall call this function in its wnd proc

public:
	//data member
	CCmdBar m_cmdBar;
};

#endif //_is_iwf_iwfwnd_H
