/*	types.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/20/0 08:59PM
	$Header: /cvsroot/jedi/include/anakin/types.h,v 1.19 2000/10/12 01:50:46 henrichen Exp $
	Purpose:	Types of Anakin
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_anakin_types_H
#define _is_anakin_types_H

//////////////////////////////////////////////////////////
//NOTE: To define the data types of Palm, you don't need to include
//jedi's headers unless you need to pass the content of a data type,
//rather than a pointer. Since most data types are passed as pointer,
//you can define it as "typedef struct TJediType AnakinType;"

#include <jedi/errmgr.h>	//we need the content of ErrJumpBuf
#include <jedi/time.h>		//we need the content of TDate

//////////////////////////////////////////////////////////
typedef __u32			UInt32;
typedef __u16			UInt16;
typedef __u8			UInt8;

typedef __s32			Int32;
typedef __s16			Int16;
typedef __s8			Int8;

typedef bool			Boolean;
typedef char			Char;
typedef UInt16			WChar;

typedef _err_t			Err;
typedef UInt32			LocalID;
typedef Int16			LocalIDKind;
typedef Int16 			Coord;
typedef void			*MemPtr;

typedef struct TMemChunk		*MemHandle;

typedef struct TEvent			EventType;
typedef struct TEvent			SysEventType;
typedef struct TPenBtnInfo		PenBtnInfoType;
typedef struct TPoint			PointType;
typedef	struct TRect			RectangleType;
typedef	struct TFont			FontType;
typedef	FontType*				FontPtr;

typedef struct TForm			FormType;
typedef struct TMenubar			MenuBarType;
typedef Int16					MenuCmdBarResultType;
typedef Int16					FormObjectKind;
typedef Int16					ControlStyleType;
typedef Int16					FontID;
typedef struct TObjCtl			ControlType;
typedef struct TObjLabel		FormLabelType;
typedef struct TFormActiveState	FormActiveStateType;

typedef Boolean _AAPI FormEventHandlerType(EventType*);

typedef struct TBmp				BitmapType;
typedef struct TFont			FontType;
typedef struct TWin				WindowType;
typedef struct TWin				*WinHandle;
typedef struct TColorTable		ColorTableType;	//note, TColorTable is not equal to Palm's ColorTableType
												//Jedi VM has to adjust this!
typedef	struct TPalette			RGBColorType;
typedef Int16					BitmapCompressionType;

typedef UInt16					FrameType;
typedef Int16					WindowFormatType;
typedef Int16					WinDrawOperation;
typedef	Char					CustomPatternType[8];
typedef Int16					UnderlineModeType;
typedef	Int16					WinDirectionType;
typedef UInt8					IndexedColorType;
typedef struct WinLineType {Coord x1, y1, x2, y2;} WinLineType;
typedef	Int16					PatternType;

//typedef TDBRef					*DmOpenRef;
typedef UInt32					DmResType;
typedef	UInt16					DmResID;

typedef struct TDate			DateType;
typedef DateType*				DatePtr;
typedef struct TDateTime		DateTimeType;
typedef DateTimeType*			DateTimePtr;

typedef jmpbuf_t	ErrJumpBuf;

typedef Int32 _AAPI_PF(ProcPtr)();

typedef UInt32					ThreadID;
typedef UInt32					ProcessID;
typedef void _AAPI_PF(ThreadProcPtr)(MemPtr);

typedef _mutex_t				*MutexHandle;
typedef _cond_t					*CondHandle;

#endif //_is_anakin_types_H
