/*	api.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	8/17/0 05:46PM
$Header: /cvsroot/jedi/include/anakin/api.h,v 1.25 2000/10/12 01:50:46 henrichen Exp $
Purpose:	Anakin APIs
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_anakin_api_H
#define _is_anakin_api_H

#include <jedi/mem.h>

EXTERN_C_BEGIN

#define _JDK_API0(Rt, Fn)	Rt _AAPI sys##Fn(void);
#define _JDK_API1(Rt, Fn, a1)	Rt _AAPI sys##Fn(a1);
#define _JDK_API2(Rt, Fn, a1, a2)	Rt _AAPI sys##Fn(a1, a2);
#define _JDK_API3(Rt, Fn, a1, a2, a3)	Rt _AAPI sys##Fn(a1, a2, a3);
#define _JDK_API4(Rt, Fn, a1, a2, a3, a4)	Rt _AAPI sys##Fn(a1, a2, a3, a4);
#define _JDK_API5(Rt, Fn, a1, a2, a3, a4, a5)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5);
#define _JDK_API6(Rt, Fn, a1, a2, a3, a4, a5, a6)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6);
#define _JDK_API7(Rt, Fn, a1, a2, a3, a4, a5, a6, a7)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6, a7);
#define _JDK_API8(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6, a7, a8);
#define _JDK_API9(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6, a7, a8, a9);
#define _JDK_API10(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
#define _JDK_API11(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
#define _JDK_API12(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
#define _JDK_API13(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13)	Rt _AAPI sys##Fn(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
#define _JDK_PRIME_
#define _JDK_EXT_
#include <anakin/_traps.h>

#ifndef _MSC_VER
//Note: GNU cannot accept the conversion of a function pointer
//from one type to another, if it contains __attribute__((cdecl))
//Fortunately, Palm uses C calling convention, so we can change it
//definition here w/o affecting its meaning
#undef	_AAPI_P
#define _AAPI_P	(*)
#endif

#define sysMemInit						SysTrap
#define sysMemInitHeapTable				((Err _AAPI_P(UInt16))SysTrap)
#define sysMemStoreInit					SysTrap
#define sysMemCardFormat				((Err _AAPI_P(UInt16, Char*, Char*, Char*))SysTrap)
#define sysMemStoreSetInfo				((Err _AAPI_P(UInt16,UInt16,UInt16*,UInt16*,Char*,UInt32*,UInt32*,UInt32*,UInt32*,UInt32*,LocalID*))SysTrap)
#define sysMemHeapPtr					((MemPtr _AAPI_P(UInt16))SysTrap)
#define sysMemHeapInit					((Err _AAPI_P(UInt16, Int16, Boolean))SysTrap)
#define	sysMemChunkNew					((MemPtr _AAPI_P(UInt16, UInt32, UInt16))SysTrap)
#define	sysMemChunkFree					((Err _AAPI_P(MemPtr))SysTrap)

#define	sysMemPtrFlags					((UInt16 _AAPI_P(MemPtr))SysTrap)

#if defined(OS_RAM_CARD_NO) && OS_RAM_CARD_NO==1
#define sysMemPtrCardNo					((UInt16 _AAPI_P(MemPtr))NullTrap)
#define sysMemHandleCardNo				((UInt16 _AAPI_P(MemHandle))NullTrap)
#endif

#define sysMemPtrResetLock				((Err _AAPI_P(MemPtr))SysTrap)
#define sysMemStoreSearch				SysTrap
#define sysMemPtrDataStorageOld			sysMemPtrDataStorage
#define sysMemKernelInit				SysTrap
#define sysMemHandleFlags				((UInt16 _AAPI_P(MemHandle))SysTrap)

#define sysMemHandleResetLock			((Err _AAPI_P(MemHandle))SysTrap)
#define sysMemSetDebugMode				((Err _AAPI_P(UInt16))NullTrap)
#define sysMemHeapScramble				((Err _AAPI_P(UInt16))NullTrap)
#define sysMemHeapCheck					((Err _AAPI_P(UInt16))NullTrap)
#define sysMemDebugMode					((UInt16 _AAPI_P(void))NullTrap)
#define sysMemSemaphoreReserve			((Err _AAPI_P(Boolean))SysTrap)
#define sysMemSemaphoreRelease			((Err _AAPI_P(Boolean))SysTrap)
#define sysMemNVParams					SysTrap

#define sysErrSetJump					exSetJump
#define sysErrLongJump					exLongJump
#define sysErrThrow						exThrow

#define sysSysInit						((void _AAPI_P(void))SysTrap)

#define	sysTimGetSeconds				GetCurrentSeconds
#define sysTimSetSeconds				SetCurrentSeconds
#define sysTimGetTicks					GetCurrentTicks

#define sysTimSecondsToDateTime			SecondsToDateTime
#define sysTimDateTimeToSeconds			DateTimeToSeconds
#define sysTimAdjust					AddDateTime

#define sysEvtInitialize				SysTrap
#define sysEvtGetPen					evtGetPen //no need to lock

#define sysEvtSysInit					SysTrap
#define sysEvtGetSysEvent				sysEvtGetEvent //we consider than as the same

#define sysEvtProcessSoftKeyStroke		((Err _AAPI_P(PointType*, PointType*))NullTrap)

#define sysEvtFlushPenQueue				NullTrap
#define sysEvtEnqueuePenPoint			((Err _AAPI_P(PointType*))NullTrap)
#define sysEvtDequeuePenStrokeInfo		((Err _AAPI_P(PointType*, PointType*))NullTrap)
#define sysEvtDequeuePenPoint			((Err _AAPI_P(PointType*))NullTrap)
#define sysEvtFlushNextPenStroke		NullTrap

#define sysEvtDequeueKeyEvent			((Err _AAPI_P(SysEventType*,UInt16))NullTrap)

#define sysEvtEnableGraffiti			((void _AAPI_P(Boolean))NullTrap)

#define sysFrmGetUserModifiedState		((Boolean _AAPI_P(const FormType*))SysTrap)
#define sysFrmSetNotUserModified		((void _AAPI_P(FormType*))SysTrap)

#define sysFrmCopyLabel					sysFrmSetLabel

#define sysFrmGetFirstForm				frmGetFirstForm //no need to lock

#define	sysFrmCopyTitle					((void _AAPI_P(FormType*, const Char*))sysFrmSetTitle)

#define sysUIInitialize					((void _AAPI_P(void))SysTrap)
#define sysUIReset						((void _AAPI_P(void))SysTrap)

#define sysWinSetDrawWindow				winSetDrawWindow //no need to lock (thread local)
#define sysWinGetDrawWindow				winGetDrawWindow //no need to lock

#define sysDayOfWeek					((Int16 _AAPI_P(Int16,Int16,Int16))DayOfWeek)
#define sysDaysInMonth					((Int16 _AAPI_P(Int16,Int16))DaysInMonth)
#define sysDayOfMonth					((Int16 _AAPI_P(Int16,Int16,Int16))DayOfMonth)
#define sysDateDaysToDate				DaysToDate
#define sysDateToDays					DateToDays
#define sysDateAdjust					AddDate
#define sysDateSecondsToDate			SecondsToDate

#define sysKeyInit						SysTrap
#define sysKeyHandleInterrupt			SysTrap
#define sysKeyResetDoubleTap			SysTrap
#define sysKeySleep						SysTrap
#define sysKeyWake						SysTrap

#define sysMemCmp						((Int16 _AAPI_P(const void*, const void*, Int32))memcmp)

#define sysSysReserved1					SysTrap
#define sysSysReserved2					SysTrap
#define sysSysReserved3					SysTrap
#define sysOEMDispatch					SysTrap

#define sysKeyBootKeys					SysTrap

#define sysMenuEraseMenu				SysTrap

#define sysSysUICleanup					SysTrap

#define	sysRctSetRectangle 				rctSet
#define	sysRctCopyRectangle 			rctCopy
#define	sysRctInsetRectangle			rctInset
#define	sysRctOffsetRectangle 			rctOffset
#define	sysRctPtInRectangle				rctPtInRect
#define	sysRctGetIntersection			rctIntersect

#define	sysFntCharWidth 				fntCharWidth
#define	sysFntAverageCharWidth			fntAverageCharWidth
#define	sysFntBaseLine					fntBaseLine
#define	sysFntCharHeight				fntCharHeight
#define	sysFntCharsInWidth				fntCharsInWidth
#define	sysFntCharsWidth				fntCharsWidth
#define	sysFntDefineFont				fntDefineFont
#define	sysFntDescenderHeight			fntDescenderHeight
#define	sysFntGetFont					fntGetFont
#define	sysFntGetFontPtr				fntGetFontPtr
#define	sysFntGetScrollValues			fntGetScrollValues
#define	sysFntLineHeight				fntLineHeight
#define	sysFntLineWidth					fntLineWidth
#define	sysFntSetFont					fntSetFont
#define	sysFntWidthToOffset				fntWidthToOffset
#define	sysFntWordWrap					fntWordWrap
#define	sysFntWordWrapReverseNLines 	fntWordWrapReverseNLines

#define	sysBmpColortableSize			bmpGetColorTableSize
#define	sysBmpGetColortable				bmpGetColorTable
#define	sysBmpCompress					((Err _AAPI_P(BitmapType *, BitmapCompressionType ))NullTrap)

#define	sysWinInitializeWindow			((void _AAPI_P(WinHandle))SysTrap)
#define	sysWinAddWindow					((void _AAPI_P(WinHandle))SysTrap)
#define	sysWinRemoveWindow				((void _AAPI_P(WinHandle))SysTrap)
#define	sysWinEnableWindow				((void _AAPI_P(WinHandle))SysTrap)
#define	sysWinDisableWindow				((void _AAPI_P(WinHandle))SysTrap)
#define	sysWinDrawWindowFrame			((void _AAPI_P(void))SysTrap)

#define	sysWinPushDrawState				winPushDrawState
#define	sysWinPopDrawState				winPopDrawState
#define	sysWinSetDrawMode				gdiSetDrawMode
#define	sysWinSetForeColor				gdiSetForeColor
#define	sysWinSetBackColor				gdiSetBackColor
#define	sysWinSetTextColor				gdiSetTextColor
#define	sysWinGetPatternType			gdiGetPatternType
#define	sysWinSetPatternType			gdiSetPatternType
#define	sysWinSetUnderlineMode			gdiSetUnderlineMode

#define	sysStrCat						strcat
//??_JDK_API2(Char*, StrIToA, Char*, Int32)						//0xA0C9
//??_JDK_API2(Int16, StrCaselessCompare, const Char*, const Char*)//0xA0CA
//??_JDK_API2(Char*, StrIToH, Char*, UInt32)					//0xA0CB
#define	sysStrStr						strstr
EXTERN_C int _AAPI atoi( const char *string );
#define	sysStrAToI						atoi
//??_JDK_API2(Char*, StrToLower, Char*, const Char*)			//0xA0CF

#define	sysDmInit						((Err _AAPI_P(void))SysTrap)
////////////////////////////////////////////
//Extension
#define sysMtGetCurrentProcess			mtGetCurrentProcess //no need to lock

#define sysMtLockMutex					mtLockMutex
#define sysMtUnlockMutex				mtUnlockMutex

EXTERN_C_END

////////////////////////////////////////////
//DEF_MT_APIn
#if defined(__i486__) || defined(__i386__)
 #ifdef _MSC_VER
  EXTERN_C void AnakinLockAndJump();

  #define _MTAPI_BODY(Func)					\
		{									\
			__asm lea	eax, Func			\
			__asm jmp	AnakinLockAndJump	\
		}
  		
 #else //_MSC_VER
  EXTERN_C void AnakinLockAndJump(void (*)(void)) _NORETURN;
  #define _MTAPI_BODY(Func)					\
		{									\
			AnakinLockAndJump((void (*)(void))Func); \
		}
 #endif
#else //__i486__
 #error _MTAPI* must be adapted to new processors
#endif

#define DEF_MT_API0(Rt, AFn, JFn)	EXTERN_C _NAKED Rt _AAPI sys##AFn(void) _MTAPI_BODY(JFn)
#define DEF_MT_API1(Rt, AFn, JFn, a1)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1) _MTAPI_BODY(JFn)
#define DEF_MT_API2(Rt, AFn, JFn, a1, a2)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2) _MTAPI_BODY(JFn)
#define DEF_MT_API3(Rt, AFn, JFn, a1, a2, a3)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3) _MTAPI_BODY(JFn)
#define DEF_MT_API4(Rt, AFn, JFn, a1, a2, a3, a4)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4) _MTAPI_BODY(JFn)
#define DEF_MT_API5(Rt, AFn, JFn, a1, a2, a3, a4, a5)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4, a5) _MTAPI_BODY(JFn)
#define DEF_MT_API6(Rt, AFn, JFn, a1, a2, a3, a4, a5, a6)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4, a5, a6) _MTAPI_BODY(JFn)
#define DEF_MT_API7(Rt, AFn, JFn, a1, a2, a3, a4, a5, a6, a7)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4, a5, a6, a7) _MTAPI_BODY(JFn)
#define DEF_MT_API8(Rt, AFn, JFn, a1, a2, a3, a4, a5, a6, a7, a8)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4, a5, a6, a7, a8) _MTAPI_BODY(JFn)
#define DEF_MT_API9(Rt, AFn, JFn, a1, a2, a3, a4, a5, a6, a7, a8, a9)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4, a5, a6, a7, a8, a9) _MTAPI_BODY(JFn)
#define DEF_MT_API10(Rt, AFn, JFn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) _MTAPI_BODY(JFn)
#define DEF_MT_API11(Rt, AFn, JFn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)	EXTERN_C _NAKED Rt _AAPI sys##AFn(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) _MTAPI_BODY(JFn)
	//SFn: The Anakin function exported, e.g., MemHandleSetOwner
	//Fn: The Jedi function implemented, e.g., mmSetOwner
#endif //_is_anakin_api_H
