/*	_traps.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	8/23/0 02:16PM
$Header: /cvsroot/jedi/include/anakin/_traps.h,v 1.18 2000/10/12 01:50:46 henrichen Exp $
Purpose:	Traps
Description:
	Unlike other headers, _traps.h is included implicitly by other headers.
	Before including this header, a header must define _JDK_API0, ..._JDK_API8,
	unless Rt _AAPI_PF(p##Fn)(...) is assumed.

	In additions, we extend Palm API and the extensions is stored in another table.
	To include the prime API, you must define _JDK_PRIME_
	To include the extended API, you must define _JDK_EXT_
	Note _JDK_PRIME_ and _JDK_EXT_ are automatically undefined after included

	Known source codes that include _traps.h are api.cxx...
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _JDK_API0
#define _JDK_API0(Rt, Fn)	Rt _AAPI_PF(p##Fn)(void);
#define _JDK_API1(Rt, Fn, a1)	Rt _AAPI_PF(p##Fn)(a1);
#define _JDK_API2(Rt, Fn, a1, a2)	Rt _AAPI_PF(p##Fn)(a1, a2);
#define _JDK_API3(Rt, Fn, a1, a2, a3)	Rt _AAPI_PF(p##Fn)(a1, a2, a3);
#define _JDK_API4(Rt, Fn, a1, a2, a3, a4)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4);
#define _JDK_API5(Rt, Fn, a1, a2, a3, a4, a5)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5);
#define _JDK_API6(Rt, Fn, a1, a2, a3, a4, a5, a6)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6);
#define _JDK_API7(Rt, Fn, a1, a2, a3, a4, a5, a6, a7)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6, a7);
#define _JDK_API8(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6, a7, a8);
#define _JDK_API9(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6, a7, a8, a9);
#define _JDK_API10(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
#define _JDK_API11(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
#define _JDK_API12(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
#define _JDK_API13(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13)	Rt _AAPI_PF(p##Fn)(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
#endif
#ifndef _JDK_API0_V
#define _JDK_API0_V(Fn)	_JDK_API0(void, Fn)
#define _JDK_API1_V(Fn, a1)	_JDK_API1(void, Fn, a1)
#define _JDK_API2_V(Fn, a1, a2)	_JDK_API2(void, Fn, a1, a2)
#define _JDK_API3_V(Fn, a1, a2, a3)	_JDK_API3(void, Fn, a1, a2, a3)
#define _JDK_API4_V(Fn, a1, a2, a3, a4)	_JDK_API4(void, Fn, a1, a2, a3, a4)
#define _JDK_API5_V(Fn, a1, a2, a3, a4, a5)	_JDK_API5(void, Fn, a1, a2, a3, a4, a5)
#define _JDK_API6_V(Fn, a1, a2, a3, a4, a5, a6)	_JDK_API6(void, Fn, a1, a2, a3, a4, a5, a6)
#define _JDK_API7_V(Fn, a1, a2, a3, a4, a5, a6, a7)	_JDK_API7(void, Fn, a1, a2, a3, a4, a5, a6, a7)
#define _JDK_API8_V(Fn, a1, a2, a3, a4, a5, a6, a7, a8)	_JDK_API8(void, Fn, a1, a2, a3, a4, a5, a6, a7, a8)
#define _JDK_API9_V(Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9)	_JDK_API9(void, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9)
#define _JDK_API10_V(Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)	_JDK_API10(void, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
#define _JDK_API11_V(Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)	_JDK_API11(void, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)
#define _JDK_API12_V(Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12)	_JDK_API12(void, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12)
#define _JDK_API13_V(Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13)	_JDK_API13(void, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13)
#endif

//////////////////////////////////////////////////////////////////////
//Prime API provided by Palm
#ifdef _JDK_PRIME_
_JDK_API0(Err, MemInit)										//0xA000
_JDK_API1(Err, MemInitHeapTable, UInt16)					//0xA001
_JDK_API0(Err, MemStoreInit)								//0xA002 (unknown)
_JDK_API4(Err, MemCardFormat, UInt16, Char*, Char*, Char*)	//0xA003
_JDK_API8(Err, MemCardInfo, UInt16, Char*, Char*, UInt16*,	//0xA004
	UInt32*, UInt32*, UInt32*, UInt32*)
_JDK_API11(Err, MemStoreInfo, UInt16, UInt16, UInt16*,		//0xA005
	UInt16*, Char*, UInt32*, UInt32*, UInt32*, UInt32*, UInt32*, LocalID*)
_JDK_API11(Err, MemStoreSetInfo, UInt16, UInt16, UInt16*,	//0xA006
	UInt16*, Char*, UInt32*, UInt32*, UInt32*, UInt32*, UInt32*, LocalID*)
_JDK_API1(UInt16, MemNumHeaps, UInt16)						//0xA007
_JDK_API1(UInt16, MemNumRAMHeaps, UInt16)					//0xA008
_JDK_API2(UInt16, MemHeapID, UInt16, UInt16)				//0xA009
_JDK_API1(MemPtr, MemHeapPtr, UInt16)						//0xA00A (unknown)
_JDK_API3(Err, MemHeapFreeBytes, UInt16, UInt32*, UInt32*)	//0xA00B
_JDK_API1(UInt32, MemHeapSize, UInt16)						//0xA00C
_JDK_API1(UInt16, MemHeapFlags, UInt16)						//0xA00D
_JDK_API1(Err, MemHeapCompact,UInt16)						//0xA00E
_JDK_API3(Err, MemHeapInit, UInt16, Int16, Boolean)			//0xA00F
_JDK_API2(Err, MemHeapFreeByOwnerID, UInt16, UInt32)		//0xA010 (extend)
_JDK_API3(MemPtr, MemChunkNew, UInt16, UInt32, UInt16)		//0xA011
_JDK_API1(Err, MemChunkFree, MemPtr)						//0xA012
_JDK_API1(MemPtr, MemPtrNew, UInt32)						//0xA013
_JDK_API1(MemHandle, MemPtrRecoverHandle, MemPtr)			//0xA014
_JDK_API1(UInt16, MemPtrFlags, MemPtr)						//0xA015
_JDK_API1(UInt32, MemPtrSize, MemPtr)						//0xA016
_JDK_API1(UInt32, MemPtrOwner, MemPtr)						//0xA017 (extend)
_JDK_API1(UInt16, MemPtrHeapID, MemPtr)						//0xA018
_JDK_API1(UInt16, MemPtrCardNo, MemPtr)						//0xA019
_JDK_API1(LocalID, MemPtrToLocalID, MemPtr)					//0xA01A
_JDK_API2(Err, MemPtrSetOwner, MemPtr, UInt32)				//0xA01B (extend)
_JDK_API2(Err, MemPtrResize, MemPtr, UInt32)				//0xA01C
_JDK_API1(Err, MemPtrResetLock, MemPtr)						//0xA01D
_JDK_API1(MemHandle, MemHandleNew, UInt32)					//0xA01E
_JDK_API1(UInt16, MemHandleLockCount, MemHandle)			//0xA01F
_JDK_API1(LocalID, MemHandleToLocalID, MemHandle)			//0xA020
_JDK_API1(MemPtr, MemHandleLock, MemHandle)					//0xA021
_JDK_API1(Err, MemHandleUnlock, MemHandle)					//0xA022
_JDK_API2(MemPtr, MemLocalIDToGlobal, LocalID, UInt16)		//0xA023
_JDK_API1(LocalIDKind, MemLocalIDKind, LocalID)				//0xA024
_JDK_API2(MemPtr, MemLocalIDToPtr, LocalID, UInt16)			//0xA025
_JDK_API3(Err, MemMove, void*, const void*, Int32)			//0xA026
_JDK_API3(Err, MemSet, void*, Int32, UInt8)					//0xA027
_JDK_API0(Err, MemStoreSearch)								//0xA028 (unknown)
_JDK_API1(Boolean, MemPtrDataStorageOld, MemPtr)			//0xA029
_JDK_API0(Err, MemKernelInit)								//0xA02A
_JDK_API1(Err, MemHandleFree, MemHandle)					//0xA02B
_JDK_API1(UInt16, MemHandleFlags, MemHandle)				//0xA02C
_JDK_API1(UInt32, MemHandleSize, MemHandle)					//0xA02D
_JDK_API1(UInt32, MemHandleOwner, MemHandle)				//0xA02E (extend)
_JDK_API1(UInt16, MemHandleHeapID, MemHandle)				//0xA02F
_JDK_API1(Boolean, MemHandleDataStorage, MemHandle)			//0xA030
_JDK_API1(UInt16, MemHandleCardNo, MemHandle)				//0xA031
_JDK_API2(Err, MemHandleSetOwner, MemHandle, UInt32)		//0xA032 (extend)
_JDK_API2(Err, MemHandleResize, MemHandle, UInt32)			//0xA033 
_JDK_API1(Err, MemHandleResetLock, MemHandle)				//0xA034
_JDK_API1(Err, MemPtrUnlock, MemPtr)						//0xA035
_JDK_API2(MemPtr, MemLocalIDToLockedPtr, LocalID, UInt16)	//0xA036
_JDK_API1(Err, MemSetDebugMode, UInt16)						//0xA037
_JDK_API1(Err, MemHeapScramble, UInt16)						//0xA038
_JDK_API1(Err, MemHeapCheck, UInt16)						//0xA039
_JDK_API0(UInt16, MemNumCards)								//0xA03A
_JDK_API0(UInt16, MemDebugMode)								//0xA03B
_JDK_API1(Err, MemSemaphoreReserve, Boolean)				//0xA03C
_JDK_API1(Err, MemSemaphoreRelease, Boolean)				//0xA03D
_JDK_API1(Boolean, MemHeapDynamic, UInt16)					//0xA03E
_JDK_API0(Err, MemNVParams)									//0xA03F (unknown)

/*
_JDK_API0(Err, DmInit)										//0xA040
_JDK_API5(Err, DmCreateDatabase, UInt16, const Char*, UInt32,
				 UInt32, Boolean)							//0xA041
_JDK_API2(Err, DmDeleteDatabase, UInt16, LocalID)			//0xA042
_JDK_API1(UInt16, DmNumDatabases, UInt16)					//0xA043
*/
//??_JDK_API2(LocalID, DmGetDatabase, UInt16, UInt16)			//0xA044
//??_JDK_API2(LocalID, DmFindDatabase, UInt16, const Char*)		//0xA045
/*
_JDK_API13(Err,	DmDatabaseInfo, UInt16, LocalID, Char*,
					UInt16 *, UInt16 *, UInt32 *,
					UInt32 *, UInt32 *,	UInt32 *, LocalID *,
					LocalID *, UInt32 *, UInt32 *)			//0xA046
_JDK_API13(Err, DmSetDatabaseInfo, UInt16, LocalID, const Char*,
					UInt16 *, UInt16 *, UInt32 *,
					UInt32 *, UInt32 *,	UInt32 *, LocalID *,
					LocalID *, UInt32 *, UInt32 *creatorP)	//0xA047
_JDK_API5(Err, DmDatabaseSize, UInt16, LocalID, UInt32 *,
					UInt32 *, UInt32 *)						//0xA048
*/
//??_JDK_API3(DmOpenRef, DmOpenDatabase, UInt16, LocalID, UInt16)//0xA049
//??_JDK_API1(Err, DmCloseDatabase, DmOpenRef)					//0xA04A
/*
_JDK_API1(DmOpenRef, DmNextOpenDatabase, DmOpenRef)			//0xA04B
_JDK_API6(Err, DmOpenDatabaseInfo, DmOpenRef, LocalID *, 
					UInt16 *, UInt16 *, UInt16 *, Boolean *)//0xA04C
_JDK_API1(Err, DmResetRecordStates, DmOpenRef)				//0xA04D
_JDK_API0(Err, DmGetLastErr)								//0xA04E
_JDK_API1(UInt16, DmNumRecords, DmOpenRef)					//0xA04F
_JDK_API5(Err, DmRecordInfo, DmOpenRef, UInt16,	UInt16*, 	
			UInt32*, LocalID*)								//0xA050
_JDK_API4(Err, DmSetRecordInfo, DmOpenRef, UInt16, UInt16 *, 
			UInt32 *)										//0xA051
_JDK_API4(Err, DmAttachRecord, DmOpenRef, UInt16*,
					MemHandle, MemHandle*)					//0xA052
_JDK_API3(Err, DmDetachRecord, DmOpenRef, UInt16,MemHandle*)//0xA053
_JDK_API3(Err, DmMoveRecord, DmOpenRef, UInt16, UInt16)		//0xA054
_JDK_API3(MemHandle, DmNewRecord, DmOpenRef, UInt16*, UInt32)//0xA055
_JDK_API2(Err, DmRemoveRecord, DmOpenRef, UInt16)			//0xA056
_JDK_API2(Err, DmDeleteRecord, DmOpenRef, UInt16)			//0xA057
_JDK_API2(Err, DmArchiveRecord, DmOpenRef, UInt16)			//0xA058
_JDK_API2(MemHandle, DmNewHandle, DmOpenRef, UInt32)		//0xA059
_JDK_API1(Err, DmRemoveSecretRecords, DmOpenRef)			//0xA05A
_JDK_API2(MemHandle, DmQueryRecord, DmOpenRef, UInt16)		//0xA05B
_JDK_API2(MemHandle, DmGetRecord, DmOpenRef, UInt16)		//0xA05C
_JDK_API3(MemHandle, DmResizeRecord, DmOpenRef,
	UInt16, UInt32)											//0xA05D
_JDK_API3(Err, DmReleaseRecord, DmOpenRef, UInt16, Boolean)	//0xA05E
_JDK_API2(MemHandle, DmGetResource, DmResType, DmResID)		//0xA05F
_JDK_API2(MemHandle, DmGet1Resource, DmResType, DmResID)	//0xA060
_JDK_API1(Err, DmReleaseResource, MemHandle)				//0xA061
_JDK_API2(MemHandle, DmResizeResource, MemHandle, UInt32)	//0xA062
_JDK_API1(DmOpenRef, DmNextOpenResDatabase, DmOpenRef)		//0xA063
_JDK_API3(UInt16, DmFindResourceType, DmOpenRef, DmResType, 
	UInt16)													//0xA064
*/
//??_JDK_API4(UInt16, DmFindResource, DmOpenRef, DmResType, 
//??	DmResID, MemHandle)										//0xA065
/*
_JDK_API4(UInt16, DmSearchResource, DmResType, DmResID,
					MemHandle, DmOpenRef*)					//0xA066
_JDK_API1(UInt16, DmNumResources, DmOpenRef)				//0xA067
_JDK_API5(Err, DmResourceInfo, DmOpenRef, UInt16, DmResType*,
		DmResID *, LocalID *)								//0xA068
_JDK_API4(Err, DmSetResourceInfo, DmOpenRef, UInt16,
					DmResType *, DmResID *)					//0xA069
_JDK_API4(Err, DmAttachResource, DmOpenRef, MemHandle, 
					DmResType, DmResID)						//0xA06A
_JDK_API3(Err, DmDetachResource, DmOpenRef, UInt16,
					MemHandle*)								//0xA06B
_JDK_API4(MemHandle, DmNewResource, DmOpenRef, DmResType, 
				DmResID, UInt32)							//0xA06C
_JDK_API2(Err, DmRemoveResource, DmOpenRef, UInt16)			//0xA06D
_JDK_API2(MemHandle, DmGetResourceIndex, DmOpenRef, UInt16)	//0xA06E
_JDK_API3(Err, DmQuickSort, DmOpenRef, DmComparF*, Int16)	//0xA06F
_JDK_API3(MemHandle, DmQueryNextInCategory, DmOpenRef, 
	UInt16*, UInt16)										//0xA070
_JDK_API2(UInt16, DmNumRecordsInCategory, DmOpenRef, UInt16)//0xA071
_JDK_API3(UInt16, DmPositionInCategory, DmOpenRef, UInt16, 
	UInt16)													//0xA072
_JDK_API5(Err, DmSeekRecordInCategory, DmOpenRef, UInt16*, 
	UInt16,	Int16, UInt16)									//0xA073
_JDK_API4(Err, DmMoveCategory, DmOpenRef, UInt16, UInt16, 
	Boolean)												//0xA074
_JDK_API3(DmOpenRef, DmOpenDatabaseByTypeCreator, UInt32, 
			UInt32, UInt16)									//0xA075
_JDK_API4(Err, DmWrite, void*, UInt32, const void*, UInt32)	//0xA076
_JDK_API3(Err, DmStrCopy, void*, UInt32, const Char*)		//0xA077
_JDK_API7(Err, DmGetNextDatabaseByTypeCreator, Boolean, 
	DmSearchStatePtr, UInt32, UInt32, Boolean, UInt16*, 
	LocalID*)												//0xA078
_JDK_API3(Err, DmWriteCheck, void*, UInt32, UInt32)			//0xA079
_JDK_API0_V(DmMoveOpenDBContext)							//0xA07A (unknown)
_JDK_API3(Err, DmFindRecordByID, DmOpenRef, UInt32, UInt16*)//0xA07B
_JDK_API1(LocalID, DmGetAppInfoID, DmOpenRef)				//0xA07C
_JDK_API4(UInt16, DmFindSortPositionV10, DmOpenRef, void*,
					DmComparF*, Int16)						//0xA07D
_JDK_API4(Err, DmSet, void*, UInt32, UInt32, UInt8)			//0xA07E
_JDK_API1(Err, DmCreateDatabaseFromImage, MemPtr)			//0xA07F
*/


_JDK_API1(Int32, ErrSetJump, ErrJumpBuf)					//0xA085
_JDK_API2_V(ErrLongJump, ErrJumpBuf, Int32)					//0xA086
_JDK_API1_V(ErrThrow, Int32)								//0xA087
_JDK_API0(MemPtr*, ErrExceptionList)						//0xA088


_JDK_API1(Boolean, SysHandleEvent, EventType*)				//0xA0A9
_JDK_API0_V(SysInit)										//0xA0AA

_JDK_API1(Int16, SysRandom, Int32)							//0xA0C2

_JDK_API2(Char*, StrCopy, Char*, const Char*)				//0xA0C5
_JDK_API2(Char*, StrCat, Char*, const Char*)				//0xA0C6
_JDK_API1(Int16, StrLen, const Char*)						//0xA0C7
_JDK_API2(Int16, StrCompare, const Char*, const Char *)		//0xA0C8
//??_JDK_API2(Char*, StrIToA, Char*, Int32)						//0xA0C9
//??_JDK_API2(Int16, StrCaselessCompare, const Char*, const Char*)//0xA0CA
//??_JDK_API2(Char*, StrIToH, Char*, UInt32)					//0xA0CB
_JDK_API2(Char*, StrChr, const Char*, WChar)				//0xA0CC
_JDK_API2(Char*, StrStr, const Char*, const Char*)			//0xA0CD
_JDK_API1(Int32, StrAToI, const Char*)						//0xA0CE
//??_JDK_API2(Char*, StrToLower, Char*, const Char*)			//0xA0CF


_JDK_API0(UInt32, TimGetSeconds)							//0xA0F5
_JDK_API1_V(TimSetSeconds, UInt32)							//0xA0F6
_JDK_API0(UInt32, TimGetTicks)								//0xA0F7

_JDK_API2_V(TimSecondsToDateTime, UInt32, DateTimePtr)		//0xA0FC
_JDK_API1(UInt32, TimDateTimeToSeconds, DateTimePtr)		//0xA0FD
_JDK_API2_V(TimAdjust, DateTimePtr, Int32)					//0xA0FE

_JDK_API1_V(CtlDrawControl, ControlType*)					//0xA10D
_JDK_API1_V(CtlEraseControl, ControlType*)					//0xA10E
_JDK_API1_V(CtlHideControl, ControlType*)					//0xA10F
_JDK_API1_V(CtlShowControl, ControlType*)					//0xA110
_JDK_API1(Int16, CtlGetValue, const ControlType*)			//0xA111
_JDK_API2_V(CtlSetValue, ControlType*, Int16)				//0xA112
_JDK_API1(const Char*, CtlGetLabel, const ControlType*)		//0xA113
_JDK_API2_V(CtlSetLabel, ControlType*, const Char*)			//0xA114
_JDK_API2(Boolean, CtlHandleEvent, ControlType*, EventType*)//0xA115
_JDK_API1_V(CtlHitControl, const ControlType*)				//0xA116
_JDK_API2_V(CtlSetEnabled, ControlType*, Boolean)			//0xA117
_JDK_API2_V(CtlSetUsable, ControlType*, Boolean)			//0xA118
_JDK_API1(Boolean, CtlEnabled, const ControlType*)			//0xA119
_JDK_API0(Err, EvtInitialize)								//0xA11A (unknown)
_JDK_API1_V(EvtAddEventToQueue, const EventType*)			//0xA11B
_JDK_API2_V(EvtCopyEvent, const EventType*, EventType*)		//0xA11C
_JDK_API2(Boolean, EvtGetEvent, EventType*, Int32)			//0xA11D (extend)
_JDK_API3_V(EvtGetPen, Int16*, Int16*, Boolean*)			//0xA11E
_JDK_API0(Err, EvtSysInit)									//0xA11F
_JDK_API2(Boolean, EvtGetSysEvent, SysEventType*, Int32)	//0xA120 (extend)
_JDK_API2(Err,EvtProcessSoftKeyStroke,PointType*,PointType*)//0xA121
_JDK_API1(const PenBtnInfoType*, EvtGetPenBtnList, UInt16*)	//0xA122
_JDK_API2(Err, EvtSetPenQueuePtr, MemPtr,UInt32)			//0xA123
_JDK_API0(UInt32, EvtPenQueueSize)							//0xA124
_JDK_API0(Err, EvtFlushPenQueue)							//0xA125
_JDK_API1(Err, EvtEnqueuePenPoint, PointType*)				//0xA126
_JDK_API2(Err,EvtDequeuePenStrokeInfo,PointType*,PointType*)//0xA127
_JDK_API1(Err, EvtDequeuePenPoint, PointType*)				//0xA128
_JDK_API0(Err, EvtFlushNextPenStroke)						//0xA129
_JDK_API2(Err, EvtSetKeyQueuePtr, MemPtr,UInt32)			//0xA12A
_JDK_API0(UInt32, EvtKeyQueueSize)							//0xA12B
_JDK_API0(Err, EvtFlushKeyQueue)							//0xA12C
_JDK_API3(Err, EvtEnqueueKey, WChar, UInt16, UInt16)		//0xA12D
_JDK_API2(Err, EvtDequeueKeyEvent, SysEventType*, UInt16)	//0xA12E
_JDK_API0(Err, EvtWakeup)									//0xA12F
_JDK_API0(Err, EvtResetAutoOffTimer)						//0xA130
_JDK_API0(Boolean, EvtKeyQueueEmpty)						//0xA131
_JDK_API1_V(EvtEnableGraffiti, Boolean)						//0xA132


_JDK_API0(FontID, FntGetFont)								//0xA163
_JDK_API1(FontID, FntSetFont, FontID)						//0xA164
_JDK_API0(FontPtr, FntGetFontPtr)							//0xA165
_JDK_API0(Int16, FntBaseLine)								//0xA166
_JDK_API0(Int16, FntCharHeight)								//0xA167
_JDK_API0(Int16, FntLineHeight)								//0xA168
_JDK_API0(Int16, FntAverageCharWidth)						//0xA169
_JDK_API1(Int16, FntCharWidth, Char)						//0xA16A
_JDK_API2(Int16, FntCharsWidth, Char const*, Int16)			//0xA16B
_JDK_API0(Int16, FntDescenderHeight)						//0xA16C
_JDK_API4_V(FntCharsInWidth, Char const*, Int16*, Int16*,
	Boolean*)												//0xA16D
_JDK_API2(Int16, FntLineWidth, Char const*, UInt16)			//0xA16E


_JDK_API1(FormType*, FrmInitForm, UInt16)					//0xA16F
_JDK_API1_V(FrmDeleteForm, FormType*)						//0xA170
_JDK_API1_V(FrmDrawForm, FormType*)							//0xA171
_JDK_API1_V(FrmEraseForm, FormType*)						//0xA172
_JDK_API0(FormType*, FrmGetActiveForm)						//0xA173
_JDK_API1_V(FrmSetActiveForm, FormType*)					//0xA174
_JDK_API0(UInt16, FrmGetActiveFormID)						//0xA175
_JDK_API1(Boolean, FrmGetUserModifiedState, const FormType*)//0xA176
_JDK_API1_V(FrmSetNotUserModified, FormType*)				//0xA177
_JDK_API1(UInt16, FrmGetFocus, const FormType*)				//0xA178
_JDK_API2_V(FrmSetFocus, FormType*, UInt16)					//0xA179
_JDK_API2(Boolean, FrmHandleEvent, FormType*, EventType*)	//0xA17A
_JDK_API2_V(FrmGetFormBounds, const FormType*,				//0xA17B
	RectangleType*)
_JDK_API1(WinHandle, FrmGetWindowHandle, const FormType*)	//0xA17C
_JDK_API1(UInt16, FrmGetFormId, const FormType*)			//0xA17D
_JDK_API1(FormType*, FrmGetFormPtr, UInt16)					//0xA17E
_JDK_API1(UInt16, FrmGetNumberOfObjects, const FormType*)	//0xA17F
_JDK_API2(UInt16, FrmGetObjectIndex,const FormType*,UInt16)	//0xA180
_JDK_API2(UInt16, FrmGetObjectId, const FormType*, UInt16)	//0xA181
_JDK_API2(FormObjectKind, FrmGetObjectType,					//0xA182
	const FormType*, UInt16)
_JDK_API2(void*, FrmGetObjectPtr, const FormType*, UInt16)	//0xA183
_JDK_API2_V(FrmHideObject, FormType*, UInt16)				//0xA184
_JDK_API2_V(FrmShowObject, FormType*, UInt16)				//0xA185
_JDK_API4_V(FrmGetObjectPosition, const FormType*, UInt16,	//0xA186
	Coord*, Coord*)
_JDK_API4_V(FrmSetObjectPosition, FormType*, UInt16,		//0xA187
	Coord, Coord)
_JDK_API2(Int16, FrmGetControlValue,const FormType*,UInt16)	//0xA188
_JDK_API3_V(FrmSetControlValue, const FormType*, UInt16,	//0xA189
	Int16)
_JDK_API2(UInt16, FrmGetControlGroupSelection,				//0xA18A
	const FormType*, UInt8)
_JDK_API3_V(FrmSetControlGroupSelection, const FormType*,	//0xA18B
	UInt8, UInt16)
_JDK_API3_V(FrmCopyLabel, FormType*, UInt16, const Char*)	//0xA18C
_JDK_API3_V(FrmSetLabel, FormType*, UInt16, const Char*)	//0xA18D (unknow)
_JDK_API2(const Char*, FrmGetLabel,const FormType*,UInt16)	//0xA18E
//_JDK_API2_V(FrmSetCategoryLabel, const FormType*, UInt16,	//0xA18F
//	Char*)
_JDK_API1(const Char*, FrmGetTitle, const FormType*)		//0xA190
_JDK_API2_V(FrmSetTitle, FormType*, Char*)					//0xA191
_JDK_API1(UInt16, FrmAlert, UInt16)							//0xA192
_JDK_API1(UInt16, FrmDoDialog, FormType*)					//0xA193
_JDK_API4(UInt16, FrmCustomAlert, UInt16, const Char*,		//0xA194
	const Char*, const Char*)
_JDK_API1_V(FrmHelp, UInt16)								//0xA195

_JDK_API0(FormType*, FrmGetFirstForm)						//0xA197
_JDK_API1(Boolean, FrmVisible, const FormType*)				//0xA198
_JDK_API3_V(FrmGetObjectBounds, const FormType*, UInt16,	//0xA199
	RectangleType*)
_JDK_API2_V(FrmCopyTitle, FormType*, const Char*)			//0xA19A
_JDK_API1_V(FrmGotoForm, UInt16)							//0xA19B
_JDK_API1_V(FrmPopupForm, UInt16)							//0xA19C
_JDK_API2_V(FrmUpdateForm, UInt16, UInt16)					//0xA19D
_JDK_API1_V(FrmReturnToForm,  UInt16)						//0xA19E
_JDK_API2_V(FrmSetEventHandler, FormType*,					//0xA19F
	FormEventHandlerType*)
_JDK_API1(Boolean, FrmDispatchEvent, EventType*)			//0xA1A0
_JDK_API0_V(FrmCloseAllForms)								//0xA1A1
_JDK_API0_V(FrmSaveAllForms)								//0xA1A2

_JDK_API0_V(UIInitialize)									//0xA1A6
_JDK_API0_V(UIReset)										//0xA1A7

_JDK_API1(MenuBarType*, MenuInit, UInt16)					//0xA1BD
_JDK_API1_V(MenuDispose, MenuBarType*)						//0xA1BE
_JDK_API3(Boolean, MenuHandleEvent, MenuBarType*,			//0xA1BF
	EventType*, UInt16*)
_JDK_API1_V(MenuDrawMenu, MenuBarType*)						//0xA1C0

_JDK_API1_V(MenuEraseStatus, MenuBarType*)					//0xA1C1
_JDK_API0(MenuBarType*, MenuGetActiveMenu)					//0xA1C2
_JDK_API1(MenuBarType*, MenuSetActiveMenu, MenuBarType*)	//0xA1C3

_JDK_API5_V(RctSetRectangle, RectangleType*, Coord, 		//0xA1C4
	Coord, Coord, Coord)
_JDK_API2_V(RctCopyRectangle, const RectangleType*, 		//0xA1C5
	RectangleType*)
_JDK_API2_V(RctInsetRectangle, RectangleType*, Coord)		//0xA1C6
_JDK_API3_V(RctOffsetRectangle, RectangleType*,Coord,Coord)	//0xA1C7
_JDK_API3(Boolean, RctPtInRectangle, Coord, Coord, 			//0xA1C8
	const RectangleType*)
_JDK_API3(Boolean, RctGetIntersection, const RectangleType*,//0xA1C9 (extend)
	const RectangleType*, RectangleType*)

_JDK_API5(WinHandle, WinCreateWindow, const RectangleType*,	//0xA1F6
	FrameType, Boolean, Boolean, UInt16*)
_JDK_API4(WinHandle, WinCreateOffscreenWindow, Coord, Coord,//0xA1F7
	WindowFormatType, UInt16*)
_JDK_API2_V(WinDeleteWindow, WinHandle, Boolean)			//0xA1F8
_JDK_API1_V(WinInitializeWindow, WinHandle)					//0xA1F9
_JDK_API1_V(WinAddWindow, WinHandle)						//0xA1FA
_JDK_API1_V(WinRemoveWindow, WinHandle)						//0xA1FB
_JDK_API1_V(WinSetActiveWindow, WinHandle)					//0xA1FC
_JDK_API1(WinHandle, WinSetDrawWindow, WinHandle)			//0xA1FD
_JDK_API0(WinHandle, WinGetDrawWindow)						//0xA1FE
_JDK_API0(WinHandle, WinGetActiveWindow)					//0xA1FF
_JDK_API0(WinHandle, WinGetDisplayWindow)					//0xA200
_JDK_API0(WinHandle, WinGetFirstWindow)						//0xA201
_JDK_API1_V(WinEnableWindow, WinHandle)						//0xA202
_JDK_API1_V(WinDisableWindow, WinHandle)					//0xA203
_JDK_API2_V(WinGetWindowFrameRect, WinHandle, 				//0xA204
	RectangleType*)
_JDK_API0_V(WinDrawWindowFrame)								//0xA205
_JDK_API0_V(WinEraseWindow)									//0xA206
_JDK_API2(WinHandle, WinSaveBits, const RectangleType*,		//0xA207
	 UInt16 *)
_JDK_API3_V(WinRestoreBits, WinHandle, Coord, Coord)		//0xA208
_JDK_API6_V(WinCopyRectangle, WinHandle, WinHandle, 		//0xA209
	const RectangleType*, Coord, Coord, WinDrawOperation)
_JDK_API4_V(WinScrollRectangle, const RectangleType*, 		//0xA20A
	WinDirectionType, Coord, RectangleType*)
_JDK_API2_V(WinGetDisplayExtent, Coord*, Coord*)			//0xA20B
_JDK_API2_V(WinGetWindowExtent, Coord*, Coord*)				//0xA20C
_JDK_API2_V(WinDisplayToWindowPt, Coord*, Coord*)			//0xA20D
_JDK_API2_V(WinWindowToDisplayPt, Coord*, Coord*)			//0xA20E
_JDK_API1_V(WinGetClip, RectangleType*)						//0xA20F
_JDK_API1_V(WinSetClip, const RectangleType*)				//0xA210
_JDK_API0_V(WinResetClip)									//0xA211
_JDK_API1_V(WinClipRectangle, RectangleType*)				//0xA212
_JDK_API4_V(WinDrawLine, Coord, Coord, Coord, Coord)		//0xA213
_JDK_API4_V(WinDrawGrayLine, Coord, Coord, Coord, Coord)	//0xA214
_JDK_API4_V(WinEraseLine, Coord, Coord, Coord, Coord)		//0xA215
_JDK_API4_V(WinInvertLine, Coord, Coord, Coord, Coord)		//0xA216
_JDK_API4_V(WinFillLine, Coord, Coord, Coord, Coord)		//0xA217
_JDK_API2_V(WinDrawRectangle, const RectangleType*, UInt16)	//0xA218
_JDK_API2_V(WinEraseRectangle, const RectangleType*, UInt16)//0xA219
_JDK_API2_V(WinInvertRectangle, const RectangleType*, UInt16)//0xA21A
_JDK_API2_V(WinDrawRectangleFrame, FrameType, 
	const RectangleType*)									//0xA21B
_JDK_API2_V(WinDrawGrayRectangleFrame, FrameType, 
	const RectangleType*)									//0xA21C
_JDK_API2_V(WinEraseRectangleFrame, FrameType, 
	const RectangleType*)									//0xA21D
_JDK_API2_V(WinInvertRectangleFrame, FrameType,
	const RectangleType*)									//0xA21E
_JDK_API3_V(WinGetFramesRectangle, FrameType,
	const RectangleType*, RectangleType*)					//0xA21F
_JDK_API4_V(WinDrawChars, const Char*, Int16, Coord, Coord)	//0xA220
_JDK_API4_V(WinEraseChars, const Char*, Int16, Coord, Coord)//0xA221
_JDK_API4_V(WinInvertChars, const Char*, Int16, Coord, Coord)//0xA222
_JDK_API1_V(WinGetPattern, CustomPatternType*)				//0xA223
_JDK_API1_V(WinSetPattern, const CustomPatternType*)		//0xA224
_JDK_API1(UnderlineModeType, WinSetUnderlineMode,
	UnderlineModeType)										//0xA225
//??_JDK_API3_V(WinDrawBitmap, BitmapPtr, Coord, Coord)			//0xA226
_JDK_API1(Boolean, WinModal, WinHandle)						//0xA227
_JDK_API1_V(WinGetWindowBounds, RectangleType*)				//0xA228
_JDK_API2_V(WinFillRectangle, const RectangleType*, UInt16)	//0xA229
_JDK_API4_V(WinDrawInvertedChars, const Char*, Int16, Coord,
	 Coord)													//0xA22A


_JDK_API3(Int16, DayOfWeek, Int16, Int16, Int16)			//0xA25F
_JDK_API2(Int16, DaysInMonth, Int16, Int16)					//0xA260
_JDK_API3(Int16, DayOfMonth, Int16, Int16, Int16)			//0xA261
_JDK_API2_V(DateDaysToDate, UInt32, DatePtr)				//0xA262
_JDK_API1(UInt32, DateToDays, DateType)						//0xA263
_JDK_API2_V(DateAdjust, DatePtr, Int32)						//0xA264
_JDK_API2_V(DateSecondsToDate, UInt32, DatePtr)				//0xA265

_JDK_API0(Err, KeyInit)										//0xA2A0 (unknown)
_JDK_API0(Err, KeyHandleInterrupt)							//0xA2A1 (unknown)
_JDK_API0(UInt32, KeyCurrentState)							//0xA2A2
_JDK_API0(Err, KeyResetDoubleTap)							//0xA2A3 (unknown)
_JDK_API5(Err, KeyRates, Boolean, UInt16*, UInt16*,			//0xA2A4
	UInt16*, Boolean*)
_JDK_API0(Err, KeySleep)									//0xA2A5 (unknown)
_JDK_API0(Err, KeyWake)										//0xA2A6 (unknown)

//_JDK_API2(UInt16, DmSearchRecord, MemHandle, DmOpenRef*)	//0xA2B2
//_JDK_API3(Err, DmInsertionSort, DmOpenRef, DmComparF*, Int16)//0xA2B4
//_JDK_API2(Err, DmDeleteCategory, DmOpenRef, UInt16)			//0xA2C7
							

_JDK_API0(Boolean, EvtEventAvail)							//0xA2CC
_JDK_API1(Boolean, EvtSysEventAvail, Boolean)				//0xA2CD
_JDK_API1(UInt32, KeySetMask, UInt32)						//0xA2CF

_JDK_API3(Boolean, FrmPointInTitle, const FormType*,		//0xA2D5
	Coord, Coord)

_JDK_API3(Int16, MemCmp, const void*, const void*, Int32)	//0xA2D7

//_JDK_API3(Err, DmDatabaseProtect, UInt16, LocalID, Boolean)	//0xA2EB

_JDK_API2_V(FrmSetMenu, FormType*, UInt16)					//0xA2F0

//_JDK_API5(UInt16, DmFindSortPosition, DmOpenRef, void*,
//					SortRecordInfoPtr, DmComparF*, Int16)	//0xA2F2

_JDK_API3_V(EvtAddUniqueEventToQueue,						//0xA2F6
	const EventType*, UInt32, Boolean)

_JDK_API1_V(MenuSetActiveMenuRscID, UInt16)					//0xA2FA

//_JDK_API2_V(WinSetWindowBounds, WinHandle,				//0xA300
//	const RectangleType*)

_JDK_API3_V(FrmSetObjectBounds, FormType*, UInt16,			//0xA303
	const RectangleType*)
//_JDK_API5_V(WinSetColors, const RGBColorType*, RGBColorType*,
//	const RGBColorType*, RGBColorType*)						//0xA304

//_JDK_API1(Boolean, WinValidateHandle, WinHandle)			//0xA326

_JDK_API1(Boolean, FrmValidatePtr, const FormType*)			//0xA327
_JDK_API1(Boolean, CtlValidatePointer, const ControlType*)	//0xA328

//_JDK_API2_V(WinMoveWindowAddr, WindowType*, WindowType*)	//0xA329

_JDK_API10(FormType*, FrmNewForm, UInt16, const Char*, 		//0xA32B
	Coord, Coord, Coord, Coord, Boolean, UInt16, UInt16, UInt16)
_JDK_API11(ControlType*, CtlNewControl, FormType**, UInt16,	//0xA32C
 	ControlStyleType, const Char*, Coord, Coord, Coord, Coord, 
	FontID, UInt8, Boolean)

_JDK_API6(FormLabelType*, FrmNewLabel, FormType**,			//0xA32F
	UInt16, const Char*, Coord, Coord, FontID)

_JDK_API2(Err, FrmActiveState, FormActiveStateType*,Boolean)//0xA33B

_JDK_API2(Err, FrmRemoveObject, FormType**, UInt16)			//0xA345
_JDK_API0(Err, SysReserved1)								//0xA346
_JDK_API0(Err, SysReserved2)								//0xA347
_JDK_API0(Err, SysReserved3)								//0xA348
_JDK_API0(Err, OEMDispatch)									//0xA349

//_JDK_API3_V(WinDrawChar, WChar, Coord, Coord)				//0xA350
//_JDK_API5_V(WinDrawTruncChars, const Char*, Int16, Coord, 
//	Coord, Coord)											//0xA351
//_JDK_API4_V(DmGetDatabaseLockState, DmOpenRef, UInt8*, 
//	UInt32 *, UInt32 *)										//0xA369

_JDK_API1(Boolean, MemPtrDataStorage, MemPtr)				//0xA36F

_JDK_API1(void*, BmpGetBits, BitmapType*)					//0xA376


_JDK_API3_V(WinPaintChar, WChar, Coord, Coord)				//0xA37E
_JDK_API4_V(WinPaintChars, const Char*, Int16, Coord, Coord)//0xA37F
_JDK_API3_V(WinPaintBitmap, BitmapType*, Coord, Coord)		//0xA380
_JDK_API2(IndexedColorType, WinGetPixel, Coord, Coord)		//0xA381
_JDK_API2_V(WinPaintPixel, Coord, Coord)					//0xA382
_JDK_API2_V(WinDrawPixel, Coord, Coord)						//0xA383
_JDK_API2_V(WinErasePixel, Coord, Coord)					//0xA384
_JDK_API2_V(WinInvertPixel, Coord, Coord)					//0xA385
_JDK_API2_V(WinPaintPixels, UInt16, PointType*)				//0xA386
_JDK_API2_V(WinPaintLines, UInt16, WinLineType*)			//0xA387
_JDK_API4_V(WinPaintLine, Coord, Coord, Coord, Coord)		//0xA388
_JDK_API2_V(WinPaintRectangle, const RectangleType*, UInt16)//0xA389
_JDK_API2_V(WinPaintRectangleFrame, FrameType, 
	const RectangleType*)									//0xA38A
/*
_JDK_API0_V(WinPaintPolygon)								//0xA38B
_JDK_API0_V(WinDrawPolygon)									//0xA38C
_JDK_API0_V(WinErasePolygon)								//0xA38D
_JDK_API0_V(WinInvertPolygon)								//0xA38E
_JDK_API0_V(WinFillPolygon)									//0xA38F
_JDK_API0_V(WinPaintArc)									//0xA390
_JDK_API0_V(WinDrawArc)										//0xA391
_JDK_API0_V(WinEraseArc)									//0xA392
_JDK_API0_V(WinInvertArc)									//0xA393
_JDK_API0_V(WinFillArc)										//0xA394
*/
_JDK_API0_V(WinPushDrawState)								//0xA395
_JDK_API0_V(WinPopDrawState)								//0xA396
_JDK_API1(WinDrawOperation, WinSetDrawMode, WinDrawOperation)//0xA397
_JDK_API1(IndexedColorType, WinSetForeColor, IndexedColorType)//0xA398
_JDK_API1(IndexedColorType, WinSetBackColor, IndexedColorType)//0xA399
_JDK_API1(IndexedColorType, WinSetTextColor, IndexedColorType)//0xA39A
_JDK_API0(PatternType, WinGetPatternType)					//0xA39B
_JDK_API1_V(WinSetPatternType, PatternType)					//0xA39C
//??_JDK_API4(Err, WinPalette, UInt8, Int16, UInt16, RGBColorType*)//0xA39D
_JDK_API1(IndexedColorType, WinRGBToIndex, const RGBColorType*)//0xA39E
_JDK_API2_V(WinIndexToRGB, IndexedColorType, RGBColorType*)	//0xA39F
//??_JDK_API1(UInt8*, WinScreenLock, WinLockInitType)			//0xA3A0
//??_JDK_API0_V(WinScreenUnlock)								//0xA3A1
_JDK_API1(BitmapType*, WinGetBitmap, WinHandle)				//0xA3A2


//_JDK_API3(DmOpenRef, DmOpenDBNoOverlay, UInt16, LocalID, 
//		UInt16)												//0xA3B0

_JDK_API0(Err, KeyBootKeys)									//0xA3B6 (unknown)

_JDK_API0(Err, MenuEraseMenu)								//0xA3C5 (unknown)

_JDK_API5(Err, MenuCmdBarAddButton, UInt16, UInt16,			//0xA3C7
	MenuCmdBarResultType, UInt32, Char*)
_JDK_API5(Boolean, MenuCmdBarGetButtonData, Int16, UInt16*,	//0xA3C8
	MenuCmdBarResultType*, UInt32*, Char*)
_JDK_API0_V(MenuCmdBarDisplay)								//0xA3C9

_JDK_API1(Boolean, MenuShowItem, UInt16)					//0xA3D5
_JDK_API1(Boolean, MenuHideItem, UInt16)					//0xA3D6
_JDK_API4(Err, MenuAddItem,UInt16,UInt16,Char,const Char*)	//0xA3D7

_JDK_API5(BitmapType*, BmpCreate, Coord, Coord,	UInt8,		//0xA3DD
	ColorTableType *, UInt16*)
_JDK_API1(Err, BmpDelete, BitmapType*)						//0xA3DE
_JDK_API2(Err, BmpCompress,	BitmapType *, 					//0xA3DF
	BitmapCompressionType)
_JDK_API1(ColorTableType*, BmpGetColortable, BitmapType*)	//0xA3E0
_JDK_API1(UInt32, BmpSize, BitmapType*)						//0xA3E1 (extend)
_JDK_API1(UInt32, BmpBitsSize, BitmapType*)					//0xA3E2 (extend)
_JDK_API1(UInt32, BmpColortableSize, BitmapType*)			//0xA3E3 (extend)

_JDK_API2(WinHandle, WinCreateBitmapWindow, BitmapType*, 	//0xA3E4
	UInt16*)

_JDK_API0(Err, SysUICleanup)								//0xA3E7 (unknown)
#undef _JDK_PRIME_
#endif //_JDK_PRIME_

//////////////////////////////////////////////////////////////////////
//Jedi Extenstions
#ifdef _JDK_EXT_
_JDK_API2(Err, MenuAddPullDown,	UInt16, const Char*)		//0x0001
_JDK_API3(ThreadID, MtCreateThread, ThreadProcPtr, MemPtr,	//0x0002
	UInt32)
_JDK_API0_V(MtExitThread)									//0x0003
_JDK_API1(Boolean, MtKillThread, ThreadID)					//0x0004
_JDK_API0(ThreadID, MtGetCurrentThread)						//0x0005
_JDK_API0_V(MtYield)										//0x0006
_JDK_API1_V(MtSleep, UInt32)								//0x0007
_JDK_API0_V(MtExitProcess)									//0x0008
_JDK_API0(ProcessID, MtGetCurrentProcess)					//0x0009
_JDK_API2(Boolean, MtWaitThread, ThreadID, UInt32)			//0x000A
_JDK_API2(Boolean, MtSetPriority, ThreadID, Int32)			//0x000B
_JDK_API1(Int32, MtGetPriority, ThreadID)					//0x000C
_JDK_API1(Boolean, MtThreadActive, ThreadID)				//0x000D
_JDK_API0(MutexHandle, MtCreateMutex)						//0x00
_JDK_API1_V(MtDestroyMutex, MutexHandle)					//0x00
_JDK_API1_V(MtLockMutex, MutexHandle)						//0x00
_JDK_API1_V(MtUnlockMutex, MutexHandle)						//0x00
_JDK_API2(CondHandle, MtCreateCond, MutexHandle, Boolean)	//0x00
_JDK_API1_V(MtDestroyCond, CondHandle)						//0x00
_JDK_API1_V(MtSetCond, CondHandle)							//0x00
_JDK_API2(Boolean, MtWaitCond, CondHandle, UInt32)			//0x00
#undef _JDK_EXT_
#endif //_JDK_EXT_

#undef _JDK_API0
#undef _JDK_API1
#undef _JDK_API2
#undef _JDK_API3
#undef _JDK_API4
#undef _JDK_API5
#undef _JDK_API6
#undef _JDK_API7
#undef _JDK_API8
#undef _JDK_API9
#undef _JDK_API10
#undef _JDK_API11
#undef _JDK_API12
#undef _JDK_API13

#undef _JDK_API0_V
#undef _JDK_API1_V
#undef _JDK_API2_V
#undef _JDK_API3_V
#undef _JDK_API4_V
#undef _JDK_API5_V
#undef _JDK_API6_V
#undef _JDK_API7_V
#undef _JDK_API8_V
#undef _JDK_API9_V
#undef _JDK_API10_V
#undef _JDK_API11_V
#undef _JDK_API12_V
#undef _JDK_API13_V
