/*	win.cxx

{{IS_NOTE

	Authors:	Henri Chen, Tom M. Yeh
	Contributors:
	Create Date:	2000/7/21 02:42PM
	$Header: /cvsroot/jedi/gdi/win.cxx,v 1.18 2000/10/11 07:48:57 henrichen Exp $
	Purpose:	
	Description:	Implementation of Jedi's winXXX()

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/event.h>
#include <jedi/rct.h>
#include <jedi/fb.h>
#include <jedi/bmp.h>
#include <jedi/fnt.h>
#include <jedi/win.h>
#include <jedi/gdi.h>
#include <lib/lcllink.h>

//////////////////////////////////////////////////////////////////
TWin g_winScrn, *g_pWinList=0, *g_pWinActive=0, *g_pWinActivePrev=0;

//////////////////////////////////////////////////////////////////
EXTERN_C TWin* _AAPI winGetDrawWindow(void)
{
	TThdLocal* thd = GetThdLocal();
	return thd->pWinDraw ? thd->pWinDraw: &g_winScrn;
}

EXTERN_C TWin* _AAPI winSetDrawWindow(TWin* pWin)
{
	TThdLocal* thd = GetThdLocal();
	TWin* old = thd->pWinDraw;
	thd->pWinDraw = pWin;
	return old;
}

EXTERN_C void _AAPI winSetActive(TWin* pWin)
{
	if(pWin != g_pWinActive){
		if(!g_pWinActivePrev || g_winEnterExitState!=NOTIFY_WINACTIVECHANGED)
			g_pWinActivePrev = g_pWinActive;
				//DO NOT update prev if EVT_WINEXIT is NOT sent
				//It is important since winSetActive might be called several
				//times before the 'real' active one is set

		g_pWinActive = pWin;
		g_winEnterExitState = NOTIFY_WINACTIVECHANGED;
			//Note: we don't send message here but set flags
			//Refer to Palm manual.
	}
}

//////////////////////////////////////////////////////////
EXTERN_C void _AAPI winGetClip(TRect *pRect)
{
	if(pRect)
		CopyRect(pRect, &(winGetDrawWindow()->clippingBounds));
}

static void _JAPI CorrectClip(TWin* pWin)
{
	if(pWin->clippingBounds.left < 0)
		pWin->clippingBounds.left = 0;

	if(pWin->clippingBounds.top < 0)
		pWin->clippingBounds.top = 0;

	__s16 v = pWin->pBitmap->width;
	if(pWin->bounds.Right() <= v) //right is inside
		v = pWin->bounds.Width();
	else
		v = (__s16)(v - pWin->bounds.Left());
	if(pWin->clippingBounds.right >= v)
		pWin->clippingBounds.right = (__s16)(v-1);

	v = pWin->pBitmap->height;
	if(pWin->bounds.Bottom() <= v) //right is inside
		v = pWin->bounds.Height();
	else
		v = (__s16)(v - pWin->bounds.Top());
	if(pWin->clippingBounds.bottom >= v)
		pWin->clippingBounds.bottom = (__s16)(v-1);
}

EXTERN_C void _AAPI winSetClip(const TRect *pRect)
{
	if(pRect){
		TWin* pWin = winGetDrawWindow();
		CopyRect(&pWin->clippingBounds, pRect);
		CorrectClip(pWin);
	}
}

EXTERN_C void _AAPI winResetClip(void)
{
	TWin* pWin = winGetDrawWindow();
	pWin->clippingBounds.left   = pWin->clippingBounds.top = 0;
	pWin->clippingBounds.right  = (__s16)(pWin->pBitmap->width-1);
	pWin->clippingBounds.bottom = (__s16)(pWin->pBitmap->height-1);
	CorrectClip(pWin);
}

EXTERN_C void _AAPI winClipRect(TRect *pRect)
{
	if(pRect){
		TRect rect;
		winGetClip(&rect);
		rctIntersect(&rect, pRect, pRect);
	}
}

EXTERN_C void _AAPI winSetBounds(TWin *pWin, const TRect *pRect)
{
	if(pWin && pRect){
		pWin->bounds = *pRect;
		CorrectClip(pWin);
	}
}

EXTERN_C void _AAPI winGetBounds(TRect *pRect)
{
	if(pRect)
		*pRect = winGetDrawWindow()->bounds;
}

//////////////////////////////////////////////////////////////////
EXTERN_C void _AAPI winGetFrameRect(__u16 frame, const TRect *pInterior, TRect *pFrame)
{
	__s16 width			= ((TFrameBits&)frame).width;
	__s16 shadowWidth	= ((TFrameBits&)frame).shadowWidth;
	pFrame->Left()	= (__s16)(pInterior->Left() - width);
	pFrame->Top()	= (__s16)(pInterior->Top() - width);
	pFrame->Width()	= (__s16)(pInterior->Width() + (width<<1) + shadowWidth);
	pFrame->Height()= (__s16)(pInterior->Height() + (width<<1) + shadowWidth);
}

EXTERN_C void _JAPI WinToScreen(const TWin *pWin, __s16 *x, __s16 *y)
{
	*x= (__s16)(*x + pWin->bounds.Left());
	*y= (__s16)(*y + pWin->bounds.Top());
}

EXTERN_C void _JAPI ScreenToWin(const TWin *pWin, __s16 *x, __s16 *y)
{
	*x= (__s16)(*x - pWin->bounds.Left());
	*y= (__s16)(*y - pWin->bounds.Top());
}

//////////////////////////////////////////////////////////
DECL_THDLINK(TDrawStateEx, TDrawState, pDrawStateExList)

static void _STDCALL InitDrawState(TDrawState* pds)
{
	memset(pds, 0, sizeof(TDrawState));
	pds->foreColor	= (__u8)((1 << SCREEN_BPP)-1);
	pds->textColor	= pds->foreColor;
	pds->fontId		= FONT_STD;
	pds->pFont		= g_pSysFonts[FONT_STD];
}

EXTERN_C void _AAPI winPushDrawState(void)
{
	TDrawStateEx* pdsEx = _MALLOC_T(TDrawStateEx);
	if(!pdsEx) return;

	InitDrawState(ToTDrawState(pdsEx));
	pdsEx->Link();
}

static void DestroyDrawState(TDrawState* pds, TThdLocal* thd=0)
{
	TDrawStateEx* pdsEx = ToTDrawStateEx(pds);
	pdsEx->Unlink(thd);
	_FREE(pdsEx);
}

EXTERN_C void _AAPI winPopDrawState(void)
{
	TThdLocal* thd = GetThdLocal();
	if(thd->pDrawStateExList){
		TDrawStateEx *pdsEx = (TDrawStateEx*)thd->pDrawStateExList;
		if(pdsEx->Next()) //the last node won't be popped
			DestroyDrawState(ToTDrawState(pdsEx));
	}
}

EXTERN_C TDrawState* _JAPI winGetDrawState(void)
{
	TThdLocal* thd = GetThdLocal();
	if(!thd->pDrawStateExList)
		winPushDrawState();
	return ToTDrawState((TDrawStateEx*)thd->pDrawStateExList);
}

//////////////////////////////////////////////////////////
static TDrawState s_winDrawState; //used for _pDrawState_ of all TWin objects

EXTERN_C void _JAPI winBindAndInit(TWin* pWin, TBmp* pBmp, const TRect* pBounds)
{
	ASSERT(pWin && pBmp);

	pWin->displayWidthV20	= pBmp->width;
	pWin->displayHeightV20	= pBmp->height;
	//pWin->displayAddrV20	= mmGetUnsafePtr(*bmpGetMemHandleAddr(pBmp));
	pWin->owner				= mtGetCurrentProcess();
	pWin->flags.SetZeros();
	pWin->pBitmap			= pBmp;
	pWin->frameType			= WINFRAME_NO;

	TRect bounds;
	if(!pBounds){
		bounds.Left()	= bounds.Top() = 0;
		bounds.Width()	= pBmp->width;
		bounds.Height()	= pBmp->height;
		pBounds = &bounds;
	}
	pWin->bounds				= *pBounds;
	pWin->clippingBounds.left	= 0;
	pWin->clippingBounds.top	= 0;
	pWin->clippingBounds.right	= (__s16)(pBounds->extent.x - 1);
	pWin->clippingBounds.bottom	= (__s16)(pBounds->extent.y - 1);
		//NOTE: unlike MS Windows, right/bottom edges are visible

	pWin->next			= g_pWinList;
	g_pWinList			= pWin;

	pWin->_pDrawState_	= &s_winDrawState;
}

EXTERN_C TWin* _AAPI winCreate(
TRect* bounds, __s16 frameType, bool bModal, bool bFocusable, __u16* err)
{
	TWin* pWin = _MALLOC_T(TWin);
	if(!pWin){
		if(err) *err = ERRS_NOFREERESOURCE;
		return 0;
	}

	winBindAndInit(pWin, g_pBmpScrn, bounds);
	pWin->frameType			= frameType;
	pWin->flags.modal		= bModal;
	pWin->flags.focusable	= bFocusable;

	if(err) *err = 0;
	return pWin;
}

EXTERN_C TWin* _AAPI winCreateOffscreen(TBmp* pBmp, _err_t* err)
{
	TWin* pWin= _MALLOC_T(TWin);
	if(!pWin){
		if(err) *err = ERRS_NOFREERESOURCE;
		return 0;
	}

	winBindAndInit(pWin, pBmp);
	pWin->flags.offscreen	= 1;
	
	if(err) *err = 0;
	return pWin;
}

EXTERN_C TWin* _AAPI winCreateOffscreenEx(
	__s16 width, __s16 height, __s16 /*bGenericFormat*/, _err_t* err)
{
	TWin* pWin= _MALLOC_T(TWin);
	if(!pWin){
		if(err) *err = ERRS_NOFREERESOURCE;
		return 0;
	}

	TBmp* pBmp = bmpCreate(width, height, (__u8) SCREEN_BPP, 0, err);
	if(!pBmp){
		_FREE(pWin);
		return 0;
	}

	winBindAndInit(pWin, pBmp);
	pWin->flags.freeBitmap	= 1;
	pWin->flags.offscreen	= 1;

	//pWin->flags.format = bGenericFormat!=0;
	//bGenericFormat is ignored; only one format is supported

	if(err) *err = 0;
	return pWin;
}

EXTERN_C void _AAPI winCopyRect(
	TWin* pSrc, TWin* pDst, const TRect* pRect,
	__s16 dstX, __s16 dstY, __s16 mode)
{
	TDrawState ds;
	ds.transferMode= mode;
	gdiBitBlt(pDst, dstX, dstY, pSrc, pRect, &ds);
}

EXTERN_C void _JAPI winDrawFrame(__u16 frameType, const TRect *pRect, TDrawState *pDs)
{
	TWin *pWin= winGetDrawWindow();
	TRect r;
	winGetFrameRect(frameType, pRect, &r);
	WinToScreen(pWin, &r.Left(), &r.Top());

	switch(frameType) {
		case WINFRAME_NO:		//0x0000
			break;
			
		case WINFRAME_SIMPLE: 	//0x0001, corner:0, shadow width:0, width: 1
//		case rectangleFrame:	//samething as simpleFrame
			gdiOutlineRect(pWin, &r, 0, pDs);
			break;
			
		case WINFRAME_3D:	//0x0012, corner: 0, 3d:on, width:2
			//?? 20000525, Henri Chen: not supported yet. draw an bold frame
			gdiOutlineRect(pWin, &r, 0, pDs);
			rctInset(&r, 1);
			gdiOutlineRect(pWin, &r, 0, pDs);
			break;
			
		case WINFRAME_ROUND:	//0x0401: corner:4, shadow width:0, width:1
			gdiOutlineRect(pWin, &r, 4, pDs);
			break;

		case WINFRAME_BOLDROUND://0x0702: corner:7, shadow width:0, width:2
			gdiOutlineRect(pWin, &r, 7, pDs);
			rctInset(&r, 1);
			gdiOutlineRect(pWin, &r, 7, pDs);
			break;

		case WINFRAME_POPUP:	//0x0205: corner:2, shadow width:1, width:1 
		{
			r.Width()--;
			r.Height()--;
			gdiOutlineRect(pWin, &r, 2, pDs);
			__s16 left= r.Left();
			__s16 top= r.Top();
			__s16 right= r.Right();
			__s16 bottom= r.Bottom();
			//seal the right-bottom corner of inner rectangle
			gdiLine(pWin, right-1, bottom-1, right, bottom-1, pDs);
			//Add shadow
			if ((top+2) < (bottom-2))
				gdiLine(pWin, right, top+2, right, bottom-1, pDs);	//right edge shadow
			if ((left+2) < (right-2))
				gdiLine(pWin, left+2, bottom, right-1, bottom, pDs);	//bottom edge shadow
			break;
		}
		case WINFRAME_DIALOG:	//0x0302: corner:3, shadow width:0, width:2
			gdiOutlineRect(pWin, &r, 3, pDs);
			rctInset(&r, 1);
			gdiOutlineRect(pWin, &r, 2, pDs);
			gdiLine(pWin, r.Left()+1, r.Top(), r.Left()+2, r.Top(), pDs);
			gdiLine(pWin, r.Right()-2, r.Top(), r.Right()-1, r.Top(), pDs);
			gdiLine(pWin, r.Left()+1, r.Bottom()-2, r.Left()+2, r.Bottom()-2, pDs);
			gdiLine(pWin, r.Right()-2, r.Bottom()-2, r.Right()-1, r.Bottom()-2, pDs);
			break;
	}
}
	
EXTERN_C void _JAPI winDrawBitmap(TBmp *pBmp, __s16 x, __s16 y, TDrawState *pDs)
{
	// find the closest colordepth if a bitmap family
	pBmp= bmpGetNearest(pBmp, winGetDrawWindow()->pBitmap->pixelSize);

	_err_t err;
	TWin* wh= winCreateOffscreen(pBmp, &err);
	if (!wh) return;
	
	TRect r={{0,0},{pBmp->width, pBmp->height}};
	WinToScreen(0, &x, &y);
	gdiBitBlt(0, x, y, wh, &r, pDs);
	winDestroy(wh);
}

EXTERN_C void _JAPI winDestroy(TWin *pWin, bool bDelWin)
{
	ASSERT(pWin != &g_winScrn);

	if(!pWin) return;

	if(pWin == winGetDrawWindow())
		winSetDrawWindow(0);

	//unlink
	for(TWin *q=0, *p=g_pWinList; p; q=p, p=p->next)
		if (p == pWin) {
			if(q)	q->next		= p->next;
			else	g_pWinList	= p->next;
			break;
		}

	if (pWin->flags.freeBitmap)
		bmpDestroy(pWin->pBitmap);

	if(bDelWin)
		_FREE(pWin);
}

EXTERN_C void _JAPI winErase(TWin *pWin, TDrawState *pDs)
{
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_WHITE;
	ds.backColor= pDs ? pDs->backColor : gdiGetBackColor();
	
	if (!pWin) pWin= winGetDrawWindow();
	gdiFillRect(pWin, &pWin->bounds, 0, &ds);
}

EXTERN_C TWin* _AAPI winSaveBits(const TRect* pRect, __u16* err)
{
	unsigned retErr;
	TWin *wh= winCreateOffscreenEx(pRect->Width(), pRect->Height(), 1, &retErr);
	*err= (__u16) retErr;
	if (!wh) return NULL;
	winCopyRect(0, wh, pRect, 0, 0, DSMODE_PAINT);
	return wh;
}

EXTERN_C void _AAPI winRestoreBits(TWin *wh, __s16 x, __s16 y)
{
	winCopyRect(wh, 0, &wh->bounds, x, y, DSMODE_PAINT);
	winDestroy(wh, true);
}

//////////////////////////////////////////////////////////
EXTERN_C void _JAPI dsThdCleanup(TThdLocal* thd)
{
	TDrawStateEx::Apply(DestroyDrawState, thd);
}

EXTERN_C void _JAPI winSysInit(void)
{
	InitDrawState(&s_winDrawState);

	winBindAndInit(&g_winScrn, g_pBmpScrn);
	ASSERT(!g_winScrn.owner);
}
	
EXTERN_C void _JAPI winAppCleanup(__u32 owner)
{
	TWin *p = g_pWinList;
	while(p){
		TWin *q = p;
		p = p->next;
		if(q->owner == owner){
			TRACE("Win leakage %p\n", q);
			winDestroy(q);
		}
	}
}
