/*	rct.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/7/24 08:25PM
	$Header: /cvsroot/jedi/gdi/rct.cxx,v 1.3 2000/08/31 09:50:17 tomyeh Exp $
	Purpose:	
	Description:	Implementation of Jedi's rctXXX()

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/rct.h>

//////////////////////////////////////////////////////////////////
EXTERN_C void _AAPI rctCopy(const TRect *pSrcRect, TRect *pDstRect)
{
	*pDstRect= *pSrcRect;
}

EXTERN_C bool _AAPI rctPtInRect(__s16 x, __s16 y, const TRect *pRect)
{
	return x >= pRect->Left() && x < pRect->Right() &&
		y >= pRect->Top() && y < pRect->Bottom();
}

EXTERN_C bool _AAPI rctIntersect(const TRect *pSrcRect1, const TRect *pSrcRect2, TRect *pDstRect)
{
	__s16 l = pDstRect->Left() = Max(pSrcRect1->Left(), pSrcRect2->Left());
	__s16 t = pDstRect->Top() = Max(pSrcRect1->Top(), pSrcRect2->Top());

	__s16 r = Min(pSrcRect1->Right(), pSrcRect2->Right());
	__s16 b = Min(pSrcRect1->Bottom(), pSrcRect2->Bottom());
	if (l >= r || t >= b){
		pDstRect->Width() = pDstRect->Height() = 0;
		return false;
	}

	pDstRect->Width() = (__s16)(r-l);
	pDstRect->Height() = (__s16)(b-t);
	return true;
}

EXTERN_C void _AAPI rctSet(TRect *pRect, __s16 left, __s16 top, __s16 width, __s16 height)
{
	pRect->Left()	= left;
	pRect->Top()	= top;
	pRect->Width()	= width;
	pRect->Height()	= height;
}

EXTERN_C void _AAPI rctInset(TRect *pRect, __s16 insetAmt)
{
	pRect->Left()	= (__s16)(pRect->Left() + insetAmt);
	pRect->Top()	= (__s16)(pRect->Top() + insetAmt);
	pRect->Width()	= (__s16)(pRect->Width() - (insetAmt << 1));
	pRect->Height()	= (__s16)(pRect->Height() - (insetAmt << 1));
}

EXTERN_C void _AAPI rctOffset(TRect *pRect, __s16 deltaX, __s16 deltaY)
{
	pRect->Left()	= (__s16)(pRect->Left() + deltaX);
	pRect->Top()	= (__s16)(pRect->Top() + deltaY);
}
