/*	gdi.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/7/21 10:33AM
	$Header: /cvsroot/jedi/gdi/gdi.cxx,v 1.15 2000/10/12 01:50:46 henrichen Exp $
	Purpose:		Jedi's graphic functions
	Description:	Implementation of jedi gdiXXX() functions

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/rct.h>
#include <jedi/fb.h>
#include <jedi/bmp.h>
#include <jedi/fnt.h>
#include <jedi/win.h>
#include <jedi/gdi.h>

//////////////////////////////////////////////////////////////////
static TPalette s_pal[256];		//default palette

inline void gdiSetPalEntry(int i, __u8 r, __u8 g, __u8 b)
{
	s_pal[i].index= 0;
	s_pal[i].r=(__u8)(r);
	s_pal[i].g=(__u8)(g);
	s_pal[i].b=(__u8)(b);
}

inline void gdiInitPalette16(void)
{
	__u8 r=0xff;
	for(int j=0; j<16; j++, r-= 0x11) {
		gdiSetPalEntry(j, r, r, r);
	}
}

inline void gdiInitPalette256(void)
{
	int index=0, rj, bj, gj;
	__u8 r=0xff, g, b;
	for(rj=0; rj<6; rj++, r-= 0x33) {
		b=0xff;
		for(bj=0; bj<3; bj++, b-= 0x33) {
			g=0xff;
			for(gj=0; gj<6; gj++, g-= 0x33) {
				gdiSetPalEntry(index++, r, g, b); 
			}
		}
	}
	r=0xff;
	for(rj=0; rj<6; rj++, r-= 0x33) {
		b=0x66;
		for(bj=0; bj<3; bj++, b-= 0x33) {
			g=0xff;
			for(gj=0; gj<6; gj++, g-= 0x33) {
				gdiSetPalEntry(index++, r, g, b); 
			}
		}
	}
	index--;
	r=0x11;
	for(int j=0; j<14; j++, r+= 0x11) {
		if ((r % 0x33)!=0)
			gdiSetPalEntry(index++, r, r, r);
	}

	gdiSetPalEntry(index++, 0xc0, 0xc0, 0xc0);
	gdiSetPalEntry(index++, 0x80, 0x00, 0x00);
	gdiSetPalEntry(index++, 0x80, 0x00, 0x80);
	gdiSetPalEntry(index++, 0x00, 0x80, 0x00);
	gdiSetPalEntry(index++, 0x00, 0x80, 0x80);

	while (index < 255) {
		gdiSetPalEntry(index, 0, 0, 0);
		index++;
	}
}

//////////////////////////////////////////////////////////////////
EXTERN_C __s16 _AAPI gdiSetDrawMode(__s16 mode)
{
	TDrawState *pDs= winGetDrawState();
	__s16 old= pDs->transferMode;
	pDs->transferMode= mode;
	return old;
}

EXTERN_C __s16 _AAPI gdiGetDrawMode(void)
{
	TDrawState *pDs= winGetDrawState();
	__s16 mode= pDs->transferMode;
	return mode;
}

EXTERN_C void _AAPI gdiSetPatternType(__s16 ptype)
{
	winGetDrawState()->pattern= ptype;
}

EXTERN_C __s16 _AAPI gdiGetPatternType(void)
{
	TDrawState *pDs= winGetDrawState();
	__s16 ptype= pDs->pattern;
	return ptype;
}

EXTERN_C void _AAPI gdiSetPattern(__u8 *pat)
{
	TDrawState *pDs= winGetDrawState();
	memcpy(pDs->patternData, pat, 8);
}

EXTERN_C void _AAPI gdiGetPattern(__u8 *pat)
{
	TDrawState *pDs= winGetDrawState();
	memcpy(pat, pDs->patternData, 8);
}

EXTERN_C __s16 _AAPI gdiSetUnderlineMode(__s16 mode)
{
	TDrawState *pDs= winGetDrawState();
	__s16 old= pDs->underlineMode;
	pDs->underlineMode= mode;
	return old;
}

EXTERN_C __s16 _AAPI gdiGetUnderlineMode(void)
{
	TDrawState *pDs= winGetDrawState();
	__s16 mode= pDs->underlineMode;
	return mode;
}

EXTERN_C __u8 _AAPI gdiSetForeColor(__u8 color)
{
	TDrawState *pDs= winGetDrawState();
	__u8 old= pDs->foreColor;
	pDs->foreColor= color;
	return old;
}

EXTERN_C __u8 _AAPI gdiGetForeColor(void)
{
	TDrawState *pDs= winGetDrawState();
	__u8 color= pDs->foreColor;
	return color;
}

EXTERN_C __u8 _AAPI gdiSetBackColor(__u8 color)
{
	TDrawState *pDs= winGetDrawState();
	__u8 old= pDs->backColor;
	pDs->backColor= color;
	return old;
}

EXTERN_C __u8 _AAPI gdiGetBackColor(void)
{
	TDrawState *pDs= winGetDrawState();
	__u8 color= pDs->backColor;
	return color;
}

EXTERN_C __u8 _AAPI gdiSetTextColor(__u8 color)
{
	TDrawState *pDs= winGetDrawState();
	__u8 old= pDs->textColor;
	pDs->textColor= color;
	return old;
}

EXTERN_C __u8 _AAPI gdiGetTextColor(void)
{
	TDrawState *pDs= winGetDrawState();
	__u8 color= pDs->textColor;
	return color;
}

//////////////////////////////////////////////////////////////////
EXTERN_C void _JAPI gdiSysInit(void)
{
	ASSERT(SCREEN_BPP == 8 || SCREEN_BPP == 4);
	
	if (SCREEN_BPP == 8)
		gdiInitPalette256();
	else
		gdiInitPalette16();			//initial the default palette
	bmpSysInit(s_pal);				//initial the screen bitmap 
}

EXTERN_C void _JAPI gdiSysCleanup(void)
{
	bmpSysCleanup();
}

EXTERN_C TPalette _JAPI gdiIndexToRGB(TWin *pWin, int index)
{
	TBmp *pPalBmp= (pWin && pWin->pBitmap->flags.hasColorTable) ?
					pWin->pBitmap : g_pBmpScrn;
	TPalette *pPal= bmpGetColorTableEntries(bmpGetColorTable(pPalBmp));
	if (index >= (1 << pPalBmp->pixelSize)) {
		TPalette rgb={0,0,0,0};
		return rgb;
	}
	return pPal[index];
}

EXTERN_C int _JAPI gdiRGBToIndex(TWin *pWin, TPalette pal)
{
	TBmp *pPalBmp= (pWin && pWin->pBitmap->flags.hasColorTable) ?
					pWin->pBitmap : g_pBmpScrn;
	TPalette *pPal= bmpGetColorTableEntries(bmpGetColorTable(pPalBmp));
	int j= bmpGetColorTable(pPalBmp)->numEntries;
	int minVal= 1024, minIndex=0, val;
	while (j-- > 0) {
		val= abs(pPal[j].r - pal.r)+abs(pPal[j].g - pal.g)+abs(pPal[j].b - pal.b);
		if (val <= minVal) {
			minVal= val;
			minIndex= j;
		}
	}
	return minIndex;
}

EXTERN_C void _JAPI gdiDrawCenterText(TWin *pWin, const char *str, TRect *pRect, int corner, TDrawState *pDs)
{
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.backColor= pDs->backColor;
	ds.pattern= DSPATTERN_WHITE;
	gdiFillRect(pWin, pRect, corner, &ds);
	TRect r;
	fntGetExtent(pDs->fontId, str, &r);
	int	x= (pRect->Left()+pRect->Right()-r.Width()) >> 1;
	int	y= (pRect->Top()+pRect->Bottom()-r.Height()) >> 1;
	gdiDrawChars(pWin, str, strlen(str), x, y, pDs);
}

