/*	fnt.cxx

{{IS_NOTE

Authors:	Henri Chen
Contributors:	Tom M. Yeh
Create Date:	8/30/0 09:09PM
$Header: /cvsroot/jedi/gdi/fnt.cxx,v 1.6 2000/10/12 01:50:46 henrichen Exp $
Purpose:	TFont
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/win.h>
#include <jedi/gdi.h>
#include <jedi/fnt.h>

TFont* g_pSysFonts[FONT_LARGEBOLD+1];

EXTERN_C void _JAPI fntSysInit(void)
{
	fntOsSysInit();

	//Init platform-independent fields
}

EXTERN_C void _JAPI fntSysCleanup(void)
{
	fntOsSysCleanup();
}

//?? 20000914, Henri Chen: have not support other system font and user font yet!
EXTERN_C TFont* _JAPI fntGetTFont(__s16 fontId)
{
	if (fontId <= FONT_LARGE/*FONT_LAST*/) {	//a system font
		return g_pSysFonts[fontId];
	}
/*	else if (fontId >= FONT_CUSTOM) {	//an user font
		TFont *pFont= g_usrFonts.Search(fontId);
		if (pFont) return pFont;
	}
*/
	return g_pSysFonts[0];
}

///////////////////////////////////////////////////////////
EXTERN_C __s16 _AAPI fntCharWidth(char ch)
{
	return (__s16) fntGetCharWidth(winGetDrawState()->fontId, ch);
}

EXTERN_C __s16 _AAPI fntAverageCharWidth(void)
{
	return fntCharWidth('X');
}

EXTERN_C __s16 _AAPI fntBaseLine(void)
{
	return fntGetFontPtr()->ascent;
}

EXTERN_C __s16 _AAPI fntCharHeight(void)
{
	return fntGetFontPtr()->height;
}

EXTERN_C void _AAPI fntCharsInWidth(
	const char* string, __s16 *stringWidthP, 
	__s16 *stringLengthP, bool *fitWithinWidth)
{
	__s16 width=0, len=0, charWidth;
	*fitWithinWidth= false;
	for(len= 0; len < *stringLengthP; len++) {
		charWidth= fntCharWidth(string[len]);
		if (string[len] == '\n' || (width+charWidth) > *stringWidthP) {
			*fitWithinWidth= true;
			break;
		}
		width+= charWidth;
	}
	*stringLengthP= len;
	*stringWidthP= width;
}

EXTERN_C __s16 _AAPI fntCharsWidth(
	const char* string, __s16 len)
{
	TRect rect;
	len= Min((__s16)strlen(string), len);
	char *buf= (char*) alloca(len+1);
	memcpy(buf, string, len);
	buf[len]= '\0';
	fntGetExtent(winGetDrawState()->fontId, buf, &rect);
	return rect.Width();
}

EXTERN_C _err_t _AAPI fntDefineFont(
	__s16 fontId, TFont *pFont)
{
/*
	Err ret= errNone;
	if (fontId < FONT_CUSTOM)
		ret= ERRS_PARAMERR;
	else if (!g_usrFonts.Attach(fontId, pFont))
		ret= ERRM_NOTENOUGHSPACE;
	return ret;
*/
	//?? 2000926, Henri Chen: We have not support user defined font yet!
	return ERRS_PARAMERR;
}

EXTERN_C __s16 _AAPI fntDescenderHeight(void)
{
	return fntGetFontPtr()->descent;
}

EXTERN_C __s16 _AAPI fntGetFont(void)
{
	return winGetDrawState()->fontId;
}

EXTERN_C TFont* _AAPI fntGetFontPtr(void)
{
	return winGetDrawState()->pFont;
}

EXTERN_C void _AAPI fntGetScrollValues(
	const char* string, __u16 width, 
	__u16 scrollPos, __u16 *linesP, __u16 *topLine)
{
	__u16 h=0, t= 0;
	__u16 lines=0;
	*topLine= 0;
	while (string[h]!='\0') {
		t+= fntWordWrap(&(string[h]), width);
		lines++;
		if (scrollPos >= h && scrollPos < t)
			break;
		h= t;
	}
	*topLine= lines-1;
	while (string[t]!='\0') {
		t+= fntWordWrap(&(string[t]), width);
		lines++;
	}
	*linesP= lines;
}

EXTERN_C __s16 _AAPI fntLineHeight(void)
{
	return fntGetFontPtr()->height+fntGetFontPtr()->leading;
}

EXTERN_C __s16 _AAPI fntLineWidth(
	const char* string, __u16 len)
{
	__s16 width=0;
	for(__u16 i=0; i < len; i++) {
		if (string[i]=='\t') {	//tab
			width+= FONT_TABWIDTH;
			width-= width % FONT_TABWIDTH;	//align to tab position
		}
		else
			width+= fntCharWidth(string[i]);
	}
	return width;
}

EXTERN_C __s16 _AAPI fntSetFont(
	__s16 id)
{
	__s16 oldid= winGetDrawState()->fontId;
	winGetDrawState()->fontId= id;
	winGetDrawState()->pFont= fntGetTFont(id);
	return oldid;
}

EXTERN_C __s16 _AAPI fntWidthToOffset(
	const char* string, __u16 len, __s16 pixelWidth, 
	bool *leadingEdge, __s16 *truncWidth)
{
	__s16 width=0, i=0;
	__u8 charWidth=0;
	for( ; i < len; i++) {
		charWidth= fntCharWidth(string[i]);
		if ((width+charWidth) >= pixelWidth)
			break;
		width+= charWidth;
	}
	if (leadingEdge)
		*leadingEdge= ((pixelWidth-width) < (charWidth/2));
	if (truncWidth)
		*truncWidth= width;
	
	return i;
}

inline bool fntIsBreakChar(const char ch)
{
	return ch == ' ' || ch == '\n' || ch == ',' || ch == '.';
}

EXTERN_C __u16 _AAPI fntWordWrap(
	const char* string, __u16 maxWidth)
{
	__s16 width= 0, i= 0, breakIndex= -1;
	__u8 charWidth;
	for( ; string[i]!='\0'; i++) {
		charWidth= fntCharWidth(string[i]);
		if ((width+charWidth) >= maxWidth)
			break;
		if (fntIsBreakChar(string[i]))
			breakIndex= i;
		width+= charWidth;
	}
	return (breakIndex == -1) ? i : (breakIndex+1);
}

EXTERN_C void _AAPI fntWordWrapReverseNLines(
	const char *string, __u16 maxWidth, 
	__u16 *linesToScrollP, __u16 *scrollPosP)
{
	__u16 h=0, t=0;
	__u16 topLine=0;
	while (string[h]!='\0') {
		t+= fntWordWrap(&(string[h]), maxWidth);
		if (*scrollPosP >= h && *scrollPosP < t)
			break;
		topLine++;
		h= t;
	}
	if (topLine < *linesToScrollP)
		*linesToScrollP= topLine;
	topLine-= *linesToScrollP;
	
	h= 0;
	__u16 line= 0;
	while (string[h]!='\0' && line < topLine) {
		h+= fntWordWrap(&(string[h]), maxWidth);
		line++;
	}
	*scrollPosP= h;
}

EXTERN_C __s16 _AAPI fntSelect(
	__s16 fontId)
{
	//20000713, Henri Chen: not yet!!
	ASSERT(0);
	return FONT_STD;
}
