/*	winmgr.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/1/0 05:05PM
	$Header: /cvsroot/jedi/anakin/winmgr.cxx,v 1.7 2000/10/12 01:50:46 henrichen Exp $
	Purpose:	Window Management
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/thread.h>
#include <jedi/fb.h>
#include <jedi/win.h>
#include <jedi/gdi.h>
#include <jedi/rct.h>
#include <jedi/fnt.h>
#include <anakin/types.h>
#include <anakin/api.h>

///////////////////////////////////////////////////////////
EXTERN_C void _AAPI sysWinScrollRectangle(
	const RectangleType* pRect,	WinDirectionType dir, Coord dis, RectangleType* pDstRect)
{
	int destX= pRect->Left();
	int destY= pRect->Top();
	rctCopy(pRect, pDstRect);
	
	if (dir == WINDIR_UP) {
		destY-= dis;
		pDstRect->Top()= destY + pRect->Height();
		pDstRect->Height()= dis;
	}
	else if (dir == WINDIR_DOWN) {
		destY+= dis;
		pDstRect->Height()= dis;
	}
	else if (dir == WINDIR_LEFT) {
		destX-= dis;
		pDstRect->Left()= destX + pRect->Width();
		pDstRect->Width()= dis;
	}
	else {	//dir == WINDIR_RIGHT
		destX+= dis;
		pDstRect->Width()= dis;
	}
		
	sysWinCopyRectangle(winGetDrawWindow(), winGetDrawWindow(), pRect, (__s16)destX, (__s16)destY, DSMODE_PAINT);
}

EXTERN_C void _AAPI sysWinGetDisplayExtent (Coord *wd, Coord *hgh)
{	//no need to lock
	if(wd)	*wd  = (Coord)SCREEN_WIDTH;
	if(hgh)	*hgh = (Coord)SCREEN_HEIGHT;
}

EXTERN_C WinHandle _AAPI sysWinGetFirstWindow (void)
{
	return g_pWinList; //no need to lock
}

EXTERN_C WinHandle _AAPI sysWinGetActiveWindow(void)
{
	return g_pWinActive; //no need to lock
}

EXTERN_C WinHandle _AAPI sysWinGetDisplayWindow(void)
{
	return &g_winScrn; //no need to lock
}

EXTERN_C void _AAPI sysWinDeleteWindow(WinHandle wh, Boolean bErase)
{
	AnakinLock();
	if (!wh->flags.offscreen && bErase)
		winErase(wh, 0);
	winDestroy(wh, true);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinGetWindowFrameRect(WinHandle wh,	RectangleType* pRect)
{
	AnakinLock();
	winGetFrameRect(wh->frameType, &wh->bounds, pRect);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinEraseWindow(void)
{
	AnakinLock();
	winErase(winGetDrawWindow(), 0);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinGetWindowExtent(Coord *x, Coord *y)
{	//no need to lock
	WinHandle wh= winGetDrawWindow();
	*x= wh->bounds.Width();
	*y= wh->bounds.Height();
}

EXTERN_C void _AAPI sysWinDisplayToWindowPt(Coord* x, Coord* y)
{
	AnakinLock();
	ScreenToWin(winGetDrawWindow(), x, y);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinWindowToDisplayPt(Coord* x, Coord* y)
{
	AnakinLock();
	WinToScreen(winGetDrawWindow(), x, y);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinDrawLine(Coord x1, Coord y1, Coord x2, Coord y2)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	WinToScreen(winGetDrawWindow(), &x1, &y1);
	WinToScreen(winGetDrawWindow(), &x2, &y2);
	gdiLine(winGetDrawWindow(), x1, y1, x2, y2, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinDrawGrayLine(Coord x1, Coord y1, Coord x2, Coord y2)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_GRAY;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	WinToScreen(winGetDrawWindow(), &x1, &y1);
	WinToScreen(winGetDrawWindow(), &x2, &y2);
	gdiLine(winGetDrawWindow(), x1, y1, x2, y2, &ds);
	AnakinUnlock();
}
		
EXTERN_C void _AAPI sysWinEraseLine(Coord x1, Coord y1, Coord x2, Coord y2)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetBackColor();
	WinToScreen(winGetDrawWindow(), &x1, &y1);
	WinToScreen(winGetDrawWindow(), &x2, &y2);
	gdiLine(winGetDrawWindow(), x1, y1, x2, y2, &ds);
	AnakinUnlock();
}
		
EXTERN_C void _AAPI sysWinInvertLine(Coord x1, Coord y1, Coord x2, Coord y2)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_INVERT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	WinToScreen(winGetDrawWindow(), &x1, &y1);
	WinToScreen(winGetDrawWindow(), &x2, &y2);
	gdiLine(winGetDrawWindow(), x1, y1, x2, y2, &ds);
	AnakinUnlock();
}
		
EXTERN_C void _AAPI sysWinFillLine(Coord x1, Coord y1, Coord x2, Coord y2)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= gdiGetPatternType();
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	WinToScreen(winGetDrawWindow(), &x1, &y1);
	WinToScreen(winGetDrawWindow(), &x2, &y2);
	gdiLine(winGetDrawWindow(), x1, y1, x2, y2, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinDrawRectangle(const RectangleType* pRect, UInt16 radius)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	RectangleType r;
	rctCopy(pRect, &r);
	WinToScreen(winGetDrawWindow(), &r.Left(), &r.Top());
	gdiFillRect(winGetDrawWindow(), &r, radius, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinEraseRectangle(const RectangleType* pRect, UInt16 radius)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetBackColor();
	RectangleType r;
	rctCopy(pRect, &r);
	WinToScreen(winGetDrawWindow(), &r.Left(), &r.Top());
	gdiFillRect(winGetDrawWindow(), &r, radius, &ds);
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinInvertRectangle(const RectangleType* pRect, UInt16 radius)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_INVERT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	RectangleType r;
	rctCopy(pRect, &r);
	WinToScreen(winGetDrawWindow(), &r.Left(), &r.Top());
	gdiFillRect(winGetDrawWindow(), &r, radius, &ds);
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinDrawRectangleFrame(FrameType frameType, const RectangleType* pRect)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	winDrawFrame(frameType, pRect, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinDrawGrayRectangleFrame(FrameType frameType, const RectangleType* pRect)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_GRAY;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	winDrawFrame(frameType, pRect, &ds);
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinEraseRectangleFrame(FrameType frameType, const RectangleType* pRect)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetBackColor();
	winDrawFrame(frameType, pRect, &ds);
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinInvertRectangleFrame(FrameType frameType,	const RectangleType* pRect)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_INVERT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	winDrawFrame(frameType, pRect, &ds);
	AnakinUnlock();
}
	
DEF_MT_API3(void, WinGetFramesRectangle, winGetFrameRect, FrameType, const RectangleType*, RectangleType*)

EXTERN_C void _AAPI sysWinDrawChars(const Char* str, Int16 len, Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.textColor= gdiGetTextColor();
	ds.backColor= gdiGetBackColor();
	ds.underlineMode= gdiGetUnderlineMode();
	ds.fontId= fntGetFont();
	ds.pFont= fntGetFontPtr();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiDrawChars(winGetDrawWindow(), str, len, x, y, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinEraseChars(const Char* str, Int16 len, Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_MASK;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.textColor= gdiGetTextColor();
	ds.backColor= gdiGetBackColor();
	ds.underlineMode= gdiGetUnderlineMode();
	ds.fontId= fntGetFont();
	ds.pFont= fntGetFontPtr();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiDrawChars(winGetDrawWindow(), str, len, x, y, &ds);
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinInvertChars(const Char* str, Int16 len, Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_INVERT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	ds.textColor= gdiGetTextColor();
	ds.underlineMode= gdiGetUnderlineMode();
	ds.fontId= fntGetFont();
	ds.pFont= fntGetFontPtr();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiDrawChars(winGetDrawWindow(), str, len, x, y, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinDrawBitmap(BitmapType *pBmp, Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	winDrawBitmap(pBmp, x, y, &ds);
	AnakinUnlock();
}

EXTERN_C Boolean _AAPI sysWinModal(WinHandle wh)
{
	//no need to lock
	return wh->flags.modal != 0;
}

DEF_MT_API1(void, WinGetWindowBounds, winGetBounds, RectangleType*)

EXTERN_C void _AAPI sysWinFillRectangle(const RectangleType* pRect, UInt16 radius)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= gdiGetPatternType();
	gdiGetPattern(ds.patternData);
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	RectangleType r;
	rctCopy(pRect, &r);
	WinToScreen(winGetDrawWindow(), &r.Left(), &r.Top());
	gdiFillRect(winGetDrawWindow(), &r, radius, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinDrawInvertedChars(const Char* str, Int16 len, Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.textColor= gdiGetBackColor();
	ds.foreColor= gdiGetBackColor();
	ds.backColor= gdiGetTextColor();
	ds.underlineMode= gdiGetUnderlineMode();
	ds.fontId= fntGetFont();
	ds.pFont= fntGetFontPtr();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiDrawChars(winGetDrawWindow(), str, len, x, y, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinPaintChar(WChar c, Coord x, Coord y)
{
	//?? not support wide character yet!
	AnakinLock();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiDrawChars(winGetDrawWindow(), (char*)&c, 1, x, y, winGetDrawState());
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinPaintChars(const Char* str, Int16 len, Coord x, Coord y)
{
	AnakinLock();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiDrawChars(winGetDrawWindow(), str, len, x, y, winGetDrawState());
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinPaintBitmap(BitmapType* pBmp, Coord x, Coord y)
{
	AnakinLock();
	winDrawBitmap(pBmp, x, y, winGetDrawState());
	AnakinUnlock();
}
	
EXTERN_C IndexedColorType _AAPI sysWinGetPixel(Coord x, Coord y)
{
	AnakinLock();
	WinToScreen(winGetDrawWindow(), &x, &y);
	IndexedColorType index= (IndexedColorType) gdiGetPixel(winGetDrawWindow(), x, y);
	AnakinUnlock();
	return index;
}

EXTERN_C void _AAPI sysWinPaintPixel(Coord x, Coord y)
{
	AnakinLock();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiSetPixel(winGetDrawWindow(), x, y, winGetDrawState());
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinDrawPixel(Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiSetPixel(winGetDrawWindow(), x, y, &ds);
	AnakinUnlock();
}	

EXTERN_C void _AAPI sysWinErasePixel(Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetBackColor();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiSetPixel(winGetDrawWindow(), x, y, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinInvertPixel(Coord x, Coord y)
{
	AnakinLock();
	TDrawState ds;
	ds.transferMode= DSMODE_INVERT;
	ds.pattern= DSPATTERN_BLACK;
	ds.foreColor= gdiGetForeColor();
	ds.backColor= gdiGetBackColor();
	WinToScreen(winGetDrawWindow(), &x, &y);
	gdiSetPixel(winGetDrawWindow(), x, y, &ds);
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinPaintPixels(UInt16 num, PointType* pts)
{
	AnakinLock();
	Coord x, y;
	for (int i= 0; i < num; i++) {
		x= pts[i].x;
		y= pts[i].y;
		WinToScreen(winGetDrawWindow(), &x, &y);
		gdiSetPixel(winGetDrawWindow(), x, y, winGetDrawState());
	}
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinPaintLines(UInt16 num, WinLineType* lines)
{
	AnakinLock();
	Coord x1, y1, x2, y2;
	for (int i= 0; i < num; i++) {
		x1= lines[i].x1;
		y1= lines[i].y1;
		x2= lines[i].x2;
		y2= lines[i].y2;
		WinToScreen(winGetDrawWindow(), &x1, &y1);
		WinToScreen(winGetDrawWindow(), &x2, &y2);
		gdiLine(winGetDrawWindow(), x1, y1, x2, y2, winGetDrawState());
	}		
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinPaintLine(Coord x1, Coord y1, Coord x2, Coord y2)
{
	AnakinLock();
	WinToScreen(winGetDrawWindow(), &x1, &y1);
	WinToScreen(winGetDrawWindow(), &x2, &y2);
	gdiLine(winGetDrawWindow(), x1, y1, x2, y2, winGetDrawState());
	AnakinUnlock();
}

EXTERN_C void _AAPI sysWinPaintRectangle(const RectangleType* pRect, UInt16 radius)
{
	AnakinLock();
	RectangleType r;
	rctCopy(pRect, &r);
	WinToScreen(winGetDrawWindow(), &r.Left(), &r.Top());
	gdiFillRect(winGetDrawWindow(), &r, radius, winGetDrawState());
	AnakinUnlock();
}
	
EXTERN_C void _AAPI sysWinPaintRectangleFrame(FrameType frameType, const RectangleType* pRect)
{
	AnakinLock();
	winDrawFrame(frameType, pRect, winGetDrawState());
	AnakinUnlock();
}

EXTERN_C IndexedColorType _AAPI sysWinRGBToIndex(const RGBColorType *rgbP)
{
	return (IndexedColorType) gdiRGBToIndex(winGetDrawWindow(), *rgbP);
}

EXTERN_C void _AAPI sysWinIndexToRGB(IndexedColorType index, RGBColorType* rgbP)
{
	*rgbP= gdiIndexToRGB(winGetDrawWindow(), index);
}

EXTERN_C BitmapType* _AAPI sysWinGetBitmap(WinHandle wh)
{
	return wh->pBitmap;
}

EXTERN_C void _AAPI sysWinGetPattern(CustomPatternType* pat)
{
	gdiGetPattern((__u8*) pat);
}

EXTERN_C void _AAPI sysWinSetPattern(const CustomPatternType* pat)
{
	gdiSetPattern((__u8*) pat);
}

DEF_MT_API1(void, WinSetActiveWindow, winSetActive, WinHandle)
DEF_MT_API5(WinHandle, WinCreateWindow, winCreate, const RectangleType*, FrameType, Boolean, Boolean, UInt16*)
DEF_MT_API4(WinHandle, WinCreateOffscreenWindow, winCreateOffscreenEx, Coord, Coord, WindowFormatType, UInt16*)
DEF_MT_API6(void, WinCopyRectangle, winCopyRect, WinHandle, WinHandle, const RectangleType*, Coord, Coord, WinDrawOperation)
DEF_MT_API1(void, WinGetClip, winGetClip, RectangleType*)
DEF_MT_API1(void, WinSetClip, winSetClip, const RectangleType*)
DEF_MT_API0(void, WinResetClip, winResetClip)
DEF_MT_API1(void, WinClipRectangle, winClipRect, RectangleType*)
DEF_MT_API2(WinHandle, WinCreateBitmapWindow, winCreateOffscreen, BitmapType*, UInt16*)
DEF_MT_API2(WinHandle, WinSaveBits, winSaveBits, const RectangleType*, UInt16*)
DEF_MT_API3(void, WinRestoreBits, winRestoreBits, WinHandle, Coord, Coord)
