/*	thdmgr.cxx

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	9/4/0 03:21PM
$Header: /cvsroot/jedi/anakin/thdmgr.cxx,v 1.4 2000/09/07 10:09:33 tomyeh Exp $
Purpose:	Anakin Thread Fucntions
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/thread.h>
#include <anakin/types.h>
#include <anakin/api.h>

////////////////////////////////////////////////////////
DEF_MT_API3(ThreadID, MtCreateThread, mtCreateThread, ThreadProcPtr, MemPtr, UInt32)
DEF_MT_API0(void, MtExitThread, mtExitThread)
DEF_MT_API1(Boolean, MtKillThread, mtKillThread, ThreadID)
DEF_MT_API0(void, MtExitProcess, mtExitProcess)
DEF_MT_API2(Boolean, MtWaitThread, mtWaitThread, ThreadID, UInt32)
DEF_MT_API2(Boolean, MtSetPriority, mtSetPriority, ThreadID, Int32)
DEF_MT_API1(Int32, MtGetPriority, mtGetPriority, ThreadID)
DEF_MT_API1(Boolean, MtThreadActive, mtThreadActive, ThreadID)
//The following mtXxx functions are implemented as inline, so
//we can't use #define sysMtXxx mtXxx

EXTERN_C UInt32 _AAPI sysMtGetCurrentThread(void)
{
	return mtGetCurrentThread();
		//no need to lock since it is stored in thread local
		//we don't use #define since it is an inline function
}

EXTERN_C void _AAPI sysMtSleep(unsigned ticks)
{
	mtAnakinSleep(ticks); //don't lock
}

EXTERN_C void _AAPI sysMtYield(void)
{
	mtAnakinYield(); //don't lock
}

////////////////////////////////////////////////////////
EXTERN_C MutexHandle _AAPI sysMtCreateMutex(void)
{
	AnakinLock();
	MutexHandle mutex = _MALLOC_T(_mutex_t);
	if(mutex)
		mtInitMutex(mutex);
	AnakinUnlock();
	return mutex;
}

EXTERN_C void _AAPI sysMtDestroyMutex(MutexHandle mutex)
{
	if(mutex){
		AnakinLock();
		mtDestroyMutex(mutex);
		_FREE(mutex);
		AnakinUnlock();
	}
}

////////////////////////////////////////////////////////
DEF_MT_API2(Boolean, MtWaitCond, mtWaitCond, CondHandle, UInt32)

EXTERN_C CondHandle _AAPI sysMtCreateCond(MutexHandle mutex, Boolean bBroadcast)
{
	if(!mutex) return 0;

	AnakinLock();
	CondHandle cond = _MALLOC_T(_cond_t);
	if(cond)
		mtInitCond(cond, mutex, bBroadcast);
	AnakinUnlock();
	return cond;
}

EXTERN_C void _AAPI sysMtDestroyCond(CondHandle cond)
{
	if(cond){
		AnakinLock();
		mtDestroyCond(cond);
		_FREE(cond);
		AnakinUnlock();
	}
}

EXTERN_C void _AAPI sysMtSetCond(CondHandle cond)
{
	if(cond)
		mtSetCond(cond); //no need to lock
}
