/*	menumgr.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/25/0 02:15PM
	$Header: /cvsroot/jedi/anakin/menumgr.cxx,v 1.2 2000/08/30 07:49:49 tomyeh Exp $
	Purpose:	Menu Management Functions
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/thread.h>
#include <jedi/menu.h>
#include <anakin/types.h>
#include <anakin/api.h>

DEF_MT_API1(MenuBarType*, MenuInit, mnuCreate, UInt16)
DEF_MT_API1(void, MenuDispose, mnuDestroy, MenuBarType*)
DEF_MT_API3(Boolean, MenuHandleEvent, mnuHandleEvent, MenuBarType*, EventType*, UInt16*)
DEF_MT_API1(void, MenuDrawMenu, mnuPopup, MenuBarType*)

EXTERN_C void _AAPI sysMenuEraseStatus(MenuBarType*)
{
	AnakinLock();
	mnuCmdbarDismiss();
	mnuDismiss();
	AnakinUnlock();
}

EXTERN_C MenuBarType* _AAPI sysMenuGetActiveMenu(void)
{
	return mnuGetActive(); //no need to lock
}

DEF_MT_API1(MenuBarType*, MenuSetActiveMenu, mnuSetActive, MenuBarType*)
DEF_MT_API1(void, MenuSetActiveMenuRscID, mnuSetActiveRes, UInt16)

DEF_MT_API5(Err, MenuCmdBarAddButton, mnuCmdbarAddItem, UInt16, UInt16, MenuCmdBarResultType, UInt32, Char*)
DEF_MT_API5(Boolean, MenuCmdBarGetButtonData, mnuCmdbarGetItem, Int16, UInt16*, MenuCmdBarResultType*, UInt32*, Char*)
DEF_MT_API0(void, MenuCmdBarDisplay, mnuCmdbarPopup)

DEF_MT_API1(Boolean, MenuShowItem, mnuShowItem, UInt16)
DEF_MT_API1(Boolean, MenuHideItem, mnuHideItem, UInt16)
DEF_MT_API4(Err, MenuAddItem, mnuAddItem, UInt16, UInt16, Char, const Char*)
DEF_MT_API2(Err, MenuAddPullDown, mnuAddPullDown, UInt16, const Char*)
