/*	keymgr.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/9/0 07:16PM
	$Header: /cvsroot/jedi/anakin/keymgr.cxx,v 1.9 2000/09/26 10:09:26 tomyeh Exp $
	Purpose:	
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/thread.h>
#include <jedi/event.h>
#include <jedi/power.h>
#include <anakin/types.h>
#include <anakin/api.h>

////////////////////////////////////////////////////////////
EXTERN_C UInt32 _AAPI sysKeyCurrentState(void)
{
	return evtGetHwBtnState();
}

EXTERN_C UInt32 _AAPI sysKeySetMask(UInt32 keyMask)
{
	return evtSetHwBtnMask(keyMask);
}

////////////////////////////////////////////////////////////
DEF_MT_API2(Boolean, EvtGetEvent, evtGetEvent, EventType*, Int32)
DEF_MT_API1(void, EvtAddEventToQueue, evtPushEvent, const EventType*)
DEF_MT_API0(Err, EvtFlushKeyQueue, evtFlushKeyQue)
DEF_MT_API3(Err, EvtEnqueueKey, evtPushKey, WChar, UInt16, UInt16)
DEF_MT_API0(Boolean, EvtKeyQueueEmpty, evtKeyQueEmpty)
DEF_MT_API0(Boolean, EvtEventAvail, evtEventAvail)
DEF_MT_API1(Boolean, EvtSysEventAvail, evtSysEventAvail, Boolean)
DEF_MT_API3(void, EvtAddUniqueEventToQueue, evtPushEventUnique, const EventType*, UInt32, Boolean)

////////////////////////////////////////////////////////////
EXTERN_C void _AAPI sysEvtCopyEvent(const EventType *source, EventType *dest)
{
	memcpy(dest, source, sizeof(EventType));
}

////////////////////////////////////////////////////////////
EXTERN_C Err _AAPI sysEvtWakeup(void)
{
	AnakinLock();
	evtPushEventEx(EVT_NIL);
	AnakinUnlock();
	return 0;
}

EXTERN_C Err _AAPI sysEvtResetAutoOffTimer(void)
{
	pwrResetIdleTimer();
	return 0;
}

////////////////////////////////////////////////////////////
static unsigned s_szKeyQue = 64; //to fake

EXTERN_C Err _AAPI sysEvtSetKeyQueuePtr(MemPtr /*keyQueueP*/, UInt32 size)
{
	s_szKeyQue = size;
	return 0;
}

EXTERN_C UInt32 _AAPI sysEvtKeyQueueSize(void)
{
	return s_szKeyQue;
}

////////////////////////////////////////////////////////////
static unsigned s_szPenQue = 256; //to fake

EXTERN_C Err _AAPI sysEvtSetPenQueuePtr(MemPtr /*penQueueP*/, UInt32 size)
{
	s_szPenQue = size;
	return 0;
}

EXTERN_C UInt32 _AAPI sysEvtPenQueueSize(void)
{
	return s_szPenQue;
}

////////////////////////////////////////////////////////////
EXTERN_C const PenBtnInfoType* _AAPI sysEvtGetPenBtnList(UInt16* numButtons)
{
	if(numButtons) *numButtons = PEN_BTN_NO;
	return g_penBtnList;
}

////////////////////////////////////////////////////////////
EXTERN_C Err _AAPI sysKeyRates(
	Boolean set, UInt16 *initDelayP, UInt16 *periodP,
	UInt16 *doubleTapDelayP, Boolean *queueAheadP)
{
	if(set){
		if(initDelayP) *initDelayP = 50;
		if(periodP) *periodP = 12;
		if(doubleTapDelayP) *doubleTapDelayP = 200;
		if(queueAheadP) *queueAheadP = false;
	}
	return 0;
}
