/*	formmgr.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/25/0 03:34PM
	$Header: /cvsroot/jedi/anakin/formmgr.cxx,v 1.6 2000/09/15 09:08:31 tomyeh Exp $
	Purpose:	Form management functions
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/thread.h>
#include <jedi/form.h>
#include <anakin/types.h>
#include <anakin/api.h>

/////////////////////////////////////////////////////
DEF_MT_API1(FormType*, FrmInitForm, frmCreateRsc, UInt16)
DEF_MT_API1(void, FrmDeleteForm, frmDestroy, FormType*)

DEF_MT_API1(void, FrmDrawForm, frmDraw, FormType*)
DEF_MT_API1(void, FrmEraseForm, frmErase, FormType*)

/////////////////////////////////////////////////////
UInt16 _AAPI sysFrmGetFocus(const FormType* frm)
{
	return frm ? frm->focus: (UInt16)0; //no need to lock
}

void _AAPI sysFrmSetFocus(FormType* frm, UInt16 focus)
{
	if(frm) frm->focus = focus; //no need to lock
}

/////////////////////////////////////////////////////
EXTERN_C FormType* _AAPI sysFrmGetActiveForm()
{
	return g_pFrmActive; //no need to lock
}

DEF_MT_API1(void, FrmSetActiveForm, frmSetActive, FormType*)

EXTERN_C UInt16 _AAPI sysFrmGetActiveFormID()
{
	AnakinLock();
	UInt16 v = g_pFrmActive ? g_pFrmActive->frmId: (UInt16)0;
	AnakinUnlock();
	return v;
}

DEF_MT_API2(Err, FrmActiveState, frmActiveState, FormActiveStateType*, Boolean)

/////////////////////////////////////////////////////
DEF_MT_API1(Boolean, FrmDispatchEvent, frmDispatchEvent, EventType*)
DEF_MT_API2(Boolean, FrmHandleEvent, frmHandleEvent, FormType*, EventType*)
DEF_MT_API2(Boolean, CtlHandleEvent, ctlHandleEvent, ControlType*, EventType*)

EXTERN_C void _AAPI sysFrmSetEventHandler(FormType* frm, FormEventHandlerType* pf)
{
	if(frm)
		frm->handler = pf; //no need to lock
}

/////////////////////////////////////////////////////
void _AAPI sysFrmGetFormBounds(const FormType *frm, RectangleType *rc)
{
	if(rc && frm){
		AnakinLock();
		memcpy(rc, &frm->window.bounds, sizeof(RectangleType));
		AnakinUnlock();
	}
}

/////////////////////////////////////////////////////
EXTERN_C WinHandle _AAPI sysFrmGetWindowHandle(const FormType* frm)
{
	return frm ? &((FormType*)frm)->window: 0; //no need to lock
}

EXTERN_C UInt16 _AAPI sysFrmGetFormId(const FormType* frm)
{
	return frm ? frm->frmId: (UInt16)0; //no need to lock
}

DEF_MT_API1(FormType*, FrmGetFormPtr, frmFind, UInt16)

/////////////////////////////////////////////////////
EXTERN_C const Char* _AAPI sysFrmGetTitle(const FormType* frm)
{
	return frm ? frm->pObjNodes[0].objPtr.title->text: 0; //no need to lock
}

DEF_MT_API2(void, FrmSetTitle, frmSetTitle, FormType*, Char*)

DEF_MT_API3(Boolean, FrmPointInTitle, frmPointInTitle, const FormType*, Coord, Coord)

/////////////////////////////////////////////////////
DEF_MT_API2(void, FrmSetMenu, frmSetMenu, FormType*, UInt16)

EXTERN_C Boolean _AAPI sysFrmVisible(const FormType *frm)
{
	return frm ? frm->attr.drawn: 0;
}

/////////////////////////////////////////////////////
DEF_MT_API1(UInt16, FrmAlert, frmAlert, UInt16)
DEF_MT_API1(UInt16, FrmDoDialog, frmDoDialog, FormType*)
DEF_MT_API4(UInt16, FrmCustomAlert, frmCustomAlert, UInt16, const Char*, const Char*, const Char*)
DEF_MT_API1(void, FrmHelp, frmHelp, UInt16)

/////////////////////////////////////////////////////
DEF_MT_API0(void, FrmCloseAllForms, frmCloseAll)
DEF_MT_API0(void, FrmSaveAllForms, frmSaveAll)
DEF_MT_API2(void, FrmUpdateForm, frmUpdate, UInt16, UInt16)

/////////////////////////////////////////////////////
DEF_MT_API10(FormType*, FrmNewForm, frmCreate, UInt16, const Char*,
	Coord, Coord, Coord, Coord, Boolean, UInt16, UInt16, UInt16)

DEF_MT_API1(Boolean, FrmValidatePtr, frmValid, const FormType*)

DEF_MT_API1(void, FrmGotoForm, frmGoto, UInt16)
DEF_MT_API1(void, FrmPopupForm, frmPopup, UInt16)
DEF_MT_API1(void, FrmReturnToForm, frmReturn, UInt16)

/////////////////////////////////////////////////////
DEF_MT_API6(FormLabelType*, FrmNewLabel, _frmCreateLabel, FormType**, UInt16, const Char*, Coord, Coord, FontID)
DEF_MT_API11(ControlType*, CtlNewControl, _frmCreateCtl, FormType**, UInt16, ControlStyleType, const Char*, Coord, Coord, Coord, Coord, FontID, UInt8, Boolean)

EXTERN_C Err _AAPI sysFrmRemoveObject(FormType **pfrm, UInt16 index)
{
	if(!pfrm)
		return ERRS_PARAMERR;

	AnakinLock();
	Err err =  frmDestroyCtl(*pfrm, index);
	AnakinUnlock();
	return err;
}

DEF_MT_API3(void, FrmGetObjectBounds, frmGetObjBounds, const FormType*, UInt16, RectangleType*)
DEF_MT_API3(void, FrmSetObjectBounds, frmSetObjBounds, FormType*, UInt16, const RectangleType*)
DEF_MT_API4(void, FrmGetObjectPosition, frmGetObjPosition, const FormType*, UInt16, Coord*, Coord*)
DEF_MT_API4(void, FrmSetObjectPosition, frmSetObjPosition, FormType*, UInt16, Coord, Coord)

EXTERN_C UInt16 _AAPI sysFrmGetNumberOfObjects(const FormType* frm)
{
	return frm ? frm->numObjs: (UInt16)0; //no need to lock
}

DEF_MT_API2(UInt16, FrmGetObjectIndex, frmGetObjIndex, const FormType*, UInt16)
DEF_MT_API2(UInt16, FrmGetObjectId, frmGetObjId, const FormType*, UInt16)

EXTERN_C void* _AAPI sysFrmGetObjectPtr(const FormType* frm, UInt16 index)
{
	AnakinLock();
	TObjNode *p = frmGetObjNode(frm, index);
	AnakinUnlock();
	return p ? p->objPtr.ptr: 0;
}

EXTERN_C FormObjectKind _AAPI sysFrmGetObjectType(const FormType* frm, UInt16 index)
{
	AnakinLock();
	FormObjectKind v = frm && index<frm->numObjs ?
			frm->pObjNodes[index].objType: (FormObjectKind)0;
	AnakinUnlock();
	return v;
}

/////////////////////////////////////////////////////
DEF_MT_API2(const Char*, FrmGetLabel, frmGetLabel, const FormType*,UInt16)
DEF_MT_API3(void, FrmSetLabel, frmSetLabel, FormType*, UInt16, const Char*)

DEF_MT_API2(void, FrmHideObject, frmHideObj, FormType*, UInt16)
DEF_MT_API2(void, FrmShowObject, frmShowObj, FormType*, UInt16)

/////////////////////////////////////////////////////
DEF_MT_API2(void, CtlSetLabel, ctlSetLabel, ControlType*, const Char*)

EXTERN_C const Char* _AAPI sysCtlGetLabel(const ControlType* ctl)
{
	return ctl ? ctl->text : 0; //no need to lock
}

DEF_MT_API2(Int16, FrmGetControlValue, frmGetCtlVal, const FormType*, UInt16)
DEF_MT_API3(void, FrmSetControlValue, frmSetCtlVal, const FormType*, UInt16, Int16)

DEF_MT_API2(UInt16, FrmGetControlGroupSelection, frmGetCtlGrpSel, const FormType*, UInt8)
DEF_MT_API3(void, FrmSetControlGroupSelection, frmSetCtlGrpSel, const FormType*, UInt8, UInt16)

DEF_MT_API1(Boolean, CtlValidatePointer, ctlValidatePtr, const ControlType*)

DEF_MT_API1(void, CtlHideControl, ctlHide, ControlType*)
DEF_MT_API1(void, CtlShowControl, ctlShow, ControlType*)

DEF_MT_API1(void, CtlDrawControl, ctlDraw, ControlType*)
DEF_MT_API1(void, CtlEraseControl, ctlErase, ControlType*)
DEF_MT_API1(void, CtlHitControl, ctlHit, const ControlType*)

DEF_MT_API1(Int16, CtlGetValue, ctlGetVal, const ControlType*)
DEF_MT_API2(void, CtlSetValue, ctlSetVal, ControlType*, Int16)

EXTERN_C Boolean _AAPI sysCtlEnabled(const ControlType* ctl)
{
	return ctl ? ctl->attr.enabled: false; //no need to lock
}

EXTERN_C void _AAPI sysCtlSetEnabled(ControlType *ctl, Boolean b)
{
	if(ctl) ctl->attr.enabled = b; //no need to lock
		//no update to screen; see Palm API
}

EXTERN_C void _AAPI sysCtlSetUsable(ControlType *ctl, Boolean b)
{
	if(ctl) ctl->attr.usable = b; //no need to lock
		//no update to screen; see Palm API
}
