/*	bmpmgr.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/1/0 11:58AM
	$Header: /cvsroot/jedi/anakin/bmpmgr.cxx,v 1.2 2000/09/08 01:48:21 henrichen Exp $
	Purpose:	Bitmap Functions
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/thread.h>
#include <jedi/mem.h>
#include <jedi/bmp.h>
#include <anakin/types.h>
#include <anakin/api.h>

DEF_MT_API1(UInt32, BmpSize, bmpGetSize, BitmapType *)
DEF_MT_API1(Err, BmpDelete, bmpDestroy, BitmapType *)
DEF_MT_API1(UInt32, BmpBitsSize, bmpGetBitsSize, BitmapType *)

EXTERN_C BitmapType* _AAPI sysBmpCreate(Coord x, Coord y, UInt8 depth, ColorTableType *colortable, UInt16* err)
{
	_err_t err32;
	AnakinLock();
	BitmapType *pBmp= bmpCreate(x, y, depth, colortable, &err32);
	AnakinUnlock();
	*err= (UInt16) err32;
	return pBmp;
}

EXTERN_C void* _AAPI sysBmpGetBits(BitmapType* pBmp)
{
	if(!pBmp) return 0;

	AnakinLock();
	ASSERT(pBmp->flags.indirect);
	void* p = mmGetPtr(*bmpGetMemHandleAddr(pBmp), true);
	AnakinUnlock();
	return p;
}
