/*	api.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/8/0 04:44PM
	$Header: /cvsroot/jedi/anakin/api.cxx,v 1.21 2000/10/12 01:50:46 henrichen Exp $
	Purpose:	The function table of all Anankin API
	Description:
	Note:
	1.	The owner ID is 32-bit while Palm API is 16-bit. It is OK
		because only 68k prc apps uses 16-bits, which is handled
		specially by JediVM.dll.
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/event.h>
#include <jedi/launch.h>
#include <jedi/time.h>
#include <jedi/mem.h>
#include <jedi/rct.h>
#include <jedi/bmp.h>
#include <jedi/win.h>
#include <jedi/form.h>
#include <jedi/fnt.h>
#include <jedi/gdi.h>
#include <anakin/types.h>
#include <anakin/api.h>

/////////////////////////////////////////////////////////
//Note: _AAPI is actually _CDECL, so it is OK to have cast between
//different signature.
static Err _AAPI SysTrap(void)
{
	TRACE("A system trap is called\n");
	ASSERT(0);
	return 0;
}

#ifdef NDEBUG
#define NullTrap	SysTrap
#else
static Err _AAPI NullTrap(void)
{
	return 0;
}
#endif

/////////////////////////////////////////////////////////
typedef struct TAnakinApi {
#define _JDK_PRIME_
#include <anakin/_traps.h>
} TAnakinApi;

typedef struct TAnakinExApi {
#define _JDK_EXT_
#include <anakin/_traps.h>
} TAnakinExApi;

const TAnakinApi gJdk_api = {
#define _JDK_API0(Rt, Fn)	sys##Fn,
#define _JDK_API1(Rt, Fn, a1)	sys##Fn,
#define _JDK_API2(Rt, Fn, a1, a2)	sys##Fn,
#define _JDK_API3(Rt, Fn, a1, a2, a3)	sys##Fn,
#define _JDK_API4(Rt, Fn, a1, a2, a3, a4)	sys##Fn,
#define _JDK_API5(Rt, Fn, a1, a2, a3, a4, a5)	sys##Fn,
#define _JDK_API6(Rt, Fn, a1, a2, a3, a4, a5, a6)	sys##Fn,
#define _JDK_API7(Rt, Fn, a1, a2, a3, a4, a5, a6, a7)	sys##Fn,
#define _JDK_API8(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8)	sys##Fn,
#define _JDK_API9(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9)	sys##Fn,
#define _JDK_API10(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)	sys##Fn,
#define _JDK_API11(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)	sys##Fn,
#define _JDK_PRIME_
#include <anakin/_traps.h>
};

const TAnakinExApi gJdk_apiEx = {
#define _JDK_API0(Rt, Fn)	sys##Fn,
#define _JDK_API1(Rt, Fn, a1)	sys##Fn,
#define _JDK_API2(Rt, Fn, a1, a2)	sys##Fn,
#define _JDK_API3(Rt, Fn, a1, a2, a3)	sys##Fn,
#define _JDK_API4(Rt, Fn, a1, a2, a3, a4)	sys##Fn,
#define _JDK_API5(Rt, Fn, a1, a2, a3, a4, a5)	sys##Fn,
#define _JDK_API6(Rt, Fn, a1, a2, a3, a4, a5, a6)	sys##Fn,
#define _JDK_API7(Rt, Fn, a1, a2, a3, a4, a5, a6, a7)	sys##Fn,
#define _JDK_API8(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8)	sys##Fn,
#define _JDK_API9(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9)	sys##Fn,
#define _JDK_API10(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)	sys##Fn,
#define _JDK_API11(Rt, Fn, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)	sys##Fn,
#define _JDK_EXT_
#include <anakin/_traps.h>
};
