# Make rules for Thumb OS
#
#{{IS_NOTE
#
# Authors:	Tom M. Yeh
# Contributors:
# Create Date:	5/26/0 05:19PM
# $Header: /cvsroot/jedi/Rules.make,v 1.21 2000/10/06 04:44:19 henrichen Exp $
# Purpose:	Make rules for Thumb OS
# Description:
#	To append extra options, set $(EXTRA_CFLAGS), $(EXTRA_INCDIRS), $(EXTRA_ASFLAGS)...
#	To override the default options, set $(CFLAGS), $(INCDIRS), $(ASFLAGS)...
#
#	Note: INCDIRS and EXTRA_INCDIRS is a list of directories separted by space.
#
#}}IS_NOTE
#
# Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.
#
#{{IS_RIGHT
#}}IS_RIGHT
#

#/////////////////////////////////////////////////
#PATH; We update PATH here since it is not easy to pass PATH to sub-make
ifeq ($(__OSL__),__WinCE__)
_WCEROOT_UNIX := $(shell cygpath -u "$(WCEROOT)")
PATH := $(_WCEROOT_UNIX)/COMMON/EVC/bin:$(_WCEROOT_UNIX)/EVC/$(OSVERSION)/bin:$(PATH)
endif

#/////////////////////////////////////////////////
# False targets
.PHONY: all any_err build_subdirs clean clean_subdirs first_rule test upd_objlist

#/////////////////////////////////////////////////
# Create O_LIST if O_LIST is not specified
ifndef O_LIST
O_LIST := $(patsubst %.cxx,%.$(OEXT),$(wildcard *.cxx))
O_LIST += $(patsubst %.c,%.$(OEXT),$(wildcard *.c))
O_LIST += $(patsubst %.S,%.$(OEXT),$(wildcard *.S))
O_LIST += $(patsubst %.s,%.$(OEXT),$(wildcard *.s))
O_LIST += $(patsubst %.rc,%.res,$(wildcard *.rc))
endif

ifeq ($(O_LIST),_dummy_)
O_LIST :=
endif

ifndef C_LIST
C_LIST = $(B_TARGET) $(B_TARGET2) $(B_TARGET3) $(B_TARGET4) $(B_TARGET5) $(O_LIST) $(C_LIST_EXTRA)
endif

#/////////////////////////////////////////////////
# flags
ifndef CFLAGS
 ifeq ($(__OSL__),__WinCE__)
  CFLAGS := -nologo -W4 -GF -GR- -GX- -Gy
 else
  CFLAGS := -Wall -Wpointer-arith -Wstrict-prototypes -Winline -Wundef \
	-Waggregate-return -Wunknown-pragmas -Woverloaded-virtual -Wno-aggregate-return \
	-O2 \
	-fno-rtti -fno-exceptions -finit-priority -fno-implement-inlines \
	-fno-implicit-templates -fcheck-new -fnonnull-objects \
	-fno-for-scope
 endif #__WinCE__
endif

INCDIRS += $(TOPDIR)/include $(TOPDIR)/include$(__OSL__) $(TOPDIR)/include$(__PLATFORM__)

ifeq ($(__OSL__),__WinCE__)

 _MACRO_LIST_ := $(PRE_MACRO_LIST) STRICT WIN32 WIN32_PLATFORM_PSPC _WIN32_WCE_PSPC UNICODE _UNICODE

 ifdef NDEBUG
  _MACRO_LIST_ += NDEBUG
  _INTRN_CFLAGS_ := -O1 -Ob1 -Oy -Gz
 else
  _MACRO_LIST_ += DEBUG _DEBUG
  _INTRN_CFLAGS_ := -Zi -Od -Oy- -Gz
 endif

 _MACRO_LIST_ += UNDER_CE=$(CEVersion) _WIN32_WCE=$(CEVersion)
 ifdef _WIN32_WCE_EMULATION
  _MACRO_LIST_ += _WIN32_WCE_EMULATION
 endif

 ifneq ($(__PLATFORM__),__i486__)
  _INTRN_CFLAGS_ += -MC
 endif

 RCFLAGS := $(PRE_RCFLAGS) $(addprefix -D,$(_MACRO_LIST_)) -r
 _INTRN_CFLAGS_ += $(addprefix -D,$(_MACRO_LIST_))

else #__WinCE__

 ifdef NDEBUG
  _INTRN_CFLAGS_ := -DNDEBUG -fconserve-space
 else
  _INTRN_CFLAGS_ := -D_DEBUG -g
 endif

 ifeq ($(__OSL__),__eCos__)
  _INTRN_CFLAGS_ += -I/ecosroot/jedi/tos_install/include
 endif

 # Does not address CPU_CFLAGS
 ifeq ($(__OSL__),__RTEMS__)
  _INTRN_CFLAGS_ += $(shell make -s --no-print-directory -f $(TOPDIR)/Makefile.rtems print_cflags)
 endif

endif #__WinCE__

ifdef __LITTLE_ENDIAN__
_INTRN_CFLAGS_ += -D__LITTLE_ENDIAN__=$(__LITTLE_ENDIAN__)
else
_INTRN_CFLAGS_ += -D__BIG_ENDIAN__=$(__BIG_ENDIAN__)
endif

_INCDIRALL_ = $(INCDIRS) $(EXTRA_INCDIRS)

ifeq ($(__OSL__),__WinCE__)
_INTRN_INCDIRS_ = $(foreach dir,$(_INCDIRALL_),-I$(subst \,/,$(shell cygpath -w $(dir))))
else
_INTRN_INCDIRS_ = $(foreach dir,$(_INCDIRALL_),-I$(dir))
endif

_INTRN_CFLAGS_ += -D$(__OSL__)=1 -D$(__API__)=1 -D$(__PLATFORM__)=1 -DBUILD_JEDI

_TOTAL_CFLAGS_ = $(_INTRN_CFLAGS_) $(CFLAGS) $(EXTRA_CFLAGS) $(_INTRN_INCDIRS_)

# The first target
all: any_err $(BUILD_BEFORE) build_subdirs $(O_LIST) $(B_TARGET) $(B_TARGET2) $(B_TARGET3) $(B_TARGET4) $(B_TARGET5) upd_objlist $(BUILD_AFTER)

# any_err
ifdef ERROR_MESSAGE
any_err :
	@echo Error: '$(ERROR_MESSAGE)'
	@exit 2
else
any_err :
endif

# add O_LIST_IMAGE to a file if NO_ADD_O_LIST is not defined
ifndef O_LIST_IMAGE
O_LIST_IMAGE := $(O_LIST)
endif
ifeq (,$(strip $(O_LIST_IMAGE)))
O_LIST_IMAGE := _dummy_
endif

ifeq ($(O_LIST_IMAGE),_dummy_)
upd_objlist :
else
ifeq ($(__OSL__),__WinCE__)
upd_objlist :
	@echo $(foreach flnm,$(addprefix $(shell pwd)/,$(O_LIST_IMAGE)),$(subst \,/,$(shell cygpath -w $(flnm)))) >> $(_OBJLIST_)
else
upd_objlist :
	@echo $(addprefix $(shell pwd)/,$(O_LIST_IMAGE)) >> $(_OBJLIST_)
endif
endif

# Other targets
clean : $(CLEAN_BEFORE) clean_subdirs $(CLEAN_AFTER)
	@rm -f core $(C_LIST)

build_subdirs: $(patsubst %,build_%,$(SUBDIRS))

clean_subdirs: $(patsubst %,clean_%,$(SUBDIRS))

ifdef SUBDIRS
$(patsubst %,build_%,$(SUBDIRS)) : $(VERSION_H)
	if [ -f $(patsubst build_%,%,$@)/Makefile ]; then $(MAKE) -C $(patsubst build_%,%,$@) ; \
	else $(MAKE) -f $(TOPDIR)/Rules.make -C $(patsubst build_%,%,$@) ; fi

$(patsubst %,clean_%,$(SUBDIRS)) :
	if [ -f $(patsubst clean_%,%,$@)/Makefile ]; then $(MAKE) -C $(patsubst clean_%,%,$@) clean ; \
	else $(MAKE) -f $(TOPDIR)/Rules.make -C $(patsubst clean_%,%,$@) clean ; fi
endif

# Pattern rules
ifeq ($(__OSL__),__WinCE__)
_INTRN_DIR := $(subst \,/,$(shell cygpath -w $(TOPDIR)/test))
_SPECIAL_FILES := -Fd$(_INTRN_DIR)/
 #ifndef NDEBUG
 #_PRECOMPILE := -Fp$(_INTRN_DIR)/vc60.pch -YXjedi/kernel.h
 #endif

%.s: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fa$@ $(_SPECIAL_FILES)

%.i: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -P $<

%.$(OEXT): %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fo$@ $(_SPECIAL_FILES)

%.s: %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fa$@ $(_SPECIAL_FILES)

%.$(OEXT): %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fo$@ $(_SPECIAL_FILES) $(_PRECOMPILE)

else
%.s: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -S $< -o $@

%.i: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -E $< > $@

%.$(OEXT): %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -o $@

%.s: %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -S $< -o $@

%.i: %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -E $< > $@

%.$(OEXT): %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -o $@

%.$(OEXT): %.s
	$(AS) $(ASFLAGS) $(EXTRA_ASFLAGS) -o $@ $<

%.$(OEXT): %.S
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -o $@
endif

%.res: %.rc
	$(RC) $(RCFLAGS) $(EXTRA_RCFLAGS) -fo$@ $<
