# Platform.make
#
#{{IS_NOTE
#
# Authors:	Tom M. Yeh
# Contributors:
# Create Date:	7/28/0 10:05AM
# $Header: /cvsroot/jedi/Platform.make,v 1.9 2000/10/12 03:07:30 tomyeh Exp $
# Purpose:	Platform dependent part of Makefile
# Description:
#	You don't need to modify Makefile to compile for different platforms.
#	Rather, you modify this file. In the future, this file will be
#	generated by another script
#
#}}IS_NOTE
#
# Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.
#
#{{IS_RIGHT
#}}IS_RIGHT
#

#/////////////////////////////////////////////////
#export NDEBUG := 1
#Define NDEBUG when it is time to make a commercial version

#/////////////////////////////////////////////////
export __OSL__ := __RTEMS__
	#__RTEMS__: RTEMS real-time operating system
#export __OSL__ := __WinCE__
	#__WinCE__: Windows/CE
#export __OSL__ := __tvm__
	#__tvm__: Thumb Virtual Machine
#export __OSL__ := __eCos__
	#__eCos__: eCos kernel

#/////////////////////////////////////////////////
export __API__ := __Palm__
	#__Palm__: Palm API

#/////////////////////////////////////////////////
export __PLATFORM__ := __RTEMS__
	# __i486__: Intel i486 or above
	# __ARM__: ARM
	# __RTEMS__: interestingly RTEMS provides portable versions of CPU code

#/////////////////////////////////////////////////
ifeq ($(__OSL__),__RTEMS_)
# be smart -- figure this one out on the fly :)
ifeq ($(shell make -s --no-print-directory -f Makefile.rtems is_big_endian,FALSE)
export __LITTLE_ENDIAN__ := 1234
else
export __BIG_ENDIAN__ := 4321
endif #figure out endian
else
export __LITTLE_ENDIAN__ := 1234
#export __BIG_ENDIAN__ := 4321
endif #__RTEMS__
	#select one of the endian

#/////////////////////////////////////////////////
ifeq ($(__OSL__),__WinCE__)
 export PRE_RCFLAGS := -l 0x409
	# language of RC
	#english=0x409

 export CEVER_MAJOR=3
 export CEVER_MINOR=00
 export PLATFORM:=MS Pocket Pc
endif #__WinCE__

ifeq ($(__OSL__),__RTEMS_)
 export PRE_RCFLAGS := -l 0x409
	# language of RC
	#english=0x409

 export CEVER_MAJOR=3
 export CEVER_MINOR=00
 export PLATFORM:=RTEMS
endif #__RTEMS__
