/*	hello.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:	Henri Chen
	Create Date:	8/8/0 07:30PM
	$Header: /cvsroot/jdk/samples/starter/starter.cxx,v 1.2 2000/10/12 08:23:00 henrichen Exp $
	Purpose:	Hello World for Palm
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <PalmOS.h>
#include "resource.h"

static Err AppStart(void)
{
	return 0;
}

static void AppStop(void)
{
	FrmCloseAllForms();
}

#define	NUM_DEMO	4
static int g_demo= 2;	//demo code
static Coord g_w=100, g_h=100;
static Coord oldx= 0, oldy= 0, xInc= 1, yInc= 1;
static Int16 g_head= 0, g_tail= 15;
static PointType g_pts[16];

static Boolean ChangeDemo(Coord x, Coord y)
{
	Boolean handled = false;

	g_demo= (g_demo+1) % NUM_DEMO;
	WinEraseWindow();
	oldx= x; oldy= y;
	g_head= 0; g_tail= 15;
	g_pts[0].x= x; g_pts[0].y= y;
	return handled = true;
}

static int RandNum(int max)
{
	return (SysRandom(0)*max)/(sysRandomMax+1);
}

static void RandXY(Coord *x, Coord *y)
{
	*x= (Coord)RandNum(g_w);
	*y= (Coord)RandNum(g_h);
}


static void Demo(void)
{
	switch(g_demo) {
	case 0:
		{
		Coord x, y;
		Char str[]= "Hello Jedi!";
		Int16 w= FntCharsWidth(str, StrLen(str));
		Int16 h= FntCharHeight();
		RectangleType rect={{oldx, oldy},{w,h}};
		WinEraseRectangle(&rect, 0);
		x= oldx+ xInc;
		y= oldy+ yInc;
		if (x <= 0) {
			IndexedColorType clr= WinSetTextColor(0) + 1;
			if (clr == 0) clr++;
			else if ( clr >= (1 << WinGetBitmap(WinGetDrawWindow())->pixelSize) || clr >= 0xE6) clr= 1;
			WinSetTextColor(clr);
			xInc= (Coord)(RandNum(4)+1);
		}
		else if ((x+w) >= g_w) {
			xInc= (Coord)(-RandNum(4)-1);
		}
			
		if (y <= 0) {
			yInc= (Coord)(RandNum(4)+1);
		}
		else if ((y+h) >= g_h) {
			yInc= (Coord)(-RandNum(4)-1);
		}
			
		WinDrawChars(str, StrLen(str), x, y);
		oldx= x;
		oldy= y;
		}
		break;
	case 1:
		{
		Coord x, y;
		x= oldx+ xInc;
		y= oldy+ yInc;

		if (((g_head+1)%16) == g_tail) {
			WinEraseLine(g_pts[g_tail%16].x, g_pts[g_tail%16].y, g_pts[(g_tail+1)%16].x, g_pts[(g_tail+1)%16].y);
			g_tail= (g_tail+1) % 16;
		}

		g_head= (g_head+1) % 16;
		
		g_pts[g_head].x= x;
		g_pts[g_head].y= y;
		
		if (x <= 0) {
			IndexedColorType clr= WinSetForeColor(0) + 1;
			if (clr == 0) clr++;
			else if ( clr >= (1 << WinGetBitmap(WinGetDrawWindow())->pixelSize) || clr >= 0xE6) clr= 1;
			WinSetForeColor(clr);
			xInc= (Coord)(RandNum(4)+3);
		}
		else if (x >= g_w) {
			xInc= (Coord)(-RandNum(4)-3);
		}
			
		if (y <= 0) {
			yInc= (Coord)(RandNum(4)+3);
		}
		else if (y >= g_h) {
			yInc= (Coord)(-RandNum(4)-3);
		}
			
		WinDrawLine(oldx, oldy, x, y);
		oldx= x;
		oldy= y;
		}
		break;
	case 2:
		{
		Coord w= (Coord)((SysRandom(0)*g_w)/(sysRandomMax+1)+4);
		Coord h= (Coord)((SysRandom(0)*g_h)/(sysRandomMax+1)+4);
		RectangleType r={{oldx, oldy}, {w,h}};
		UInt16 radius= (UInt16)((SysRandom(0)*8)/(sysRandomMax+1));
		IndexedColorType clr= WinSetForeColor(0) + 1;
		if ( clr >= (1 << WinGetBitmap(WinGetDrawWindow())->pixelSize) || clr >= 0xE6) clr= 0;
		WinSetForeColor(clr);
		WinDrawRectangle(&r, radius);
		RandXY(&oldx, &oldy);
		}
		break;
	case 3:
		{
		Coord x, y;
		RandXY(&x, &y);
		IndexedColorType clr= WinSetForeColor(0) + 1;
		if ( clr >= (1 << WinGetBitmap(WinGetDrawWindow())->pixelSize) || clr >= 0xE6) clr= 0;
		WinSetForeColor(clr);
		WinDrawLine(oldx, oldy, x, y);
		RandXY(&oldx, &oldy);
		}
		break;
	}
}

static Boolean AppHandleEvent(EventType* pEvent)
{
   Boolean handled = false;
   FormPtr pFrm;

   switch (pEvent->eType){
   	case penUpEvent:	//as long as pen up
   	{
   		Coord x= pEvent->screenX;
   		Coord y= pEvent->screenY;
   		WinDisplayToWindowPt(&x, &y);
   		handled= ChangeDemo(x, y);
   		break;
   	}
   		
	case menuEvent:
//		handled= MainFormDoCommand(pEvent->data.menu.itemID);
		break;

	case frmLoadEvent:
		pFrm= FrmInitForm(pEvent->data.frmLoad.formID);
		FrmSetActiveForm(pFrm);
		handled= true;
		break;
		
	case frmOpenEvent:
		pFrm = FrmGetActiveForm();
//		MainFormInit(pFrm);
		FrmDrawForm(pFrm);
		{
			RectangleType r;
			UInt16 err;
			Int16 fntHeight= FntCharHeight();
			WinHandle wh, g_wh;
			WinGetWindowBounds(&r);
			r.topLeft.y+= fntHeight + 4;
			r.extent.y-=  fntHeight + 4;
			wh= WinCreateWindow (&r, 0, 0, 0, &err);
			g_wh= WinSetDrawWindow(wh);
			WinGetWindowExtent(&g_w, &g_h);
		}
		handled = true;
		break;
	default:
		Demo();
		handled= true;
	}		
	return handled;
}

static void AppEventLoop(void)
{
	EventType event;

	do{
		EvtGetEvent(&event, 5);	//evtWaitForever

		if(!SysHandleEvent(&event))
			if(!MenuHandleEvent(0, &event, 0))
				if(!AppHandleEvent(&event))
					FrmDispatchEvent(&event);

	}while(event.eType != appStopEvent);
}

EXTERN_C UInt32 PilotMain(UInt16 cmd, MemPtr /*cmdPBP*/, UInt16 /*launchFlags*/)
{
	Err err = 0;
	switch(cmd){
	case sysAppLaunchCmdNormalLaunch:
		err = AppStart();
		if(!err){
			FrmGotoForm(IDF_MAIN);
			AppEventLoop();
			AppStop();
		}
		break;
	}

	return err;
}
