/*	hello.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:	Henri Chen
	Create Date:	8/8/0 07:30PM
	$Header: /cvsroot/jdk/samples/hello/hello.cxx,v 1.14 2000/10/12 08:27:02 tomyeh Exp $
	Purpose:	Hello World for Palm
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <PalmOS.h>
#include "resource.h"

static Err AppStart(void)
{
	return 0;
}

static void AppStop(void)
{
	FrmCloseAllForms();
}

static Boolean MainFormHandleEvent(EventType *pEvent)
{
	Boolean handled = false;
	FormPtr pFrm;

	switch (pEvent->eType){
	case penUpEvent:
		pFrm = FrmGetActiveForm();
		Char *str= "Click";
		WinDrawChars(str, StrLen(str),
				pEvent->data.penUp.start.x, pEvent->data.penUp.start.y);
		handled = true;
		break;
	}
	return handled;
}

static Coord g_w, g_h;
static Boolean AppHandleEvent(EventType *pEvent)
{
   Boolean handled = false;
   FormPtr pFrm;

   switch (pEvent->eType){
	case menuEvent:
//		return MainFormDoCommand(pEvent->data.menu.itemID);
		break;

	case frmLoadEvent:
		pFrm= FrmInitForm(pEvent->data.frmLoad.formID);
		FrmSetActiveForm(pFrm);
		if(pEvent->data.frmLoad.formID == IDF_MAIN)
			FrmSetEventHandler(pFrm, MainFormHandleEvent);
		handled= true;
		break;
		
	case frmOpenEvent:
		pFrm = FrmGetActiveForm();
//		MainFormInit(pFrm);
		FrmDrawForm(pFrm);
		WinGetDisplayExtent(&g_w, &g_h);
		{
		Char str[]= "Hello Jedi!";
		Int16 w= FntCharsWidth(str, StrLen(str));
		WinDrawChars(str, StrLen(str), (g_w-w)/2, g_h/2);
		}
		handled = true;
		break;
	}
	
	return handled;
}

static void AppEventLoop(void)
{
	EventType event;

	do{
		EvtGetEvent(&event, evtWaitForever);

		if(!SysHandleEvent(&event))
			if(!MenuHandleEvent(0, &event, 0))
				if(!AppHandleEvent(&event))
					FrmDispatchEvent(&event);

	}while(event.eType != appStopEvent);
}

EXTERN_C UInt32 PilotMain(UInt16 cmd, MemPtr /*cmdPBP*/, UInt16 /*launchFlags*/)
{
	Err err = 0;
	switch(cmd){
	case sysAppLaunchCmdNormalLaunch:
		err = AppStart();
		if(!err){
			FrmGotoForm(IDF_MAIN);
			AppEventLoop();
			AppStop();
		}
		break;
	}

	return err;
}
