/*	defs.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/9/0 04:27PM
	$Header: /cvsroot/jdk/include/jdk/defs.h,v 1.5 2000/08/30 07:50:50 tomyeh Exp $
	Purpose:	Basic definitions used by Jedi Development Kit (JDK)
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jdk_defs_H
#define _is_jdk_defs_H

///////////////////////////////////////////
#if defined(DEBUG) && !defined(_DEBUG)
#define _DEBUG
#endif
#if !defined(_DEBUG) && !defined(NDEBUG)
#define NDEBUG
#endif

#ifdef __cplusplus
#ifndef EXTERN_C
#define	EXTERN_C			extern "C"
#endif

#define EXTERN_C_BEGIN		extern "C" {
#define EXTERN_C_END		}

#define DEFAULTVAL(defval)	=defval

#else //__cplusplus
#ifndef EXTERN_C
#define EXTERN_C
#endif

#define EXTERN_C_BEGIN
#define EXTERN_C_END

#define DEFAULTVAL(defval)

#endif //__cplusplus


///////////////////////////////////////////
// Compiler dependency
#ifdef __GNUC__

#define _NOVTABLE
#define _STDCALL	__attribute__((stdcall))
#define _CDECL		__attribute__((cdecl))
#define _FASTCALL	_STDCALL
#define _NORETURN	__attribute__((noreturn))
#define _UNUSED		__attribute__((unused))

#define _CDECL_O	_CDECL
#define _CDECL_I
#define _STDCALL_O	_STDCALL
#define _STDCALL_I
	//Note: GNU and VC take different way to represent a function
	//pointer specified with the calling convention. To be compiler
	//dependent, you shall declare it as follows.
	//void _CDECL_O (_CDECL_I*FuncPtr)(int);

#define	__s64_c(v)	v##LL
#define	__u64_c(v)	v##ULL

#else //__GNUC__

#define _NOVTABLE	__declspec(novtable)
#define _STDCALL	__stdcall
#define _CDECL		__cdecl
#define _FASTCALL	__fastcall
#define _NORETURN
#define _UNUSED

#define _CDECL_O
#define _CDECL_I	_CDECL
#define _STDCALL_O
#define _STDCALL_I	_STDCALL

#define	__s64_c(v)	v##L
#define	__u64_c(v)	v##UL

#endif //__GNU__

#define _AAPI		_CDECL
#define _AAPI_O		_CDECL_O
#define _AAPI_I		_CDECL_I

#define _AAPI_P			_AAPI_O (_AAPI_I*)
#define _AAPI_PF(Fn)	_AAPI_O (_AAPI_I* Fn)

#endif //_is_jdk_defs_H
