# Make rules for Thumb OS
#
#{{IS_NOTE
#
# Authors:	Tom M. Yeh
# Contributors:
# Create Date:	5/26/0 05:19PM
# $Header: /cvsroot/jdk/include/Rules.make,v 1.1 2000/10/04 03:31:18 tomyeh Exp $
# Purpose:	Make rules for Thumb OS
# Description:
#	To append extra options, set $(EXTRA_CFLAGS), $(EXTRA_INCDIRS), $(EXTRA_ASFLAGS)...
#	To override the default options, set $(CFLAGS), $(INCDIRS), $(ASFLAGS)...
#
#	Note: INCDIRS and EXTRA_INCDIRS is a list of directories separted by space.
#
#}}IS_NOTE
#
# Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.
#
#{{IS_RIGHT
#}}IS_RIGHT
#

LIB_VER_MAJOR := 1
LIB_VER_MINOR := 0.0
VPATH := $(TOPDIR)/lib

#/////////////////////////////////////////////////
#PATH; We update PATH here since it is not easy to pass PATH to sub-make
ifdef __WinCE__
_WCEROOT_UNIX := $(shell cygpath -u "$(WCEROOT)")
PATH := $(_WCEROOT_UNIX)/COMMON/EVC/bin:$(_WCEROOT_UNIX)/EVC/$(OSVERSION)/bin:$(PATH)
DOT_DLLEXT := .dll
else
DOT_DLLEXT := .so
endif

ifndef OEXT
export OEXT := o
export DOT_OEXT := .$(OEXT)
endif

ifdef B_TARGET
B_TARGET := $(B_TARGET)$(DOT_DLLEXT)
endif

#/////////////////////////////////////////////////
# False targets
.PHONY: all any_err clean first_rule

#/////////////////////////////////////////////////
# Create O_LIST if O_LIST is not specified
ifndef O_LIST
O_LIST := $(patsubst %.cxx,%.$(OEXT),$(wildcard *.cxx))
O_LIST += $(patsubst %.c,%.$(OEXT),$(wildcard *.c))
O_LIST += $(patsubst %.S,%.$(OEXT),$(wildcard *.S))
O_LIST += $(patsubst %.s,%.$(OEXT),$(wildcard *.s))
O_LIST += $(patsubst %.rc,%.res,$(wildcard *.rc))
endif

ifndef C_LIST
C_LIST = $(B_TARGET) $(O_LIST) $(C_LIST_EXTRA) 
endif

ifdef __WinCE__
O_LIST += ce_crt.o
C_LIST += $(patsubst %$(DOT_DLLEXT),%.exp,$(B_TARGET))
C_LIST += $(patsubst %$(DOT_DLLEXT),%.pdb,$(B_TARGET))
C_LIST += $(patsubst %$(DOT_DLLEXT),%.lib,$(B_TARGET))
C_LIST += vc60.pdb
endif

#/////////////////////////////////////////////////
# flags
ifdef __WinCE__ #-------------------------
 export PRE_MACRO_LIST := 
 export LDFLAGS += -nologo -dll commctrl.lib coredll.lib -entry:"_JediMainCRTStartup"
 CeNoDefaultLib_LIST:=libc.lib libcd.lib libcmt.lib libcmtd.lib msvcrt.lib msvcrtd.lib

 ifeq ($(__PLATFORM__),__i486__)
  export _WIN32_WCE_EMULATION := 1
  export COMPILE_APPEND:=
  PRE_MACRO_LIST += _X86_ x86 i486 INTERNATIONAL USA INTLMSG_CODEPAGE
  LIBCPU:=x86em
  JDKLIBNAME:=$(TOPDIR)/lib/jdkx86
  LDFLAGS += corelibc.lib -MACHINE:IX86 -subsystem:windows -windowsce:emulation
  CeNoDefaultLib_LIST += OLDNAMES.lib

 else #__i486__
  LDFLAGS += -subsystem:windowsce,$(CEVER_MAJOR).0

  ifeq ($(__PLATFORM__),__ARM__)
   export COMPILE_APPEND:=arm
   PRE_MACRO_LIST += _M_ARM ARM _ARM_
   LIBCPU:=arm
   JDKLIBNAME:=jdkarm
   LDFLAGS += -align:4096 -MACHINE:ARM
  else
   ERROR_MESSAGE:=$(__PLATFORM__) is not supported yet
  endif
 endif #__PLATFORM__

 ifdef NDEBUG
  LDFLAGS += -RELEASE -OPT:REF -OPT:ICF,10
 else
  LDFLAGS += -DEBUG -PDBTYPE:CON
 endif

 LDFLAGS += -stack:0x10000,0x1000 -incremental:no $(addprefix -nodefaultlib:,$(CeNoDefaultLib_LIST))

 export AR = lib
 export CC = cl$(COMPILE_APPEND)
 export LD = link
 export RC = rc
 export DOT_LIBEXT = .lib

 #set up environment
 ifndef WCEROOT
  ERROR_MESSAGE:=$$WCEROOT, must be defined, e.g., D:/usr/Microsoft eMbedded Tools
 endif
 ifndef SDKROOT
  ERROR_MESSAGE:=$$SDKROOT must be defined, e.g., D:/usr/Windows CE Tools
 endif

 export CEVersion:=$(CEVER_MAJOR)$(CEVER_MINOR)
 export OSVERSION:=wce$(CEVersion)
 export _SDKROOT:=$(subst \,/,$(SDKROOT))
 export INCLUDE:=$(_SDKROOT)/$(OSVERSION)/$(PLATFORM)/include\;$(_SDKROOT)/$(OSVERSION)/$(PLATFORM)/MFC/include\;$(_SDKROOT)/$(OSVERSION)/$(PLATFORM)/ATL/include
 export LIB:=$(_SDKROOT)/$(OSVERSION)/$(PLATFORM)/lib/$(LIBCPU)\;$(_SDKROOT)/$(OSVERSION)/$(PLATFORM)/MFC/lib/$(LIBCPU)\;$(_SDKROOT)/$(OSVERSION)/$(PLATFORM)/ATL/lib/$(LIBCPU)

else #__WinCE__-------------------------
 LDFLAGS += -nostartfiles -shared -Wl,-soname,$(LIB_VER_MAJOR)
 ifeq ($(__PLATFORM__),__i486__)
  export COMPILE_PREFIX:=
  JDKLIBNAME:=jdkx86
 else
 ifeq ($(__PLATFORM__),__ARM__)
  export COMPILE_PREFIX:=arm-elf-
  JDKLIBNAME:=jdkarm
 else
  ERROR_MESSAGE:=$(__PLATFORM__) is not supported yet
 endif
 endif

 export AR = $(COMPILE_PREFIX)ar
 export AS = $(COMPILE_PREFIX)as
 export CC = $(COMPILE_PREFIX)gcc
 export CPP = $(CC) -E
 export GDB = $(COMPILE_PREFIX)gdb
 export LD = $(COMPILE_PREFIX)ld
 #export MAKE = make
 export NM = $(COMPILE_PREFIX)nm
 export OBJCOPY = $(COMPILE_PREFIX)objcopy
 export OBJDUMP = $(COMPILE_PREFIX)objdump
 export STRIP = $(COMPILE_PREFIX)strip
 export RC = rc
 export DOT_LIBEXT = .a

endif #__WinCE__-------------------------

ifndef CFLAGS
 ifdef __WinCE__
  CFLAGS := -nologo -W4 -GF -GR- -GX- -Gy
 else
  CFLAGS := -Wall -Wpointer-arith -Wstrict-prototypes -Winline -Wundef \
	-Waggregate-return -Wunknown-pragmas -Woverloaded-virtual -Wno-aggregate-return \
	-Wno-unknown-pragmas \
	-O2 \
	-fno-rtti -fno-exceptions -finit-priority -fno-implement-inlines \
	-fno-implicit-templates -fcheck-new -fnonnull-objects \
	-fno-for-scope
 endif #__WinCE__
endif

ifndef PALMSDKDIR
PALMSDKDIR:=/tools/palm/sdk-3.5
endif

INCDIRS += $(TOPDIR)/include $(PALMSDKDIR)/include $(PALMSDKDIR)/include/Core $(PALMSDKDIR)/include/Core/System $(PALMSDKDIR)/include/Core/UI $(PALMSDKDIR)/include/Core/Hardware $(PALMSDKDIR)/include/Dynamic $(PALMSDKDIR)/include/Libraries

ifdef __WinCE__

 _MACRO_LIST_ := $(PRE_MACRO_LIST) STRICT WIN32 WIN32_PLATFORM_PSPC _WIN32_WCE_PSPC _USRDLL UNICODE _UNICODE

 ifdef NDEBUG
  _MACRO_LIST_ += NDEBUG
  _INTRN_CFLAGS_ := -O1 -Ob1 -Oy -Gz
 else
  _MACRO_LIST_ += DEBUG _DEBUG
  _INTRN_CFLAGS_ := -Zi -Od -Oy- -Gz
 endif

 _MACRO_LIST_ += UNDER_CE=$(CEVersion) _WIN32_WCE=$(CEVersion)
 ifdef _WIN32_WCE_EMULATION
  _MACRO_LIST_ += _WIN32_WCE_EMULATION
 endif

 ifneq ($(__PLATFORM__),__i486__)
  _INTRN_CFLAGS_ += -MC
 endif

 RCFLAGS := $(PRE_RCFLAGS) $(addprefix -D,$(_MACRO_LIST_)) -r
 _INTRN_CFLAGS_ += $(addprefix -D,$(_MACRO_LIST_))

else #__WinCE__

 ifdef NDEBUG
  _INTRN_CFLAGS_ := -DNDEBUG -fconserve-space
 else
  _INTRN_CFLAGS_ := -D_DEBUG -g
 endif

endif #__WinCE__

ifdef __LITTLE_ENDIAN__
_INTRN_CFLAGS_ += -D__LITTLE_ENDIAN__=$(__LITTLE_ENDIAN__)
else
_INTRN_CFLAGS_ += -D__BIG_ENDIAN__=$(__BIG_ENDIAN__)
endif

_INCDIRALL_ = $(INCDIRS) $(EXTRA_INCDIRS)

ifdef __WinCE__
_INTRN_INCDIRS_ = $(foreach dir,$(_INCDIRALL_),-I$(subst \,/,$(shell cygpath -w $(dir))))
else
_INTRN_INCDIRS_ = $(foreach dir,$(_INCDIRALL_),-I$(dir))
endif

_TOTAL_CFLAGS_ = $(_INTRN_CFLAGS_) $(CFLAGS) $(EXTRA_CFLAGS) $(_INTRN_INCDIRS_)

# The first target
all: any_err $(BUILD_BEFORE) $(O_LIST) $(B_TARGET) $(B_TARGET2) $(B_TARGET3) $(B_TARGET4) $(B_TARGET5) $(BUILD_AFTER)

# any_err
any_err :
	@if [ ! -f $(PALMSDKDIR)/include/PalmOs.h ] ; then \
		echo Error: $(PALMSDKDIR)/include/PalmOs.h not found ; \
		echo Palm SDK is assumed to be installed under /tools/palm ; \
		echo You might use ln -s to link to your favorite location ; \
		echo or define PALMSDKDIR in the Makefile ; \
		exit 2 ; \
	fi

# B_TARGET
ifdef __WinCE__
 _LDNAME_ := LINK
 _OUTNAME_ = -OUT:$@
 _LDLIB_ := $(JDKLIBNAME).lib

else #__WinCE__
 _LDNAME_ := $(CXX)
 _OUTNAME_ = -o $@
 _LDLIB_ += -L$(TOPDIR)/lib -l$(JDKLIBNAME)

endif #__WinCE__

ifdef B_TARGET
$(B_TARGET) : $(O_LIST)
	$(_LDNAME_) $(O_LIST) $(_OUTNAME_) $(_LDLIB_) $(LDFLAGS) $(EXTRA_LDFLAGS)
endif

# Other targets
clean : $(CLEAN_BEFORE)
	@rm -f core $(C_LIST)

# Pattern rules
ifdef __WinCE__
%.s: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fa$@

%.i: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -P $<

%.$(OEXT): %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fo$@

%.s: %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fa$@

%.$(OEXT): %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -Fo$@ $(_PRECOMPILE)

else
%.s: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -S $< -o $@

%.i: %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -E $< > $@

%.$(OEXT): %.c
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -o $@

%.s: %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -S $< -o $@

%.i: %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -E $< > $@

%.$(OEXT): %.cxx
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -o $@

%.$(OEXT): %.s
	$(AS) $(ASFLAGS) $(EXTRA_ASFLAGS) -o $@ $<

%.$(OEXT): %.S
	$(CC) $(_TOTAL_CFLAGS_) $(CFLAGS_$@) -c $< -o $@
endif

%.res: %.rc
	$(RC) $(RCFLAGS) $(EXTRA_RCFLAGS) -fo$@ $<
