/*	PalmOS.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/8/0 07:46PM
	$Header: /cvsroot/jdk/include/PalmOS.h,v 1.12 2000/09/07 09:52:30 tomyeh Exp $
	Purpose:	Palm API
	Description:
		Unfortunately, we cannot use Palm's header directly because:
		1) enum is 32-bit for most compiler but Palm expects 16-bit.
		2) Palm uses a lot of bit field which is endian-dependent.
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef __PALMOS_H__
#define __PALMOS_H__

#define _JDK			1 //Enumerate as short int, ...

#define _JDK_REN(Type)		_##Type
#define _JDK_ENUM(Type)		_JDK_REN(Type); typedef Int16 Type
			//used to define a name of a enum type

#ifdef __BIG_ENDIAN__
#define _JDK_BE			1
#define _JDK_BF2(a1, a2)	a1, a2
#define _JDK_BF3(a1, a2, a3)	a1, a2, a3
#define _JDK_BF4(a1, a2, a3, a4)	a1, a2, a3, a4
#define _JDK_BF5(a1, a2, a3, a4, a5)	a1, a2, a3, a4, a5
#define _JDK_BF6(a1, a2, a3, a4, a5, a6)	a1, a2, a3, a4, a5, a6
#define _JDK_BF7(a1, a2, a3, a4, a5, a6, a7)	a1, a2, a3, a4, a5, a6, a7
#define _JDK_BF8(a1, a2, a3, a4, a5, a6, a7, a8)	a1, a2, a3, a4, a5, a6, a7, a8
#define _JDK_BF9(a1, a2, a3, a4, a5, a6, a7, a8, a9)	a1, a2, a3, a4, a5, a6, a7, a8, a9
#define _JDK_BF10(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa)	a1, a2, a3, a4, a5, a6, a7, a8, a9, aa

#else //__BIG_ENDIAN__

#define _JDK_LE			1 //Little Endian
#define _JDK_BF2(a1, a2)	a2, a1
#define _JDK_BF3(a1, a2, a3)	a3, a2, a1
#define _JDK_BF4(a1, a2, a3, a4)	a4, a3, a2, a1
#define _JDK_BF5(a1, a2, a3, a4, a5)	a5, a4, a3, a2, a1
#define _JDK_BF6(a1, a2, a3, a4, a5, a6)	a6, a5, a4, a3, a2, a1
#define _JDK_BF7(a1, a2, a3, a4, a5, a6, a7)	a7, a6, a5, a4, a3, a2, a1
#define _JDK_BF8(a1, a2, a3, a4, a5, a6, a7, a8)	a8, a7, a6, a5, a4, a3, a2, a1
#define _JDK_BF9(a1, a2, a3, a4, a5, a6, a7, a8, a9)	a9, a8, a7, a6, a5, a4, a3, a2, a1
#define _JDK_BF10(a1, a2, a3, a4, a5, a6, a7, a8, a9, aa)	aa, a9, a8, a7, a6, a5, a4, a3, a2, a1
			//used to convert Palm Bit Field to little endian
#endif //__BIG_ENDIAN__

#define EMULATION_LEVEL		EMULATION_NONE //compatible with final version
#define DISABLE_HAL_TRAPS	1	//disable HAL_CALL
#define USE_TRAPS			0	//disable SYS_TRAP
#define _DEBUGGER_TRAP			//disable DbgBreak

#ifdef _MSC_VER
#pragma warning(disable: 4068 4514)
	//4514: unreferenced inline function
#endif

#include <PalmTypes.h>
#include <SystemPublic.h>
#include <UIPublic.h>

#ifdef _MSC_VER
#pragma warning(default: 4068)
#endif

#include <jdk/defs.h>
#include <jdk/types.h>
#include <jdk/traps.h>

#endif //__PALMOS_H__
