dnl
dnl $Id: cybertec.m4,v 1.29 2005/08/10 11:53:18 cjohns Exp $
dnl
dnl ------------------------------------------------------------------------
dnl
dnl My Right Boot, a boot ROM for embedded hardware.
dnl
dnl ------------------------------------------------------------------------
dnl
dnl Copyright (c) 2002, Cybertec Pty Ltd.
dnl All rights reserved.
dnl
dnl                       LICENSE INFORMATION
dnl
dnl My Right Boot is free software; you can redistribute it and/or modify it
dnl under terms of the GNU General Public License as published by the Free
dnl Software Foundation; either version 2, or (at your option) any later
dnl version.
dnl
dnl My Right Boot is distributed in the hope that it will be useful, but
dnl WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
dnl or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
dnl for more details. You should have received a copy of the GNU General
dnl Public License along with My Right Boot; see file COPYING. If not, write
dnl to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl As a special exception, including a My Right Boot header files in a file,
dnl instantiating My Right Boot generics or templates, or linking other files
dnl with My Right Boot objects to produce an executable application, does not
dnl by itself cause the resulting executable application to be covered by the
dnl GNU General Public License. This exception does not however invalidate any
dnl other reasons why the executable file might be covered by the GNU Public
dnl License.
dnl
dnl The Cybertec copyright and license notice must remain in this file and any
dnl derived file.
dnl
dnl ------------------------------------------------------------------------
dnl
dnl Cybertec Autoconf and Automake support for embedded development.
dnl

dnl
dnl CT_PATH_MUNCH(IN, OUT)
dnl

AC_DEFUN([CT_PATH_MUNCH],
[
  case $host in
    *-*-msdos* | *-*-go32* | *-*-mingw32* | *-*-windows*)
      $2=$(winpath -f $1)
    ;;
    *)
      $2=$1
    ;;
  esac
])

dnl
dnl CT_PREFIX
dnl

AC_DEFUN([CT_PREFIX],
[
  dnl
  dnl If the prefix is NONE set it.
  dnl
  AS_IF([test x"${prefix}" = x"NONE"], 
        [case $target in
           *-rtems) prefix=/opt/rtems ;;
           *)       prefix=/usr ;;
         esac])
])

dnl
dnl CT_TOP_LEVEL
dnl

AC_DEFUN([CT_TOP_LEVEL],
[
  dnl
  dnl Do not support a Canadian cross.
  dnl
  AS_IF([test $host != $build],
        [AC_MSG_ERROR([Canadian cross is not supported.]
         [Check your \"--host\" and \"--build\" options.])],
        )

  dnl
  dnl Must build in a separate tree to the source.
  dnl
  AC_MSG_CHECKING([that a separate build tree is being used])
  ac_tmp_cwd=`/bin/pwd`
  AS_IF([test "${srcdir} = "."],
        [srcdir=${ac_tmp_cwd}],
        )
  AS_IF([test "${ac_tmp_cwd} = "${srcdir}"],
        [AC_MSG_RESULT([no])
         AC_MSG_ERROR([This configure script should not be run inside the source tree.]
                      [Instead please use a separate build tree])],
        [AC_MSG_RESULT([yes])])
  export topdir=$srcdir
])

dnl
dnl CT_SRC_TOP(TOPDIR, SRCDIR, TOP)
dnl

AC_DEFUN([CT_SRC_TOP],
[
  dnl
  dnl Isolate the leading ../ that are added to nested configure.in's.
  dnl
  $3=`echo $2 | sed -e "s%$topdir.*%%"`$1
])

dnl
dnl CT_CHECK_TOOL(VARIABLE, PROG-TO-CHECK-FOR [,VALUE-IF-NOT-FOUND [, PATH]])
dnl

AC_DEFUN([CT_CHECK_TOOL],
[
  AC_REQUIRE([CT_PREFIX])

  dnl
  dnl The setting of cross_compiling is here as I cannot seem to figure why it
  dnl is not set by autoconf. I have found the host_alias and build_alias field
  dnl are not set. As a result cross_compiling is also not set.
  dnl
  AS_IF([test "x$target" != "x$host"],
        [ac_tmp_tool_prefix=${target_alias}-
         cross_compiling=yes])
  AC_CHECK_PROG($1, ${ac_tmp_tool_prefix}$2, ${ac_tmp_tool_prefix}$2, $3, $4)
])

dnl
dnl CT_CANONICALIZE_TOOLS
dnl

AC_DEFUN([CT_CANONICALIZE_TOOLS],
[
  AC_REQUIRE([CT_PREFIX])
  AC_REQUIRE([CT_PROG_CC])

  dnl
  dnl FIXME: What shall be done if these tools are not available?
  dnl
  CT_CHECK_TOOL(AR, ar, no)
  CT_CHECK_TOOL(AS, as, no)
  CT_CHECK_TOOL(LD, ld, no)
  CT_CHECK_TOOL(NM, nm, no)

  dnl
  dnl special treatment of ranlib
  dnl
  CT_CHECK_TOOL(RANLIB, ranlib, :)

  dnl
  dnl NOTE: These may not be available if not using gnutools
  dnl
  CT_CHECK_TOOL(OBJCOPY, objcopy, no)
  CT_CHECK_TOOL(SIZE, size, no)
  CT_CHECK_TOOL(STRIP, strip, :)
])

dnl
dnl CT_PROG_CXX
dnl

AC_DEFUN([CT_PROG_CXX],
[
  AC_BEFORE([$0], [AC_PROG_CXX])
  AC_BEFORE([$0], [CT_CANONICALIZE_TOOLS])

  CT_CHECK_TOOL(CXX, g++)
  test -z "$CXX" && AC_MSG_ERROR([no acceptable CXX found in \$PATH])

  AC_PROG_CXX
])

dnl
dnl CT_PROG_CC
dnl

AC_DEFUN([CT_PROG_CC],
[
  AC_BEFORE([$0], [AC_PROG_AS])
  AC_BEFORE([$0], [AC_PROG_CPP])
  AC_BEFORE([$0], [AC_PROG_CC])
  AC_BEFORE([$0], [CT_CANONICALIZE_TOOLS])

  CT_CHECK_TOOL(CC, gcc)
  test -z "$CC" && AC_MSG_ERROR([no acceptable cc found in \$PATH])

  CT_CHECK_TOOL(LD, ld)
  test -z "$LD" && AC_MSG_ERROR([no acceptable LD found in \$PATH])

  AC_SUBST(LD, $LD)

  AC_PROG_CC
  AC_PROG_CPP
  AM_PROG_AS
])

dnl
dnl CT_PROG_CC_FOR_TARGET
dnl

AC_DEFUN([CT_PROG_CC_FOR_TARGET],
[
  dnl
  dnl Check target cc.
  dnl
  CT_PROG_CC
])

dnl
dnl CT_PROG_CXX_FOR_TARGET
dnl

AC_DEFUN([CT_PROG_CXX_FOR_TARGET],
[
  dnl
  dnl Check target cc and cxx.
  dnl
  CT_PROG_CXX
])

dnl
dnl CT_ENABLE_DEBUG
dnl

AC_DEFUN([CT_ENABLE_DEBUG],
[
  AC_REQUIRE([CT_PREFIX])

  AC_MSG_CHECKING([for debugging])
  AC_ARG_ENABLE(debug,
                AC_HELP_STRING([--enable-debug],
                               [specify a debug build where code is loaded into RAM]),
                [case "${enableval}" in
                  yes) debug=true ;;
                   no) debug=false ;;
                    *) AC_MSG_ERROR([invalid]
                                    [bad value ${enableval} for --enable-debug]) ;;
                 esac],
                [debug=false])
  AM_CONDITIONAL(DEBUG, test x$debug = xtrue)
  AS_IF([test x$debug = xtrue], AC_MSG_RESULT(yes), AC_MSG_RESULT(no))
])

dnl
dnl CT_ENABLE_VARIANT
dnl

AC_DEFUN([CT_ENABLE_VARIANT],
[
  AC_REQUIRE([CT_PREFIX])

  AC_MSG_CHECKING([for variant])
  AC_ARG_ENABLE(variant,
                AC_HELP_STRING([--enable-variant],
                               [specify a build variant is the target supports it]),
                [case "${enableval}" in
                   no) ;;
                    *) variant="${enableval}" ;;
                 esac])
  AM_CONDITIONAL(VARIANT, test ! x$variant = x)
  AS_IF([test ! x$variant = x],
        [AC_SUBST(VARIANT_LABEL, $variant)
         AC_MSG_RESULT($variant)],
        AC_MSG_RESULT(default variant))
])

dnl
dnl CT_ENABLE_RTEMS_CPU(CPU)
dnl

AC_DEFUN([CT_ENABLE_RTEMS_CPU],
[
  AC_REQUIRE([CT_PREFIX])

  AC_MSG_CHECKING([for RTEMS CPU])
  AC_ARG_ENABLE(rtems-cpu,
                AC_HELP_STRING([--enable-rtems-cpu],
                               [specify the RTEMS CPU]),
                [rtems_cpu=${enableval}],
                [rtems_cpu=$1
                 ac_configure_args="$ac_configure_args --enable-rtems-cpu=$rtems_cpu"])

  AC_SUBST(CPU, ${rtems_cpu})

  AC_MSG_RESULT([$rtems_cpu])
])

dnl
dnl CT_ENABLE_RTEMS(BSP/CPU)
dnl

AC_DEFUN([CT_ENABLE_RTEMS],
[
  AC_REQUIRE([CT_PREFIX])
  AC_REQUIRE([CT_ENABLE_RTEMS_CPU])

  AC_MSG_CHECKING([for RTEMS ($rtems_cpu)])
  AC_ARG_ENABLE(rtems,
                AC_HELP_STRING([--enable-rtems],
                               [specify the path to RTEMS]),
                [rtems=${enableval}],
                [rtems=${prefix}
                 ac_configure_args="$ac_configure_args --enable-rtems=$rtems"])

  dnl
  dnl Just check is a file is present. First look for a
  dnl 4.5.0 type structure.
  dnl

  AS_IF([test -f ${rtems}/m$rtems_cpu/lib/librtemsall.a],
        [ac_tmp_found=yes
         rtems_inc_path=${rtems}/m$rtems_cpu/lib/include
         rtems_lib_path=${rtems}/m$rtems_cpu/lib
         rtems_lib=-lrtemsall],
        [AS_IF([test -f ${rtems}/${target_alias}/lib/m$rtems_cpu/librtemscpu.a],
               [ac_tmp_found=yes
                rtems=${rtems}/${target_alias}
                rtems_inc_path=${rtems}/lib/include
                rtems_lib_path=${rtems}/lib/m$rtems_cpu
                rtems_lib="-lrtemscpu"],
               [ac_tmp_found=no])])

  AS_IF([test ! x$ac_tmp_found = xyes],
        [AC_MSG_RESULT(no)
         AC_MSG_ERROR([RTEMS not found])])

  AM_CONDITIONAL(RTEMS, test true)
  AC_SUBST(RTEMS, ${rtems})
  CT_PATH_MUNCH($rtems_inc_path, ac_tmp_var)
  AC_SUBST(RTEMS_INC_PATH, $ac_tmp_var)
  CPPFLAGS="$CPPFLAGS -I $ac_tmp_var"
  CT_PATH_MUNCH($rtems_lib_path, ac_tmp_var)
  AC_SUBST(RTEMS_LIB_PATH, $ac_tmp_var)
  AC_SUBST(RTEMS_LIB, $rtems_lib)

  AC_MSG_RESULT([$rtems_lib_path])
])

dnl
dnl CT_RTEMS_BSP_SETUP(BSP_INC_PATH,
dnl                    BSP_LIB_PATH,
dnl                    BOARD,
dnl                    BSP,
dnl                    BSP_AM,
dnl                    ARG1, ARG2, ARG3, ARG4)
dnl

AC_DEFUN([CT_RTEMS_BSP_SETUP],
[
  AC_MSG_CHECKING([for RTEMS BSP])

  AS_IF([test -d $1],
        [AC_SUBST(BSP_INC_PATH, $1)
         AC_SUBST(BSP_LIB_PATH, $2)
         AC_SUBST(BOARD, $3)
         AC_SUBST(BSP, $4)
         AC_SUBST(BSP_AM, $2/$5)],
        [AC_MSG_RESULT(no)
         AC_MSG_ERROR([RTEMS BSP not found ($1)])])

  AC_MSG_RESULT([$4 ($2/$5)])

  rtems_bsp=$4

  ac_arg=

  AS_IF([test x"$6" = x"yes"],
        [ac_arg="$ac_arg --enable-board=$3"])
  AS_IF([test x"$7" = x"yes"],
        [ac_arg="$ac_arg --enable-bsp=$4"])
  AS_IF([test x"$8" = x"yes"],
        [ac_arg="$ac_arg --enable-bsp-inc-path=$1"])
  AS_IF([test x"$9" = x"yes"],
        [ac_arg="$ac_arg --enable-bsp-lib-path=$2"])

  ac_configure_args="$ac_configure_args $ac_arg"
])

dnl
dnl CT_ENABLE_RTEMS_BSP(BSP, BOARD, DEFAULT)
dnl

AC_DEFUN([CT_ENABLE_RTEMS_BSP],
[
  AC_REQUIRE([CT_PREFIX])
  AC_REQUIRE([CT_ENABLE_VARIANT])

  arg_1=no
  arg_2=no
  arg_3=no
  arg_4=no

  AC_ARG_ENABLE(board,
                AC_HELP_STRING([--enable-board],
                               [specify the board (default is $3)]),
                [case "${enableval}" in
                   no) rtems_board="$3"
                       arg_1=yes ;;
                    *) rtems_board="${enableval}" ;;
                 esac],
                [rtems_board="$3"
                 arg_1=yes])

  $2="$rtems_board"

  AC_ARG_ENABLE(bsp,
                AC_HELP_STRING([--enable-bsp],
                               [specify the BSP]),
                [rtems_bsp=${enableval}],
                [rtems_bsp=$1
                 arg_2=yes])

  rtems_bsp_am=$rtems_board-bsp.am

  AC_ARG_ENABLE(bsp-inc-path,
                AC_HELP_STRING([--enable-bsp-inc-path],
                               [specify the BSP include PATH]),
                [rtems_bsp_inc_path=${enableval}],
                [rtems_bsp_inc_path=${prefix}/include/${rtems_bsp}
                 arg_3=yes])

  AC_ARG_ENABLE(bsp-lib-path,
                AC_HELP_STRING([--enable-bsp-lib-path],
                               [specify the BSP library PATH]),
                [rtems_bsp_lib_path=${enableval}],
                [rtems_bsp_lib_path=${prefix}/lib/${rtems_bsp}
                 arg_4=yes])

  dnl
  dnl The $rtems_bsp_path is either --prefix or user defined.
  dnl
  CT_RTEMS_BSP_SETUP(${rtems_bsp_inc_path},
                     ${rtems_bsp_lib_path},
                     $rtems_board,
                     $rtems_bsp,
                     $rtems_bsp_am,
                     $arg_1, $arg_2, $arg_3, $arg_4)
])

dnl
dnl CT_ENABLE_BOARD(BOARD, DEFAULT)
dnl

AC_DEFUN([CT_ENABLE_BOARD],
[
  AC_REQUIRE([CT_PREFIX])
  AC_REQUIRE([CT_ENABLE_VARIANT])

  AC_MSG_CHECKING([for board])

  arg_1=no

  AC_ARG_ENABLE(board,
                AC_HELP_STRING([--enable-board],
                               [specify the board (default is $2)]),
                [case "${enableval}" in
                   no) rtems_board="$2"
                       arg_1=yes ;;
                    *) rtems_board="${enableval}" ;;
                 esac],
                [rtems_board="$2"
                 arg_1=yes])

  $1="$rtems_board"

  ac_arg=

  AS_IF([test x"$arg_1" = x"yes"],
        [ac_arg="$ac_arg --enable-board=$rtems_board"])

  ac_configure_args="$ac_configure_args $ac_arg"

  AC_MSG_RESULT([$rtems_board])
])

dnl
dnl CT_CONFIG_FILTER(FILE, LABEL_PREFIX, ACTION)
dnl

AC_DEFUN([CT_CONFIG_FILTER],
[
  dnl
  dnl Look for a LABEL_PREFIX* and perform the action on each.
  dnl Remove commented lines that start with a "#". White space should be
  dnl handled but may prove to be fragle.
  dnl
  . $1
  for ac_tmp_opt in \
    `cat $1 | awk "BEGIN { FS=\"=\" } \
       ! /#/ { \
          if (match(\\@S|@0, /$2/)) { print \\@S|@0; } \
       }" | sed -e "s/=.*//g"`
  do
    dnl
    dnl Get the variable name and the value. Re-read from the file as
    dnl the for loop cannot handle spaces in the RHS.
    dnl
    ac_tmp_var=`echo $ac_tmp_opt | sed -e "s/^$2//g"`
    ac_tmp_val=${!ac_tmp_opt}

    $3

  done
])

dnl
dnl CT_OPT_DEFINE(CONFIG, HEADER, LABEL_PREFIX, DEF_PREFIX)
dnl

AC_DEFUN([CT_OPT_DEFINE],
[
  CT_CONFIG_FILTER([$1], [$3_],
                   [ac_tmp_prefix=$4

                    dnl
                    dnl We treate a bool with yes and no with special care.
                    dnl
                    AS_IF([test x"$ac_tmp_val" = x"yes"],
                          [ac_tmp_val=1
                           ac_tmp_prefix="HAVE_$4"],
                          )
                    AS_IF([test x"$ac_tmp_val" = x"no"],
                          [ac_tmp_val=0
                           ac_tmp_prefix="HAVE_$4"],
                          )

                    dnl
                    dnl I tried to use the AC_DEFINE_* macro but could not seem to
                    dnl get a working config header so we will just make it and
                    dnl comment the autoconf way of doing it.
                    dnl
                    dnl AC_DEFINE_UNQUOTED($prefix$var, $val)

                    cat >> $2 << _EOF_
#define ${ac_tmp_prefix}_$ac_tmp_var ($ac_tmp_val)
_EOF_
                    ])
])

dnl
dnl CT_CHECK_BOARD(BOARD, CONFIG, PATH [, PACKAGE])
dnl

AC_DEFUN([CT_CHECK_BOARD],
[
  AC_REQUIRE([CT_PREFIX])

  AC_MSG_CHECKING([for $1])

  ac_tmp_path=$3

  dnl
  dnl Get the path back to the top of the source tree.
  dnl
  AS_IF([test x`echo $ac_tmp_path | sed -e "s/^\/.*/yes/"` = xyes ||
         test x`echo $ac_tmp_path | sed -e "s/^.:.*/yes/"` = xyes],
        [ac_tmp_srcdir=$ac_tmp_path],
        [CT_SRC_TOP($topdir, $srcdir, ac_tmp_srcdir)
         ac_tmp_srcdir=$ac_tmp_srcdir/$3])

  CT_PATH_MUNCH($ac_tmp_srcdir, ac_tmp_srcdir)

  dnl
  dnl See if a board directory exists ?
  dnl
  AS_IF([test ! -d ${ac_tmp_srcdir}],
        [AC_MSG_RESULT([no])
         AC_MSG_ERROR([No configuration directory for $1 found in \"$ac_tmp_srcdir\".])])

  CT_BOARD=$1

  dnl
  dnl Check the path is not no or the following logic will
  dnl fail.
  dnl
  AS_IF([test x$ac_tmp_srcdir = xno],
        AC_MSG_ERROR([configuration path for $2 is no and cannot be name]))

  ac_tmp_ct_path=no

  dnl
  dnl The board must provide a configuration file with the various
  dnl board configurations. The configuration file could be in
  dnl the specified path, or a package type include directory under
  dnl the path plus the package.
  dnl
  AS_IF([test -f ${ac_tmp_srcdir}/$2],
        [ac_tmp_ct_config=${ac_tmp_srcdir}/$2
         ac_tmp_ct_path=${ac_tmp_srcdir}
         ac_tmp_ct_inc_path=${ac_tmp_srcdir}
         ac_tmp_ct_lib_path=${ac_tmp_srcdir}],
        [AS_IF([test -f ${ac_tmp_srcdir}/lib/$4/$2],
               [ac_tmp_ct_config=${ac_tmp_srcdir}/lib/$4/$2
                ac_tmp_ct_path=${ac_tmp_srcdir}
                ac_tmp_ct_inc_path=${ac_tmp_srcdir}/include/$4
                ac_tmp_ct_lib_path=${ac_tmp_srcdir}/lib/$4],
               [AS_IF([test -f ${ac_tmp_srcdir}/include/$4/$4.h],
                      [ac_tmp_ct_path=${ac_tmp_srcdir}
                       ac_tmp_ct_inc_path=${ac_tmp_srcdir}/include/$4
                       ac_tmp_ct_lib_path=${ac_tmp_srcdir}/lib/$4])])])

  AS_IF([test x$ac_tmp_ct_path = xno],
        [AC_MSG_RESULT([no])
         AC_MSG_ERROR([No \"$2\" found for board $1 under \"${ac_tmp_srcdir}\"])])

  CT_PATH_MUNCH($ac_tmp_ct_config,   CT_CONFIG)
  CT_PATH_MUNCH($ac_tmp_ct_path,     CT_PATH)
  CT_PATH_MUNCH($ac_tmp_ct_inc_path, CT_INC_PATH)
  CT_PATH_MUNCH($ac_tmp_ct_lib_path, CT_LIB_PATH)

  dnl
  dnl If the configuration is nothing, see is a bsp.h is present and 
  dnl use that.
  dnl
  AS_IF([test "x$CT_CONFIG" == "x"],
        [AS_IF([test -f ${ac_tmp_srcdir}/include/$4/bsp.h],
               [AC_MSG_RESULT([${ac_tmp_srcdir}/include/$4/bsp.h])],
               [AC_MSG_RESULT([no])
                AC_MSG_ERROR([No bsp.h found for board $1 under \"$CT_INC_PATH\"])])],
        [AC_MSG_RESULT([$CT_CONFIG])])
])

dnl
dnl CT_BOARD_MAKEFILE(BOARD, CONFIG-SUPPORT)
dnl

AC_DEFUN([CT_BOARD_MAKEFILE],
[
  AC_REQUIRE([CT_CHECK_BOARD])

  AC_MSG_CHECKING([for $1 configuration])

  AS_IF([test "x$CT_CONFIG" != "x"],
        [AS_IF([test -f $CT_CONFIG],
               [AC_SUBST(CT_BOARD)
                AC_SUBST(CT_CONFIG)
                AC_SUBST(CT_PATH)
                AC_SUBST(CT_INC_PATH)
                AC_SUBST(CT_LIB_PATH)
                . $CT_CONFIG
                AC_MSG_RESULT([valid])],
               [AC_MSG_RESULT([not found])])],
         [AC_MSG_RESULT([not valid])])
  dnl
  dnl Call the CONFIG-SUPPORT
  dnl
  $2
])

dnl
dnl CT_BOARD_HEADER(BOARD, HEADER, LABEL, DEFINE)
dnl

AC_DEFUN([CT_BOARD_HEADER],
[
  AC_MSG_CHECKING([for $1 header])

  ac_tmp_header_def=`echo $2 | sed -e "s/\\./_/g" -e "s/\\//_/g"`

  cat > "$2" << _EOF_
/* -*- Mode: C -*-
 * DO NOT EDIT THIS FILE! It has been automatically generated
 * on host:  `(hostname || uname -n) 2>/dev/null | sed 1q`
 */

#if !defined(_ct_${ac_tmp_header_def}_)
#define _ct_${ac_tmp_header_def}_

#ifndef __cplusplus
/*
 * Put here to get things to build.
 */
#if !defined(__ASSEMBLER__)
typedef unsigned char bool;
#define true  (1)
#define false (0)
#endif
#endif

#if __cplusplus
extern "C"
{
#endif

#include <$1.h>

_EOF_

  AS_IF([test "x$CT_CONFIG" != "x"],
        [CT_OPT_DEFINE($CT_CONFIG, $2, $3_OPT, $4)])

  cat >> "$2" << _EOF_

#if __cplusplus
}
#endif

#endif
_EOF_

  AC_MSG_RESULT([$2 created])
])

dnl
dnl CT_RTEMS([CPU], [BSP], [TARGET])
dnl
AC_DEFUN([CT_RTEMS],
[
  AC_MSG_CHECKING([for RTEMS target])
  case "$target" in
    *-rtems)
      AC_MSG_RESULT(yes)
      os_rtems=yes
      CT_ENABLE_RTEMS_CPU($1)
      CT_ENABLE_RTEMS($rtems_cpu)
#      CT_ENABLE_RTEMS_BSP($2, BOARD, $3)
      CPPFLAGS="$CPPFLAGS -I $rtems_bsp_inc_path"
      os_header="os/rtems"
      AC_SUBST(OS_HEADER, $os_header)
      AM_CONDITIONAL(RTEMS, true)
      ;;
    *)
      AM_CONDITIONAL(RTEMS, false)
      AC_MSG_RESULT(no)
      ;;
  esac
])

dnl
dnl CT_RTEMS_APP([BSP_LABEL])
dnl
AC_DEFUN([CT_RTEMS_APP],
[
  case "$target" in
    *-rtems)
      CT_CHECK_BOARD($BOARD, $BOARD.cfg, ${prefix}, $rtems_bsp)
      CT_BOARD_MAKEFILE($BOARD)
      CT_BOARD_HEADER($BOARD, target.h, $1, $1)
      AC_SUBST(RTEMS_BSP_LIB, "-l$MRB_BOARD-bsp -l$MRB_BOARD")
      ;;
    *)
      ;;
  esac
])

dnl
dnl CT_POSIX()
dnl
AC_DEFUN([CT_POSIX],
[
  AC_MSG_CHECKING([for POSIX target])
  os_posix=no
  os_linux=no
  os_bsd=no
  os_freebsd=no
  os_netbsd=no
  os_openbsd=no
  case "$target" in
    *-linux*)
      os_linux=yes
      os_posix=yes
      os_header="os/posix"
      AC_SUBST(OS_HEADER, $os_header)
      AC_MSG_RESULT(yes)
      ;;
    *freebsd*)
      os_freebsd=yes
      os_bsd=yes
      os_posix=yes
      os_header="os/posix"
      AC_SUBST(OS_HEADER, $os_header)
      AC_MSG_RESULT(yes)
      ;;
    *netbsd*)
      os_netbsd=yes
      os_bsd=yes
      os_posix=yes
      os_header="os/posix"
      AC_SUBST(OS_HEADER, $os_header)
      AC_MSG_RESULT(yes)
      ;;
    *openbsd*)
      os_openbsd=yes
      os_bsd=yes
      os_posix=yes
      os_header="os/posix"
      AC_SUBST(OS_HEADER, $os_header)
      AC_MSG_RESULT(yes)
      ;;
    *)
      AC_MSG_RESULT(no)
      ;;
  esac
  AM_CONDITIONAL(LINUX,   test $os_linux = yes)
  AM_CONDITIONAL(BSD,     test $os_bsd = yes)
  AM_CONDITIONAL(FREEBSD, test $os_freebsd = yes)
  AM_CONDITIONAL(NETBSD,  test $os_netbsd = yes)
  AM_CONDITIONAL(OPENBSD, test $os_openbsd = yes)
  AM_CONDITIONAL(POSIX,   test $os_posix = yes)
])

dnl
dnl CT_UPLOAD_PATH()
dnl
AC_DEFUN([CT_UPLOAD_PATH],
[
  AC_MSG_CHECKING([for upload path])
  AC_ARG_ENABLE(upload,
                AC_HELP_STRING([--enable-upload],
                               [specify an upload directory to place build executables]),
                upload=${enableval},
                upload=no)
  AS_IF([test x$upload != xno],
        [AS_IF([test ! -d $upload], 
               [AC_MSG_RESULT(no)
                AC_MSG_ERROR([upload path not found])])
         upload=$(echo $upload | sed -e 's/\/$//g')/
         AC_SUBST(UPLOAD_PATH, $upload)
         AC_MSG_RESULT($upload)],
         AC_MSG_RESULT(no))
  AM_CONDITIONAL(UPLOAD, test x$upload != xno)
])
