/*
 *  FAT Initialization
 *
 *  Copyright(C) 2001
 *  Camilo Alejandro Arboleda
 *
 *  The contents of this file are distributed under the GNU General
 *  Public License version 2.
 *
 *  As a special exception, when this code is included in the RTEMS
 *  operating system, linking other files with RTEMS objects including
 *  this code does not cause the resulting executable application to
 *  be covered by the GNU General Public License. This exception does
 *  not however invalidate any other reasons why the executable file might
 *  be covered by the GNU General Public License.
 */

#include <sys/types.h>         /* for mkdir */
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include <assert.h>

#include "fat.h"

#if defined(FAT_DEBUG)
#include <stdio.h>
#endif

/*  
 *  FAT file system operations table
 */

rtems_filesystem_operations_table  FAT_ops = {
  FAT_eval_path,/* Evaluate path */
  FAT_evaluate_for_make, /**/
  FAT_link, /**/
  FAT_rmnod, /* FAT_unlink,/ **/
  FAT_node_type, /* Node type */
  FAT_mknod,/**/
  NULL, /* FAT_chown, / **/
  FAT_freenodinfo, /**/
  NULL, /* mount / **/
  FAT_initialize,
  NULL, /* FAT_unmount / **/
  NULL, /* FAT_fsunmount, / **/
  NULL, /* FAT_utime,/ **/
  NULL, /* FAT_evaluate_link  / **/
  NULL, /* FAT_symlink,  / **/
  NULL  /* FAT_readlink / **/
};

/*
 *  Set of operations handlers for operations on directories.
 */

rtems_filesystem_file_handlers_r FAT_directory_handlers = {
  FAT_dir_open,     /* open */
  FAT_dir_close,    /* close */
  FAT_dir_read,     /* read */
  NULL,             /* write */
  NULL,             /* ioctl */
  FAT_dir_lseek,    /* seek */
  FAT_dir_fstat,    /* stat */
  NULL, /* FAT_dir_fchmod,       /* chmod */
  NULL, /* ftruncate */
  NULL, /* fpathconf */
  NULL, /* fsync */
  NULL, /* FAT_dir_fdatasync,    /* data sync */
  NULL, /* FAT_dir_fcntl,        /* fcntl */
  NULL, /* FAT_dir_rmnod     /* rmnod */
};



/*
 *  Set of operations handlers for operations on fat entities.
 */

rtems_filesystem_file_handlers_r FAT_file_handlers = {
  FAT_file_open,  /**/
  FAT_file_close,  /**/
  FAT_file_read,  /**/
  FAT_file_write,  /**/
  NULL, /* FAT_file_ioctl,  /**/
  FAT_file_lseek,  /**/
  FAT_file_stat,   /**/
  NULL, /* FAT_file_fchmod,  /**/
  FAT_file_truncate,  /**/
  NULL, /* fpathconf */
  NULL, /* FAT_file_fdatasync,      /* fsync */
  NULL, /* FAT_file_fdatasync,  /**/
  NULL, /* FAT_file_fcntl,  /**/
  FAT_rmnod  /**/
};

FAT_jnode_t *fat_root_dir;
FAT_jnode_t *fat_tail;
