#ifndef product_h__
#define product_h__
///////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva
//  
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
//  
// DESCRIPTION:
// Class sample for the Storable Framework. It maps to a table called
// "Prodcut" that has the columns:
//   "CREATE TABLE Product ( " 
//   "  ID       INTEGER DEFAULT 0 AUTO_INCREMENT PRIMARY KEY," 
//   "  NAME     VARCHAR( 80 ) NOT NULL," 
//   "  PRICE    FLOAT DEFAULT 0.0,"  
//   "  QTY      INTEGER DEFAULT 0 )" ); 
//
// HISTORY:
//
// $Log: makefile.mak,v $
//
///////////////////////////////////////////////////////////////////////////

#include <string>
#include <vector>

#include "storable.h"

/**
 * This class maps the Product table of the GroceryPicks database. 
 */
class Product:   public ssf::Storable
{
private:
   std::string whereClause;
   std::string updateValues;
   std::string insertValues;

   long   id;
   std::string name;
   long   qty;
   float  price;

 public:

    static const char *TABLE_NAME;

   // field accessors...
   long   getId() const        { return id; }
   void   setId( long i )      { id = i; }

   std::string  getName() const   { return name; }
   void   setName( const std::string & n ) { name = name; }

   long   getQty() const       { return qty; }
   void   setQty( long quant ) { qty = quant; }

   float  getPrice() const      { return price; }
   void   setPrice( float prc ) { price = prc; }


   /**
    * Creates one instance that is not mapped to a row on the DB.
    * This Ctor is used to create "new" instances to be written to
    * the DB.
    */
    Product();

   /**
    * Creates one instance based on the ID.
    */
    Product( long prod_id , ssf::Connection *c );

   /** 
    * Unique ID for the instance.
    */
    virtual long getUniqueId() { return id; }

   /** 
    * This method stracts the fields from a ResultSet and maps to the 
    * data members of this class.
    */
    bool mapping( ssf::ResultSet *rs );

   /** 
    *
    * Returns a list of instances matching the criteria of the
    * "where clause".
    *
    */
    static ssf::StorableFactory< Product >::StorableList *getList
    ( 
       ssf::Connection *c,
       const char *where 
    )
    {
       return ssf::StorableFactory< Product >::getList( c, where );
    }

   /** 
    * Format the internal representation of this instance.
    */
    std::string toString();


protected:

   /** 
    */
    virtual const char *getTableName() { return TABLE_NAME; }

   /** 
    * <p> 
    * Returns the string representing all fields that are present
    * on a query ( select ) of an instance of this class.
    */
    virtual const char *getColumnList() { return "ID, NAME, PRICE, QTY"; }

   /** 
    * INSERT's string...
    */
    virtual const char *getColumnListForInsert();

   /** 
    * <p> 
    * Returns the string representing all fields that are present
    * on a query ( select ) of an instance of this class.
    */
    virtual const char *getWhereClause();

   /** 
    * <p> Returns the string representing all "values" that need to be
    *	 present during the insertion of a new "row" to the table.
    */
    virtual const char *getInsertValues();
 
   /** 
    * Returns string representing the "SET" of values of an update statement.
    */
    virtual const char * getUpdateValues();


   /** 
    * This function is called after one updated is performed. It allows
    * the instance to fetch a possible new "ID" for the object.
    */
    virtual void setPKAfterInsert( ssf::Connection *c ) 
    { 
       id = (long)c->idAfterInsert();
    }

private:

    void setDefault();
};

#endif //  product_h__

